/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.put;

import java.util.Map;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptAction;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;

public class PutIndexedScriptRequestBuilder
extends ActionRequestBuilder<PutIndexedScriptRequest, PutIndexedScriptResponse, PutIndexedScriptRequestBuilder> {
    public PutIndexedScriptRequestBuilder(ElasticsearchClient client, PutIndexedScriptAction action) {
        super(client, action, new PutIndexedScriptRequest());
    }

    public PutIndexedScriptRequestBuilder setScriptLang(String scriptLang) {
        ((PutIndexedScriptRequest)this.request).scriptLang(scriptLang);
        return this;
    }

    public PutIndexedScriptRequestBuilder setId(String id) {
        ((PutIndexedScriptRequest)this.request).id(id);
        return this;
    }

    public PutIndexedScriptRequestBuilder setSource(BytesReference source) {
        ((PutIndexedScriptRequest)this.request).source(source);
        return this;
    }

    public PutIndexedScriptRequestBuilder setSource(Map<String, Object> source) {
        ((PutIndexedScriptRequest)this.request).source(source);
        return this;
    }

    public PutIndexedScriptRequestBuilder setSource(Map<String, Object> source, XContentType contentType) {
        ((PutIndexedScriptRequest)this.request).source(source, contentType);
        return this;
    }

    public PutIndexedScriptRequestBuilder setSource(String source) {
        ((PutIndexedScriptRequest)this.request).source(source);
        return this;
    }

    public PutIndexedScriptRequestBuilder setSource(XContentBuilder sourceBuilder) {
        ((PutIndexedScriptRequest)this.request).source(sourceBuilder);
        return this;
    }

    public PutIndexedScriptRequestBuilder setSource(byte[] source) {
        ((PutIndexedScriptRequest)this.request).source(source);
        return this;
    }

    public PutIndexedScriptRequestBuilder setSource(byte[] source, int offset, int length) {
        ((PutIndexedScriptRequest)this.request).source(source, offset, length);
        return this;
    }

    public PutIndexedScriptRequestBuilder setSource(Object ... source) {
        ((PutIndexedScriptRequest)this.request).source(source);
        return this;
    }

    public PutIndexedScriptRequestBuilder setContentType(XContentType contentType) {
        ((PutIndexedScriptRequest)this.request).contentType(contentType);
        return this;
    }

    public PutIndexedScriptRequestBuilder setOpType(IndexRequest.OpType opType) {
        ((PutIndexedScriptRequest)this.request).opType(opType);
        return this;
    }

    public PutIndexedScriptRequestBuilder setOpType(String opType) {
        ((PutIndexedScriptRequest)this.request).opType(IndexRequest.OpType.fromString(opType));
        return this;
    }

    public PutIndexedScriptRequestBuilder setCreate(boolean create) {
        ((PutIndexedScriptRequest)this.request).create(create);
        return this;
    }

    public PutIndexedScriptRequestBuilder setVersion(long version) {
        ((PutIndexedScriptRequest)this.request).version(version);
        return this;
    }

    public PutIndexedScriptRequestBuilder setVersionType(VersionType versionType) {
        ((PutIndexedScriptRequest)this.request).versionType(versionType);
        return this;
    }
}

