/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

public enum Preference {
    SHARDS("_shards"),
    PREFER_NODE("_prefer_node"),
    LOCAL("_local"),
    PRIMARY("_primary"),
    REPLICA("_replica"),
    PRIMARY_FIRST("_primary_first"),
    REPLICA_FIRST("_replica_first"),
    ONLY_LOCAL("_only_local"),
    ONLY_NODE("_only_node"),
    ONLY_NODES("_only_nodes");

    private final String type;

    private Preference(String type) {
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    public static Preference parse(String preference) {
        int colonIndex = preference.indexOf(58);
        String preferenceType = colonIndex == -1 ? preference : preference.substring(0, colonIndex);
        switch (preferenceType) {
            case "_shards": {
                return SHARDS;
            }
            case "_prefer_node": {
                return PREFER_NODE;
            }
            case "_only_node": {
                return ONLY_NODE;
            }
            case "_local": {
                return LOCAL;
            }
            case "_primary": {
                return PRIMARY;
            }
            case "_replica": {
                return REPLICA;
            }
            case "_primary_first": 
            case "_primaryFirst": {
                return PRIMARY_FIRST;
            }
            case "_replica_first": 
            case "_replicaFirst": {
                return REPLICA_FIRST;
            }
            case "_only_local": 
            case "_onlyLocal": {
                return ONLY_LOCAL;
            }
            case "_only_nodes": {
                return ONLY_NODES;
            }
        }
        throw new IllegalArgumentException("no Preference for [" + preferenceType + "]");
    }
}

