/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;

public class ByteSizeValue
implements Streamable {
    private long size;
    private ByteSizeUnit sizeUnit;

    private ByteSizeValue() {
    }

    public ByteSizeValue(long bytes) {
        this(bytes, ByteSizeUnit.BYTES);
    }

    public ByteSizeValue(long size, ByteSizeUnit sizeUnit) {
        this.size = size;
        this.sizeUnit = sizeUnit;
    }

    public int bytesAsInt() {
        long bytes = this.bytes();
        if (bytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size [" + this.toString() + "] is bigger than max int");
        }
        return (int)bytes;
    }

    public long bytes() {
        return this.sizeUnit.toBytes(this.size);
    }

    public long getBytes() {
        return this.bytes();
    }

    public long kb() {
        return this.sizeUnit.toKB(this.size);
    }

    public long getKb() {
        return this.kb();
    }

    public long mb() {
        return this.sizeUnit.toMB(this.size);
    }

    public long getMb() {
        return this.mb();
    }

    public long gb() {
        return this.sizeUnit.toGB(this.size);
    }

    public long getGb() {
        return this.gb();
    }

    public long tb() {
        return this.sizeUnit.toTB(this.size);
    }

    public long getTb() {
        return this.tb();
    }

    public long pb() {
        return this.sizeUnit.toPB(this.size);
    }

    public long getPb() {
        return this.pb();
    }

    public double kbFrac() {
        return (double)this.bytes() / 1024.0;
    }

    public double getKbFrac() {
        return this.kbFrac();
    }

    public double mbFrac() {
        return (double)this.bytes() / 1048576.0;
    }

    public double getMbFrac() {
        return this.mbFrac();
    }

    public double gbFrac() {
        return (double)this.bytes() / 1.073741824E9;
    }

    public double getGbFrac() {
        return this.gbFrac();
    }

    public double tbFrac() {
        return (double)this.bytes() / 1.099511627776E12;
    }

    public double getTbFrac() {
        return this.tbFrac();
    }

    public double pbFrac() {
        return (double)this.bytes() / 1.125899906842624E15;
    }

    public double getPbFrac() {
        return this.pbFrac();
    }

    public String toString() {
        long bytes = this.bytes();
        double value = bytes;
        String suffix = "b";
        if (bytes >= 0x4000000000000L) {
            value = this.pbFrac();
            suffix = "pb";
        } else if (bytes >= 0x10000000000L) {
            value = this.tbFrac();
            suffix = "tb";
        } else if (bytes >= 0x40000000L) {
            value = this.gbFrac();
            suffix = "gb";
        } else if (bytes >= 0x100000L) {
            value = this.mbFrac();
            suffix = "mb";
        } else if (bytes >= 1024L) {
            value = this.kbFrac();
            suffix = "kb";
        }
        return Strings.format1Decimals(value, suffix);
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue, String settingName) throws ElasticsearchParseException {
        return ByteSizeValue.parseBytesSizeValue(sValue, null, settingName);
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue, ByteSizeValue defaultValue, String settingName) throws ElasticsearchParseException {
        long bytes;
        settingName = Objects.requireNonNull(settingName);
        assert (!settingName.startsWith("index.") || MetaDataIndexUpgradeService.INDEX_BYTES_SIZE_SETTINGS.contains(settingName));
        if (sValue == null) {
            return defaultValue;
        }
        try {
            String lowerSValue = sValue.toLowerCase(Locale.ROOT).trim();
            if (lowerSValue.endsWith("k")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1024.0);
            } else if (lowerSValue.endsWith("kb")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1024.0);
            } else if (lowerSValue.endsWith("m")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1048576.0);
            } else if (lowerSValue.endsWith("mb")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1048576.0);
            } else if (lowerSValue.endsWith("g")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1.073741824E9);
            } else if (lowerSValue.endsWith("gb")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1.073741824E9);
            } else if (lowerSValue.endsWith("t")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1.099511627776E12);
            } else if (lowerSValue.endsWith("tb")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1.099511627776E12);
            } else if (lowerSValue.endsWith("p")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1.125899906842624E15);
            } else if (lowerSValue.endsWith("pb")) {
                bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1.125899906842624E15);
            } else if (lowerSValue.endsWith("b")) {
                bytes = Long.parseLong(lowerSValue.substring(0, lowerSValue.length() - 1).trim());
            } else if (lowerSValue.equals("-1")) {
                bytes = -1L;
            } else if (lowerSValue.equals("0")) {
                bytes = 0L;
            } else {
                if (Settings.getSettingsRequireUnits()) {
                    throw new ElasticsearchParseException("failed to parse setting [{}] with value [{}] as a size in bytes: unit is missing or unrecognized", settingName, sValue);
                }
                bytes = Long.parseLong(sValue);
            }
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchParseException("failed to parse [{}]", (Throwable)e, sValue);
        }
        return new ByteSizeValue(bytes, ByteSizeUnit.BYTES);
    }

    public static ByteSizeValue readBytesSizeValue(StreamInput in) throws IOException {
        ByteSizeValue sizeValue = new ByteSizeValue();
        sizeValue.readFrom(in);
        return sizeValue;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.size = in.readVLong();
        this.sizeUnit = ByteSizeUnit.BYTES;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteSizeValue sizeValue = (ByteSizeValue)o;
        return this.bytes() == sizeValue.bytes();
    }

    public int hashCode() {
        int result = (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.sizeUnit != null ? this.sizeUnit.hashCode() : 0);
        return result;
    }
}

