/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.morelikethis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.Fields;
import org.elasticsearch.action.termvectors.MultiTermVectorsItemResponse;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.search.internal.SearchContext;

public class MoreLikeThisFetchService
extends AbstractComponent {
    private final Client client;

    @Inject
    public MoreLikeThisFetchService(Client client, Settings settings) {
        super(settings);
        this.client = client;
    }

    public Fields[] fetch(List<MoreLikeThisQueryBuilder.Item> items) throws IOException {
        return MoreLikeThisFetchService.getFieldsFor(this.fetchResponse(items, null, SearchContext.current()), items);
    }

    public MultiTermVectorsResponse fetchResponse(List<MoreLikeThisQueryBuilder.Item> likeItems, @Nullable List<MoreLikeThisQueryBuilder.Item> unlikeItems, SearchContext searchContext) throws IOException {
        MultiTermVectorsRequest request = new MultiTermVectorsRequest();
        for (MoreLikeThisQueryBuilder.Item item : likeItems) {
            request.add(item.toTermVectorsRequest());
        }
        if (unlikeItems != null) {
            for (MoreLikeThisQueryBuilder.Item item : unlikeItems) {
                request.add(item.toTermVectorsRequest());
            }
        }
        request.copyContextAndHeadersFrom(searchContext);
        return this.client.multiTermVectors(request).actionGet();
    }

    public static Fields[] getFieldsFor(MultiTermVectorsResponse responses, List<MoreLikeThisQueryBuilder.Item> items) throws IOException {
        ArrayList<Fields> likeFields = new ArrayList<Fields>();
        HashSet<MoreLikeThisQueryBuilder.Item> selectedItems = new HashSet<MoreLikeThisQueryBuilder.Item>();
        for (MoreLikeThisQueryBuilder.Item request : items) {
            selectedItems.add(new MoreLikeThisQueryBuilder.Item(request.index(), request.type(), request.id()));
        }
        for (MultiTermVectorsItemResponse response : responses) {
            TermVectorsResponse getResponse;
            if (!MoreLikeThisFetchService.hasResponseFromRequest(response, selectedItems) || response.isFailed() || !(getResponse = response.getResponse()).isExists()) continue;
            likeFields.add(getResponse.getFields());
        }
        return likeFields.toArray(Fields.EMPTY_ARRAY);
    }

    private static boolean hasResponseFromRequest(MultiTermVectorsItemResponse response, Set<MoreLikeThisQueryBuilder.Item> selectedItems) {
        return selectedItems.contains(new MoreLikeThisQueryBuilder.Item(response.getIndex(), response.getType(), response.getId()));
    }
}

