/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.avg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.avg.InternalAvg;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class AvgAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource.Numeric valuesSource;
    LongArray counts;
    DoubleArray sums;
    ValueFormatter formatter;

    public AvgAggregator(String name, ValuesSource.Numeric valuesSource, ValueFormatter formatter, AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        if (valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                AvgAggregator.this.counts = bigArrays.grow(AvgAggregator.this.counts, bucket + 1L);
                AvgAggregator.this.sums = bigArrays.grow(AvgAggregator.this.sums, bucket + 1L);
                values.setDocument(doc);
                int valueCount = values.count();
                AvgAggregator.this.counts.increment(bucket, valueCount);
                double sum = 0.0;
                for (int i = 0; i < valueCount; ++i) {
                    sum += values.valueAt(i);
                }
                AvgAggregator.this.sums.increment(bucket, sum);
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null ? Double.NaN : this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalAvg(this.name, this.sums.get(bucket), this.counts.get(bucket), this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalAvg(this.name, 0.0, 0L, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.sums);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        public Factory(String name, String type, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig) {
            super(name, type, valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new AvgAggregator(this.name, null, this.config.formatter(), aggregationContext, parent, pipelineAggregators, metaData);
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource.Numeric valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new AvgAggregator(this.name, valuesSource, this.config.formatter(), aggregationContext, parent, pipelineAggregators, metaData);
        }
    }
}

