/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.min.MinBucketParser;
import org.elasticsearch.search.aggregations.pipeline.derivative.DerivativeParser;

public abstract class BucketMetricsBuilder<B extends BucketMetricsBuilder<B>>
extends PipelineAggregatorBuilder<B> {
    private String format;
    private BucketHelpers.GapPolicy gapPolicy;

    public BucketMetricsBuilder(String name, String type) {
        super(name, type);
    }

    public B format(String format) {
        this.format = format;
        return (B)this;
    }

    public B gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        this.gapPolicy = gapPolicy;
        return (B)this;
    }

    @Override
    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(MinBucketParser.FORMAT.getPreferredName(), this.format);
        }
        if (this.gapPolicy != null) {
            builder.field(DerivativeParser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        }
        this.doInternalXContent(builder, params);
        return builder;
    }

    protected void doInternalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }
}

