/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.core.BooleanFieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptParameterParser;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.internal.SearchContext;
import org.joda.time.DateTimeZone;

public class ValuesSourceParser<VS extends ValuesSource> {
    static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);
    private final String aggName;
    private final InternalAggregation.Type aggType;
    private final SearchContext context;
    private final Class<VS> valuesSourceType;
    private boolean scriptable = true;
    private boolean formattable = false;
    private boolean timezoneAware = false;
    private ValueType targetValueType = null;
    private ScriptParameterParser scriptParameterParser = new ScriptParameterParser();
    private Input input = new Input();

    public static Builder any(String aggName, InternalAggregation.Type aggType, SearchContext context) {
        return new Builder(aggName, aggType, context, ValuesSource.class);
    }

    public static Builder<ValuesSource.Numeric> numeric(String aggName, InternalAggregation.Type aggType, SearchContext context) {
        return new Builder(aggName, aggType, context, ValuesSource.Numeric.class).targetValueType(ValueType.NUMERIC);
    }

    public static Builder<ValuesSource.Bytes> bytes(String aggName, InternalAggregation.Type aggType, SearchContext context) {
        return new Builder(aggName, aggType, context, ValuesSource.Bytes.class).targetValueType(ValueType.STRING);
    }

    public static Builder<ValuesSource.GeoPoint> geoPoint(String aggName, InternalAggregation.Type aggType, SearchContext context) {
        return new Builder(aggName, aggType, context, ValuesSource.GeoPoint.class).targetValueType(ValueType.GEOPOINT).scriptable(false);
    }

    private ValuesSourceParser(String aggName, InternalAggregation.Type aggType, SearchContext context, Class<VS> valuesSourceType) {
        this.aggName = aggName;
        this.aggType = aggType;
        this.context = context;
        this.valuesSourceType = valuesSourceType;
    }

    public boolean token(String currentFieldName, XContentParser.Token token, XContentParser parser) throws IOException {
        if ("missing".equals(currentFieldName) && token.isValue()) {
            this.input.missing = parser.objectText();
            return true;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            if ("field".equals(currentFieldName)) {
                this.input.field = parser.text();
            } else if (this.formattable && "format".equals(currentFieldName)) {
                this.input.format = parser.text();
            } else if (this.timezoneAware && this.context.parseFieldMatcher().match(currentFieldName, TIME_ZONE)) {
                this.input.timezone = DateTimeZone.forID((String)parser.text());
            } else {
                if (this.scriptable) {
                    if ("value_type".equals(currentFieldName) || "valueType".equals(currentFieldName)) {
                        this.input.valueType = ValueType.resolveForScript(parser.text());
                        if (this.targetValueType != null && this.input.valueType.isNotA(this.targetValueType)) {
                            throw new SearchParseException(this.context, this.aggType.name() + " aggregation [" + this.aggName + "] was configured with an incompatible value type [" + (Object)((Object)this.input.valueType) + "]. [" + this.aggType + "] aggregation can only work on value of type [" + (Object)((Object)this.targetValueType) + "]", parser.getTokenLocation());
                        }
                    } else if (!this.scriptParameterParser.token(currentFieldName, token, parser, this.context.parseFieldMatcher())) {
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            if (!this.timezoneAware || !this.context.parseFieldMatcher().match(currentFieldName, TIME_ZONE)) {
                return false;
            }
            this.input.timezone = DateTimeZone.forOffsetHours((int)parser.intValue());
            return true;
        }
        if (this.scriptable && token == XContentParser.Token.START_OBJECT) {
            if (this.context.parseFieldMatcher().match(currentFieldName, Script.ScriptField.SCRIPT)) {
                this.input.script = Script.parse(parser, this.context.parseFieldMatcher());
                return true;
            }
            if ("params".equals(currentFieldName)) {
                this.input.params = parser.map();
                return true;
            }
            return false;
        }
        return false;
    }

    public ValuesSourceConfig<VS> config() {
        ValueType valueType;
        ScriptParameterParser.ScriptParameterValue scriptValue;
        if (this.input.script == null && (scriptValue = this.scriptParameterParser.getDefaultScriptParameterValue()) != null) {
            if (this.input.params == null) {
                this.input.params = Maps.newHashMap();
            }
            this.input.script = new Script(scriptValue.script(), scriptValue.scriptType(), this.scriptParameterParser.lang(), this.input.params);
        }
        ValueType valueType2 = valueType = this.input.valueType != null ? this.input.valueType : this.targetValueType;
        if (this.input.field == null) {
            Class<ValuesSource> valuesSourceType;
            if (this.input.script == null) {
                ValuesSourceConfig<ValuesSource> config = new ValuesSourceConfig<ValuesSource>(ValuesSource.class);
                config.format = ValuesSourceParser.resolveFormat(null, valueType);
                return config;
            }
            Class<ValuesSource> clazz = valuesSourceType = valueType != null ? valueType.getValuesSourceType() : this.valuesSourceType;
            if (valuesSourceType == null || valuesSourceType == ValuesSource.class) {
                valuesSourceType = ValuesSource.Bytes.class;
            }
            ValuesSourceConfig<? extends ValuesSource> config = new ValuesSourceConfig<ValuesSource>(valuesSourceType);
            config.missing = this.input.missing;
            config.format = ValuesSourceParser.resolveFormat(this.input.format, valueType);
            config.script = this.createScript();
            config.scriptValueType = valueType;
            return config;
        }
        MappedFieldType fieldType = this.context.smartNameFieldTypeFromAnyType(this.input.field);
        if (fieldType == null) {
            Class<ValuesSource> valuesSourceType = valueType != null ? valueType.getValuesSourceType() : this.valuesSourceType;
            ValuesSourceConfig<? extends ValuesSource> config = new ValuesSourceConfig<ValuesSource>(valuesSourceType);
            config.missing = this.input.missing;
            config.format = ValuesSourceParser.resolveFormat(this.input.format, valueType);
            config.unmapped = true;
            if (valueType != null) {
                config.scriptValueType = valueType;
            }
            return config;
        }
        Object indexFieldData = this.context.fieldData().getForField(fieldType);
        ValuesSourceConfig<Object> config = this.valuesSourceType == ValuesSource.class ? (indexFieldData instanceof IndexNumericFieldData ? new ValuesSourceConfig<ValuesSource.Numeric>(ValuesSource.Numeric.class) : (indexFieldData instanceof IndexGeoPointFieldData ? new ValuesSourceConfig<ValuesSource.GeoPoint>(ValuesSource.GeoPoint.class) : new ValuesSourceConfig<ValuesSource.Bytes>(ValuesSource.Bytes.class))) : new ValuesSourceConfig<VS>(this.valuesSourceType);
        config.fieldContext = new FieldContext(this.input.field, (IndexFieldData<?>)indexFieldData, fieldType);
        config.missing = this.input.missing;
        config.script = this.createScript();
        config.format = ValuesSourceParser.resolveFormat(this.input.format, this.input.timezone, fieldType);
        return config;
    }

    private SearchScript createScript() {
        return this.input.script == null ? null : this.context.scriptService().search(this.context.lookup(), this.input.script, ScriptContext.Standard.AGGS);
    }

    private static ValueFormat resolveFormat(@Nullable String format, @Nullable ValueType valueType) {
        if (valueType == null) {
            return ValueFormat.RAW;
        }
        ValueFormat valueFormat = valueType.defaultFormat;
        if (valueFormat != null && valueFormat instanceof ValueFormat.Patternable && format != null) {
            return ((ValueFormat.Patternable)valueFormat).create(format);
        }
        return valueFormat;
    }

    private static ValueFormat resolveFormat(@Nullable String format, @Nullable DateTimeZone timezone, MappedFieldType fieldType) {
        if (fieldType instanceof DateFieldMapper.DateFieldType) {
            return format != null ? ValueFormat.DateTime.format(format, timezone) : ValueFormat.DateTime.mapper((DateFieldMapper.DateFieldType)fieldType, timezone);
        }
        if (fieldType instanceof IpFieldMapper.IpFieldType) {
            return ValueFormat.IPv4;
        }
        if (fieldType instanceof BooleanFieldMapper.BooleanFieldType) {
            return ValueFormat.BOOLEAN;
        }
        if (fieldType instanceof NumberFieldMapper.NumberFieldType) {
            return format != null ? ValueFormat.Number.format(format) : ValueFormat.RAW;
        }
        return ValueFormat.RAW;
    }

    public Input input() {
        return this.input;
    }

    public static class Builder<VS extends ValuesSource> {
        private final ValuesSourceParser<VS> parser;

        private Builder(String aggName, InternalAggregation.Type aggType, SearchContext context, Class<VS> valuesSourceType) {
            this.parser = new ValuesSourceParser(aggName, aggType, context, valuesSourceType);
        }

        public Builder<VS> scriptable(boolean scriptable) {
            ((ValuesSourceParser)this.parser).scriptable = scriptable;
            return this;
        }

        public Builder<VS> formattable(boolean formattable) {
            ((ValuesSourceParser)this.parser).formattable = formattable;
            return this;
        }

        public Builder<VS> timezoneAware(boolean timezoneAware) {
            ((ValuesSourceParser)this.parser).timezoneAware = timezoneAware;
            return this;
        }

        public Builder<VS> targetValueType(ValueType valueType) {
            ((ValuesSourceParser)this.parser).targetValueType = valueType;
            return this;
        }

        public ValuesSourceParser<VS> build() {
            return this.parser;
        }
    }

    public static class Input {
        private String field = null;
        private Script script = null;
        @Deprecated
        private Map<String, Object> params = null;
        private ValueType valueType = null;
        private String format = null;
        private Object missing = null;
        private DateTimeZone timezone = DateTimeZone.UTC;

        public DateTimeZone timezone() {
            return this.timezone;
        }
    }
}

