var baseTimes = require('./baseTimes'),
    isArguments = require('../isArguments'),
    isArray = require('../isArray'),
    isLength = require('../isLength'),
    isString = require('../isString');

/**
 * Creates an array of index keys for `object` values of arrays,
 * `arguments` objects, and strings, otherwise `null` is returned.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array|null} Returns index keys, else `null`.
 */
function indexKeys(object) {
  var length = object ? object.length : undefined;
  return (isLength(length) && (isArray(object) || isString(object) || isArguments(object)))
    ? baseTimes(length, String)
    : null;
}

module.exports = indexKeys;
