/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;

public class Europe
extends UnitLocation
implements Ownable,
Named,
TradeLocation {
    private static final Logger logger = Logger.getLogger(Europe.class.getName());
    private static final int RECRUIT_PRICE_INITIAL = 200;
    private static final int LOWER_CAP_INITIAL = 80;
    public static final String UNIT_CHANGE = "unitChange";
    public static final Ability ABILITY_DRESS_MISSIONARY = new Ability("model.ability.dressMissionary", true);
    protected final List<UnitType> recruitables = new ArrayList<UnitType>();
    protected final Map<UnitType, Integer> unitPrices = new HashMap<UnitType, Integer>();
    protected int recruitPrice;
    protected int recruitLowerCap;
    private Player owner;
    private final FeatureContainer featureContainer = new FeatureContainer();
    private static final String OWNER_TAG = "owner";
    private static final String PRICE_TAG = "price";
    private static final String RECRUIT_TAG = "recruit";
    private static final String RECRUIT_ID_TAG = "id";
    private static final String RECRUIT_LOWER_CAP_TAG = "recruitLowerCap";
    private static final String RECRUIT_PRICE_TAG = "recruitPrice";
    private static final String UNIT_PRICE_TAG = "unitPrice";
    private static final String UNIT_TYPE_TAG = "unitType";
    private static final String UNITS_TAG = "units";
    private boolean clearRecruitables = true;

    protected Europe(Game game, Player owner) {
        super(game);
        this.owner = owner;
        this.recruitPrice = 200;
        this.recruitLowerCap = 80;
    }

    public Europe(Game game, String id) {
        super(game, id);
    }

    public List<UnitType> getRecruitables() {
        return new ArrayList<UnitType>(this.recruitables);
    }

    protected boolean addRecruitable(UnitType unitType) {
        if (this.recruitables.size() < 3) {
            this.recruitables.add(unitType);
            return true;
        }
        return false;
    }

    public int getUnitPrice(UnitType unitType) {
        Integer price = this.unitPrices.get(unitType);
        return price != null ? price.intValue() : unitType.getPrice();
    }

    public int getRecruitPrice() {
        if (!this.owner.isColonial()) {
            return -1;
        }
        int required = this.owner.getImmigrationRequired();
        int immigration = this.owner.getImmigration();
        int difference = Math.max(required - immigration, 0);
        return Math.max(this.recruitPrice * difference / required, this.recruitLowerCap);
    }

    public int getImmigration(int production) {
        Specification spec = this.getSpecification();
        int n = 0;
        for (Unit u : this.getUnitList()) {
            if (!u.isPerson()) continue;
            ++n;
        }
        n *= spec.getInteger("model.option.europeanUnitImmigrationPenalty");
        if ((n += spec.getInteger("model.option.playerImmigrationBonus")) + production < 0) {
            n = -production;
        }
        return n;
    }

    @Override
    public FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    @Override
    public FreeColGameObject getLinkTarget(Player player) {
        return this.getOwner() == player ? this : null;
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.key(this);
    }

    @Override
    public boolean add(Locatable locatable) {
        boolean result = super.add(locatable);
        if (result && locatable instanceof Unit) {
            Unit unit;
            unit.setState((unit = (Unit)locatable).canCarryUnits() ? Unit.UnitState.ACTIVE : Unit.UnitState.SENTRY);
        }
        return result;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable instanceof Goods) {
            return true;
        }
        return super.canAdd(locatable);
    }

    @Override
    public Location up() {
        return this;
    }

    @Override
    public int getRank() {
        return -2;
    }

    @Override
    public String toShortString() {
        return "Europe";
    }

    @Override
    public int priceGoods(List<AbstractGoods> goods) {
        Player player = this.getOwner();
        Market market = player.getMarket();
        int price = 0;
        for (AbstractGoods ag : goods) {
            if (ag.getAmount() <= 0) continue;
            GoodsType goodsType = ag.getType();
            if (!player.canTrade(goodsType)) {
                price = -1;
                break;
            }
            price += market.getBidPrice(goodsType, ag.getAmount());
        }
        return price;
    }

    @Override
    public boolean equipForRole(Unit unit, Role role, int roleCount) {
        throw new RuntimeException("Only valid in the server.");
    }

    @Override
    public String getNameKey() {
        return this.getOwner().getEuropeNameKey();
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGoodsCount(GoodsType goodsType) {
        return 10000;
    }

    @Override
    public int getExportAmount(GoodsType goodsType, int turns) {
        return this.getOwner().canTrade(goodsType) ? 10000 : 0;
    }

    @Override
    public int getImportAmount(GoodsType goodsType, int turns) {
        return this.getOwner().canTrade(goodsType) ? 10000 : 0;
    }

    @Override
    public void disposeResources() {
        Player owner = this.getOwner();
        if (owner != null) {
            owner.setEurope(null);
            HighSeas highSeas = owner.getHighSeas();
            if (highSeas != null) {
                highSeas.removeDestination(this);
            }
        }
        super.disposeResources();
    }

    @Override
    public Set<Ability> getAbilities(String id, FreeColGameObjectType fcgot, Turn turn) {
        Set<Ability> result = super.getAbilities(id, fcgot, turn);
        if (id == null || "model.ability.dressMissionary".equals(id)) {
            result.add(ABILITY_DRESS_MISSIONARY);
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (xw.validFor(this.getOwner())) {
            xw.writeAttribute(RECRUIT_PRICE_TAG, this.recruitPrice);
            xw.writeAttribute(RECRUIT_LOWER_CAP_TAG, this.recruitLowerCap);
            xw.writeAttribute(OWNER_TAG, this.owner);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this.getOwner())) {
            for (Ability ability : this.getSortedAbilities()) {
                ability.toXML(xw);
            }
            for (Modifier modifier : this.getSortedModifiers()) {
                modifier.toXML(xw);
            }
            for (UnitType unitType : Europe.getSortedCopy(this.unitPrices.keySet())) {
                xw.writeStartElement(UNIT_PRICE_TAG);
                xw.writeAttribute(UNIT_TYPE_TAG, unitType);
                xw.writeAttribute(PRICE_TAG, this.unitPrices.get(unitType));
                xw.writeEndElement();
            }
            for (UnitType unitType : this.recruitables) {
                xw.writeStartElement(RECRUIT_TAG);
                xw.writeAttribute(RECRUIT_ID_TAG, unitType.getId());
                xw.writeEndElement();
            }
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        for (int index = 0; index < 3; ++index) {
            UnitType unitType = xr.getType(spec, RECRUIT_TAG + index, UnitType.class, null);
            if (unitType == null) continue;
            this.addRecruitable(unitType);
            this.clearRecruitables = false;
        }
        this.owner = xr.findFreeColGameObject(this.getGame(), OWNER_TAG, Player.class, null, true);
        this.recruitPrice = xr.getAttribute(RECRUIT_PRICE_TAG, 200);
        this.recruitLowerCap = xr.getAttribute(RECRUIT_LOWER_CAP_TAG, 80);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.unitPrices.clear();
        this.featureContainer.clear();
        if (this.clearRecruitables) {
            this.recruitables.clear();
        }
        super.readChildren(xr);
        for (Unit u : this.getUnitList()) {
            if (u.getLocation() != null) continue;
            u.setLocationNoUpdate(this);
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (Ability.getXMLElementTagName().equals(tag)) {
            this.addAbility(new Ability(xr, spec));
        } else if (Modifier.getXMLElementTagName().equals(tag)) {
            this.addModifier(new Modifier(xr, spec));
        } else if (RECRUIT_TAG.equals(tag)) {
            UnitType unitType = xr.getType(spec, RECRUIT_ID_TAG, UnitType.class, null);
            if (unitType != null) {
                this.addRecruitable(unitType);
            }
            xr.closeTag(RECRUIT_TAG);
        } else if (UNIT_PRICE_TAG.equals(tag)) {
            UnitType unitType = xr.getType(spec, UNIT_TYPE_TAG, UnitType.class, null);
            int price = xr.getAttribute(PRICE_TAG, -1);
            this.unitPrices.put(unitType, price);
            xr.closeTag(UNIT_PRICE_TAG);
        } else if (UNITS_TAG.equals(tag)) {
            while (xr.nextTag() != 2) {
                super.readChild(xr);
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        return "Europe";
    }

    @Override
    public String getXMLTagName() {
        return Europe.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "europe";
    }

    public static enum MigrationType {
        NORMAL,
        RECRUIT,
        FOUNTAIN,
        SURVIVAL;

        private static final int MIGRANT_COUNT = 3;
        private static final int CHOOSE_MIGRANT_SLOT = 0;
        private static final int DEFAULT_MIGRANT_SLOT = 1;

        public static int getMigrantCount() {
            return 3;
        }

        public static int getUnspecificSlot() {
            return 0;
        }

        public static int getDefaultSlot() {
            return 1;
        }

        public static boolean validMigrantIndex(int x) {
            return 0 <= x && x < 3;
        }

        public static int migrantIndexToSlot(int x) {
            return x + 1;
        }

        public static int migrantSlotToIndex(int x) {
            return x - 1;
        }

        public static int convertToMigrantSlot(Integer i) {
            return i == null || !MigrationType.validMigrantSlot(i) ? 0 : i;
        }

        public static boolean validMigrantSlot(int x) {
            return 0 <= x && x <= 3;
        }

        public static boolean specificMigrantSlot(int x) {
            return 1 <= x && x <= 3;
        }

        public static boolean unspecificMigrantSlot(int x) {
            return 0 == x;
        }
    }
}

