/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.Random;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;

public class ScanexTileSource
extends AbstractTMSTileSource {
    private static String API_KEY = "4018C5A9AECAD8868ED5DEB2E41D09F7";
    private ScanexLayer Layer = ScanexLayer.IRS;
    private static double RADIUS_E = 6378137.0;
    private static double EQUATOR = 4.007501668557849E7;
    private static double E = 0.0818191908426;
    private double cached_lat = 0.0;

    public ScanexTileSource(String url) {
        super("Scanex " + url, "http://maps.kosmosnimki.ru");
        for (ScanexLayer layer : ScanexLayer.values()) {
            if (!url.equalsIgnoreCase(layer.getName())) continue;
            this.Layer = layer;
            break;
        }
    }

    @Override
    public int getMaxZoom() {
        return 14;
    }

    @Override
    public String getExtension() {
        return "jpeg";
    }

    @Override
    public String getTilePath(int zoom, int tilex, int tiley) {
        int tmp = (int)Math.pow(2.0, zoom - 1);
        tiley = tmp - tiley - 1;
        return this.Layer.getUri() + "&apikey=" + API_KEY + "&x=" + (tilex -= tmp) + "&y=" + tiley + "&z=" + zoom;
    }

    @Override
    public TileSource.TileUpdate getTileUpdate() {
        return TileSource.TileUpdate.IfNoneMatch;
    }

    @Override
    public double latToTileY(double lat, int zoom) {
        double tmp = Math.tan(0.7853981633974483 * (1.0 + lat / 90.0));
        double pow = Math.pow(Math.tan(0.7853981633974483 + Math.asin(E * Math.sin(Math.toRadians(lat))) / 2.0), E);
        return (EQUATOR / 2.0 - RADIUS_E * Math.log(tmp / pow)) * Math.pow(2.0, zoom) / EQUATOR;
    }

    @Override
    public double lonToTileX(double lon, int zoom) {
        return (RADIUS_E * lon * Math.PI / (90.0 * EQUATOR) + 1.0) * Math.pow(2.0, zoom - 1);
    }

    @Override
    public double tileYToLat(int y, int zoom) {
        double lat0;
        Random r = new Random();
        double lat = this.cached_lat;
        do {
            lat0 = lat;
            if (!((lat -= Math.toDegrees(this.NextTerm(Math.toRadians(lat), y, zoom))) > 85.05112877980659) && !(lat < -85.05112877980659)) continue;
            lat = -85.05112877980659 + (double)r.nextInt(170);
        } while (Math.abs(lat0 - lat) > 1.0E-6);
        this.cached_lat = lat;
        return lat;
    }

    private double NextTerm(double lat, double y, int zoom) {
        double sinl = Math.sin(lat);
        double cosl = Math.cos(lat);
        zoom = (int)Math.pow(2.0, zoom - 1);
        double ec = Math.exp((1.0 - y / (double)zoom) * Math.PI);
        double f = Math.tan(0.7853981633974483 + lat / 2.0) - ec * Math.pow(Math.tan(0.7853981633974483 + Math.asin(E * sinl) / 2.0), E);
        double df = 1.0 / (1.0 - sinl) - ec * E * cosl / ((1.0 - E * sinl) * Math.sqrt(1.0 - E * E * sinl * sinl));
        return f / df;
    }

    @Override
    public double tileXToLon(int x, int zoom) {
        return ((double)x / Math.pow(2.0, zoom - 1) - 1.0) * (90.0 * EQUATOR) / RADIUS_E / Math.PI;
    }

    private static enum ScanexLayer {
        IRS("irs", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=BAC78D764F0443BD9AF93E7A998C9F5B"),
        SPOT("spot", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=F51CE95441284AF6B2FC319B609C7DEC");

        private String name;
        private String uri;

        private ScanexLayer(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

