## `--color`

You can partially or completely customize the default color configuration of fzf with `--color` option. 

```sh
# --color=[BASE_SCHEME][,COLOR:ANSI]
fzf --color=bg+:24
fzf --color=light,fg:232,bg:255,bg+:116,info:27
```

The name of the base color scheme is followed by custom color mappings. Ansi color code of -1 denotes terminal default foreground/background color.

The color specification can be quite long if fully customized, so it's advised that you put it in `$FZF_DEFAULT_OPTS`. You can also split it into multiple `--color`s like follows:

```sh
export FZF_DEFAULT_OPTS='
  --bind ctrl-f:page-down,ctrl-b:page-up
  --color fg:124,bg:16,hl:202,fg+:214,bg+:52,hl+:231
  --color info:52,prompt:196,spinner:208,pointer:196,marker:208
'
```

#### Base scheme

(default: dark on 256-color terminal, otherwise 16)

- `dark`    Color scheme for dark 256-color terminal
- `light`   Color scheme for light 256-color terminal
- `16`      Color scheme for 16-color terminal
- `bw`      No colors

#### Color configuration
- `fg`      Text
- `bg`      Background
- `hl`      Highlighted substrings
- `fg+`     Text (current line)
- `bg+`     Background (current line)
- `hl+`     Highlighted substrings (current line)
- `info`    Info
- `prompt`  Prompt
- `pointer` Pointer to the current line
- `marker`  Multi-select marker
- `spinner` Streaming input indicator

## Color schemes

### Red

```sh
--color fg:124,bg:16,hl:202,fg+:214,bg+:52,hl+:231
--color info:52,prompt:196,spinner:208,pointer:196,marker:208
```

![](https://cloud.githubusercontent.com/assets/700826/7895679/1ad280ba-06d6-11e5-80a8-1fef0857e8e3.png)

### Molokai

```sh
--color fg:252,bg:233,hl:67,fg+:252,bg+:235,hl+:81
--color info:144,prompt:161,spinner:135,pointer:135,marker:118
```

### Jellybeans

![](https://www.dropbox.com/s/9rte6kkct6bsz1j/fzf_jellybeans_theme.png?dl=1)

```sh
--color fg:188,bg:233,hl:103,fg+:222,bg+:234,hl+:104
--color info:183,prompt:110,spinner:107,pointer:167,marker:215
```

### JellyX

![](https://i.imgur.com/1xHOaNk.png)

```sh
--color fg:-1,bg:-1,hl:230,fg+:3,bg+:233,hl+:229
--color info:150,prompt:110,spinner:150,pointer:167,marker:174
```

### Seoul256 Night

![](https://i.imgur.com/hui2RmM.png)

```sh
--color fg:102,bg:233,hl:65,fg+:15,bg+:234,hl+:108
--color info:108,prompt:109,spinner:108,pointer:168,marker:168
```

### Solarized Dark
![](http://i.imgur.com/lrZxNTf.png)

```sh
--color=dark,hl:33,hl+:37,fg+:235,bg+:136,fg+:254
--color info:254,prompt:37,spinner:108,pointer:235,marker:235
```