/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import org.scilab.forge.jlatexmath.Box;

public class JavaFontRenderingBox
extends Box {
    private static final Graphics2D TEMPGRAPHIC = new BufferedImage(1, 1, 2).createGraphics();
    private static Font font = new Font("Serif", 0, 10);
    private String str;
    private TextLayout text;
    private float size;
    private static TextAttribute KERNING;
    private static Integer KERNING_ON;
    private static TextAttribute LIGATURES;
    private static Integer LIGATURES_ON;

    public JavaFontRenderingBox(String string, int n, float f, Font font, boolean bl) {
        Cloneable cloneable;
        this.str = string;
        this.size = f;
        if (bl && KERNING != null) {
            cloneable = new Hashtable<TextAttribute, Integer>();
            cloneable.put(KERNING, KERNING_ON);
            cloneable.put(LIGATURES, LIGATURES_ON);
            font = font.deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)((Object)cloneable));
        }
        this.text = new TextLayout(string, font.deriveFont(n), TEMPGRAPHIC.getFontRenderContext());
        cloneable = this.text.getBounds();
        this.height = (float)(-((RectangularShape)cloneable).getY() * (double)f / 10.0);
        this.depth = (float)(((RectangularShape)cloneable).getHeight() * (double)f / 10.0) - this.height;
        this.width = (float)((((RectangularShape)cloneable).getWidth() + ((RectangularShape)cloneable).getX() + (double)0.4f) * (double)f / 10.0);
    }

    public JavaFontRenderingBox(String string, int n, float f) {
        this(string, n, f, font, true);
    }

    public static void setFont(String string) {
        font = new Font(string, 0, 10);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        this.drawDebug(graphics2D, f, f2);
        graphics2D.translate(f, f2);
        graphics2D.scale(0.1 * (double)this.size, 0.1 * (double)this.size);
        this.text.draw(graphics2D, 0.0f, 0.0f);
        graphics2D.scale(10.0f / this.size, 10.0f / this.size);
        graphics2D.translate(-f, -f2);
    }

    public int getLastFontId() {
        return 0;
    }

    static {
        try {
            KERNING = (TextAttribute)TextAttribute.class.getField("KERNING").get(TextAttribute.class);
            KERNING_ON = (Integer)TextAttribute.class.getField("KERNING_ON").get(TextAttribute.class);
            LIGATURES = (TextAttribute)TextAttribute.class.getField("LIGATURES").get(TextAttribute.class);
            LIGATURES_ON = (Integer)TextAttribute.class.getField("LIGATURES_ON").get(TextAttribute.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

