/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.sonar.internal;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.MapConfiguration;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.plugins.sonar.model.ModelToPropertiesConverter;
import org.gradle.api.plugins.sonar.model.SonarModel;
import org.gradle.api.plugins.sonar.model.SonarRootModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.Batch;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SonarCodeAnalyzer
implements GroovyObject {
    private static final Logger LOGGER;
    private SonarRootModel rootModel;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SonarCodeAnalyzer() {
        MetaClass metaClass;
        CallSite[] callSiteArray = SonarCodeAnalyzer.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void execute() {
        CallSite[] callSiteArray = SonarCodeAnalyzer.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callCurrent((GroovyObject)this, (Object)this.rootModel))) {
            return;
        }
        Object projectDef = callSiteArray[1].callCurrent((GroovyObject)this, (Object)this.rootModel);
        Object reactor = callSiteArray[2].callConstructor(ProjectReactor.class, projectDef);
        Object globalProperties = callSiteArray[3].callCurrent((GroovyObject)this, (Object)this.rootModel);
        Object prop = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(globalProperties), Iterator.class);
        while (iterator.hasNext()) {
            prop = iterator.next();
            callSiteArray[5].call((Object)LOGGER, (Object)new GStringImpl(new Object[]{prop}, new String[]{"adding global property ", ""}));
        }
        Object environment = callSiteArray[6].callConstructor(EnvironmentInformation.class, (Object)"Gradle", callSiteArray[7].callGroovyObjectGetProperty((Object)this.rootModel));
        Object batch = callSiteArray[8].call(Batch.class, reactor, callSiteArray[9].callConstructor(MapConfiguration.class, globalProperties), environment);
        callSiteArray[10].call(batch);
    }

    public ProjectDefinition configureProject(SonarModel sonarModel) {
        CallSite[] callSiteArray = SonarCodeAnalyzer.$getCallSiteArray();
        Object sonarProject = callSiteArray[11].callGetProperty((Object)sonarModel);
        callSiteArray[12].call((Object)LOGGER, (Object)new GStringImpl(new Object[]{callSiteArray[13].callGetProperty(sonarProject)}, new String[]{"configuring project ", ""}));
        Object projectProperties = callSiteArray[14].callConstructor(Properties.class);
        callSiteArray[15].call(projectProperties, callSiteArray[16].callCurrent((GroovyObject)this, sonarProject));
        Object prop = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call(projectProperties), Iterator.class);
        while (iterator.hasNext()) {
            prop = iterator.next();
            callSiteArray[18].call((Object)LOGGER, (Object)new GStringImpl(new Object[]{prop}, new String[]{"adding project property ", ""}));
        }
        Object projectDef = callSiteArray[19].call(ProjectDefinition.class, projectProperties);
        Object object = callSiteArray[20].callGetProperty(sonarProject);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)projectDef, (String)"key");
        Object object2 = callSiteArray[21].callGetProperty(sonarProject);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)projectDef, (String)"name");
        Object object3 = callSiteArray[22].callGetProperty(sonarProject);
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)projectDef, (String)"description");
        Object object4 = callSiteArray[23].callGetProperty(sonarProject);
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)projectDef, (String)"version");
        Object object5 = callSiteArray[24].callGetProperty(sonarProject);
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)projectDef, (String)"baseDir");
        Object object6 = callSiteArray[25].callGetProperty(sonarProject);
        ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)projectDef, (String)"workDir");
        Object dir = null;
        Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call(callSiteArray[27].callGetProperty(sonarProject)), Iterator.class);
        while (iterator2.hasNext()) {
            dir = iterator2.next();
            callSiteArray[28].call((Object)LOGGER, (Object)new GStringImpl(new Object[]{dir}, new String[]{"adding source dir ", ""}));
        }
        File[] fileArray = (File[])ScriptBytecodeAdapter.asType((Object)callSiteArray[29].callGetProperty(sonarProject), File[].class);
        ScriptBytecodeAdapter.setProperty((Object)fileArray, null, (Object)projectDef, (String)"sourceDirs");
        Object dir2 = null;
        Iterator iterator3 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(callSiteArray[31].callGetProperty(sonarProject)), Iterator.class);
        while (iterator3.hasNext()) {
            dir2 = iterator3.next();
            callSiteArray[32].call((Object)LOGGER, (Object)new GStringImpl(new Object[]{dir2}, new String[]{"adding test dir ", ""}));
        }
        File[] fileArray2 = (File[])ScriptBytecodeAdapter.asType((Object)callSiteArray[33].callGetProperty(sonarProject), File[].class);
        ScriptBytecodeAdapter.setProperty((Object)fileArray2, null, (Object)projectDef, (String)"testDirs");
        Object dir3 = null;
        Iterator iterator4 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call(callSiteArray[35].callGetProperty(sonarProject)), Iterator.class);
        while (iterator4.hasNext()) {
            dir3 = iterator4.next();
            callSiteArray[36].call((Object)LOGGER, (Object)new GStringImpl(new Object[]{dir3}, new String[]{"adding binary dir ", ""}));
            callSiteArray[37].call(projectDef, dir3);
        }
        Object lib = null;
        Iterator iterator5 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call(callSiteArray[39].callGetProperty(sonarProject)), Iterator.class);
        while (iterator5.hasNext()) {
            lib = iterator5.next();
            callSiteArray[40].call((Object)LOGGER, (Object)new GStringImpl(new Object[]{lib}, new String[]{"adding library ", ""}));
            callSiteArray[41].call(projectDef, callSiteArray[42].callGetProperty(lib));
        }
        Object childModel = null;
        Iterator iterator6 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call(callSiteArray[44].callGetProperty((Object)sonarModel)), Iterator.class);
        while (iterator6.hasNext()) {
            childModel = iterator6.next();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].callCurrent((GroovyObject)this, childModel))) continue;
            Object childProjectDef = callSiteArray[46].callCurrent((GroovyObject)this, childModel);
            callSiteArray[47].call(projectDef, childProjectDef);
        }
        return (ProjectDefinition)ScriptBytecodeAdapter.castToType((Object)projectDef, ProjectDefinition.class);
    }

    private boolean skipped(SonarModel model) {
        CallSite[] callSiteArray = SonarCodeAnalyzer.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].callGetProperty(callSiteArray[49].callGetProperty((Object)model)))) {
            callSiteArray[50].call((Object)LOGGER, (Object)"Skipping Sonar analysis for project '{}' and its subprojects because 'sonar.project.skip' is 'true'", callSiteArray[51].callGetProperty(callSiteArray[52].callGetProperty((Object)model)));
            return true;
        }
        return false;
    }

    private Map<String, String> extractProperties(Object model) {
        CallSite[] callSiteArray = SonarCodeAnalyzer.$getCallSiteArray();
        Object converter = callSiteArray[53].callConstructor(ModelToPropertiesConverter.class, model);
        Object object = callSiteArray[54].callGetProperty(model);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)converter, (String)"propertyProcessors");
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(converter), Map.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SonarCodeAnalyzer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = SonarCodeAnalyzer.$getCallSiteArray()[56].call(LoggerFactory.class, SonarCodeAnalyzer.class);
        LOGGER = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public SonarRootModel getRootModel() {
        return this.rootModel;
    }

    public void setRootModel(SonarRootModel sonarRootModel) {
        this.rootModel = sonarRootModel;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "skipped";
        stringArray[1] = "configureProject";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "extractProperties";
        stringArray[4] = "iterator";
        stringArray[5] = "info";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "gradleVersion";
        stringArray[8] = "create";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "execute";
        stringArray[11] = "project";
        stringArray[12] = "info";
        stringArray[13] = "name";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "putAll";
        stringArray[16] = "extractProperties";
        stringArray[17] = "iterator";
        stringArray[18] = "info";
        stringArray[19] = "create";
        stringArray[20] = "key";
        stringArray[21] = "name";
        stringArray[22] = "description";
        stringArray[23] = "version";
        stringArray[24] = "baseDir";
        stringArray[25] = "workDir";
        stringArray[26] = "iterator";
        stringArray[27] = "sourceDirs";
        stringArray[28] = "info";
        stringArray[29] = "sourceDirs";
        stringArray[30] = "iterator";
        stringArray[31] = "testDirs";
        stringArray[32] = "info";
        stringArray[33] = "testDirs";
        stringArray[34] = "iterator";
        stringArray[35] = "binaryDirs";
        stringArray[36] = "info";
        stringArray[37] = "addBinaryDir";
        stringArray[38] = "iterator";
        stringArray[39] = "libraries";
        stringArray[40] = "info";
        stringArray[41] = "addLibrary";
        stringArray[42] = "absolutePath";
        stringArray[43] = "iterator";
        stringArray[44] = "childModels";
        stringArray[45] = "skipped";
        stringArray[46] = "configureProject";
        stringArray[47] = "addSubProject";
        stringArray[48] = "skip";
        stringArray[49] = "project";
        stringArray[50] = "info";
        stringArray[51] = "name";
        stringArray[52] = "project";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "propertyProcessors";
        stringArray[55] = "convert";
        stringArray[56] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[57];
        SonarCodeAnalyzer.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SonarCodeAnalyzer.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SonarCodeAnalyzer.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

