/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.instance;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.extract.ManagedProxyClassGenerator;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedProxyFactory {
    private final ManagedProxyClassGenerator proxyClassGenerator = new ManagedProxyClassGenerator();
    private final LoadingCache<CacheKey<?>, Class<?>> generatedImplementationTypes = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<CacheKey<?>, Class<?>>(){

        public Class<?> load(CacheKey<?> key) throws Exception {
            return ManagedProxyFactory.this.proxyClassGenerator.generate(((CacheKey)key).schema, ((CacheKey)key).delegateSchema);
        }
    });

    public <T> T createProxy(ModelElementState state, StructSchema<T> viewSchema, @Nullable StructSchema<? extends T> delegateSchema, TypeConverter typeConverter) {
        try {
            Class<T> generatedClass = this.getGeneratedImplementation(viewSchema, delegateSchema);
            if (generatedClass == null) {
                throw new IllegalStateException("No managed implementation class available for: " + viewSchema.getType());
            }
            if (delegateSchema == null) {
                Constructor<T> constructor = generatedClass.getConstructor(ModelElementState.class, TypeConverter.class);
                return constructor.newInstance(state, typeConverter);
            }
            ModelType delegateType = delegateSchema.getType();
            Object delegate = state.getBackingNode().getPrivateData(delegateType);
            Constructor<T> constructor = generatedClass.getConstructor(ModelElementState.class, TypeConverter.class, delegateType.getConcreteClass());
            return constructor.newInstance(state, typeConverter, delegate);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getTargetException());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private <T> Class<? extends T> getGeneratedImplementation(StructSchema<T> schema, StructSchema<? extends T> delegateSchema) throws ExecutionException {
        return (Class)Cast.uncheckedCast((Object)this.generatedImplementationTypes.get(new CacheKey(schema, delegateSchema)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheKey<T> {
        private final StructSchema<T> schema;
        @Nullable
        private final StructSchema<? extends T> delegateSchema;

        private CacheKey(StructSchema<T> schema, @Nullable StructSchema<? extends T> delegateSchema) {
            this.schema = schema;
            this.delegateSchema = delegateSchema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.schema.equals(cacheKey.schema)) {
                return false;
            }
            return !(this.delegateSchema == null ? cacheKey.delegateSchema != null : !this.delegateSchema.equals(cacheKey.delegateSchema));
        }

        public int hashCode() {
            int result = this.schema.hashCode();
            result = 31 * result + (this.delegateSchema != null ? this.delegateSchema.hashCode() : 0);
            return result;
        }
    }
}

