/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelProperty<T> {
    private final String name;
    private final ModelType<T> type;
    private final StateManagementType stateManagementType;
    private final Set<ModelType<?>> declaredBy;
    private final List<WeaklyTypeReferencingMethod<?, T>> getters;
    private final WeaklyTypeReferencingMethod<?, Void> setter;
    private final boolean declaredAsHavingUnmanagedType;
    private ModelSchema<T> schema;

    public ModelProperty(ModelType<T> type, String name, StateManagementType stateManagementType, Set<ModelType<?>> declaredBy, List<WeaklyTypeReferencingMethod<?, T>> getters, @Nullable WeaklyTypeReferencingMethod<?, Void> setter, boolean declaredAsHavingUnmanagedType) {
        this.name = name;
        this.type = type;
        this.stateManagementType = stateManagementType;
        this.declaredBy = ImmutableSet.copyOf(declaredBy);
        this.getters = ImmutableList.copyOf(getters);
        this.setter = setter;
        this.declaredAsHavingUnmanagedType = declaredAsHavingUnmanagedType;
    }

    public String getName() {
        return this.name;
    }

    public ModelType<T> getType() {
        return this.type;
    }

    public ModelSchema<T> getSchema() {
        return this.schema;
    }

    public void setSchema(ModelSchema<T> schema) {
        this.schema = schema;
    }

    public StateManagementType getStateManagementType() {
        return this.stateManagementType;
    }

    public boolean isWritable() {
        return this.setter != null;
    }

    public Set<ModelType<?>> getDeclaredBy() {
        return this.declaredBy;
    }

    private WeaklyTypeReferencingMethod<?, T> firstGetter() {
        return this.getters.get(0);
    }

    public List<WeaklyTypeReferencingMethod<?, T>> getGetters() {
        return this.getters;
    }

    public WeaklyTypeReferencingMethod<?, Void> getSetter() {
        return this.setter;
    }

    public <I> T getPropertyValue(I instance) {
        return (T)((WeaklyTypeReferencingMethod)Cast.uncheckedCast(this.firstGetter())).invoke(instance, new Object[0]);
    }

    public boolean isDeclaredAsHavingUnmanagedType() {
        return this.declaredAsHavingUnmanagedType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelProperty that = (ModelProperty)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.type, that.type) && Objects.equal((Object)((Object)this.stateManagementType), (Object)((Object)that.stateManagementType)) && this.declaredAsHavingUnmanagedType == that.declaredAsHavingUnmanagedType && this.isWritable() == that.isWritable();
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.stateManagementType.hashCode();
        result = 31 * result + Boolean.valueOf(this.isWritable()).hashCode();
        result = 31 * result + Boolean.valueOf(this.declaredAsHavingUnmanagedType).hashCode();
        return result;
    }

    public String toString() {
        return this.stateManagementType.name().toLowerCase() + " " + this.getName() + "(" + this.getType().getDisplayName() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StateManagementType {
        MANAGED,
        UNMANAGED;

    }
}

