/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import org.gradle.model.internal.type.TypeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassTypeWrapper
implements TypeWrapper {
    private final WeakReference<Class<?>> reference;

    public ClassTypeWrapper(Class<?> clazz) {
        this.reference = new WeakReference(clazz);
    }

    @Override
    public Class<?> unwrap() {
        return (Class)this.reference.get();
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        builder.add((Object)this.unwrap());
    }

    @Override
    public String getRepresentation(boolean full) {
        if (full) {
            return ((Class)this.unwrap()).getName();
        }
        Type clazz = this.unwrap();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(((Class)clazz).getSimpleName());
            for (Class<?> c = ((Class)clazz).getEnclosingClass(); c != null; c = c.getEnclosingClass()) {
                sb.insert(0, '.');
                sb.insert(0, c.getSimpleName());
            }
            return sb.toString();
        }
        catch (NoClassDefFoundError ignore) {
            Package pkg = ((Class)clazz).getPackage();
            int pkgPrefixLength = pkg == null ? 0 : pkg.getName().length() + 1;
            return ((Class)clazz).getName().substring(pkgPrefixLength).replace('$', '.');
        }
    }
}

