/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.internal.resolve.LibraryResolutionErrorMessageBuilder;
import org.gradle.api.internal.resolve.LocalLibraryMetaDataAdapter;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.internal.resolve.VariantsMatcher;
import org.gradle.internal.component.local.model.LocalComponentMetaData;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetaData;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentUsage;
import org.gradle.internal.component.model.ConfigurationMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.language.base.internal.model.VariantAxisCompatibilityFactory;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.language.base.internal.resolve.LibraryResolveException;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.LibrarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalLibraryDependencyResolver<T extends BinarySpec>
implements DependencyToComponentIdResolver,
ComponentMetaDataResolver,
ArtifactResolver {
    private final ProjectModelResolver projectModelResolver;
    private final VariantsMetaData variantsMetaData;
    private final VariantsMatcher matcher;
    private final LibraryResolutionErrorMessageBuilder errorMessageBuilder;
    private final LocalLibraryMetaDataAdapter libraryMetaDataAdapter;
    private final Class<? extends BinarySpec> binaryType;
    private final Predicate<LibrarySpec> binarySpecPredicate;

    public LocalLibraryDependencyResolver(Class<T> binarySpecType, ProjectModelResolver projectModelResolver, List<VariantAxisCompatibilityFactory> selectorFactories, VariantsMetaData variantsMetaData, ModelSchemaStore schemaStore, LocalLibraryMetaDataAdapter libraryMetaDataAdapter, LibraryResolutionErrorMessageBuilder errorMessageBuilder) {
        this.projectModelResolver = projectModelResolver;
        this.libraryMetaDataAdapter = libraryMetaDataAdapter;
        this.matcher = new VariantsMatcher(selectorFactories, binarySpecType, schemaStore);
        this.errorMessageBuilder = errorMessageBuilder;
        this.variantsMetaData = variantsMetaData;
        this.binaryType = binarySpecType;
        this.binarySpecPredicate = new Predicate<LibrarySpec>(){

            public boolean apply(LibrarySpec input) {
                return !input.getBinaries().withType(LocalLibraryDependencyResolver.this.binaryType).isEmpty();
            }
        };
    }

    public void resolve(DependencyMetaData dependency, BuildableComponentIdResolveResult result) {
        if (dependency.getSelector() instanceof LibraryComponentSelector) {
            String libraryName;
            LibraryComponentSelector selector = (LibraryComponentSelector)dependency.getSelector();
            String selectorProjectPath = selector.getProjectPath();
            LibraryResolutionErrorMessageBuilder.LibraryResolutionResult resolutionResult = this.doResolve(selectorProjectPath, libraryName = selector.getLibraryName());
            LibrarySpec selectedLibrary = resolutionResult.getSelectedLibrary();
            if (selectedLibrary != null) {
                Collection allBinaries = selectedLibrary.getBinaries().values();
                Collection<? extends BinarySpec> compatibleBinaries = this.matcher.filterBinaries(this.variantsMetaData, allBinaries);
                if (!allBinaries.isEmpty() && compatibleBinaries.isEmpty()) {
                    result.failed(new ModuleVersionResolveException((ComponentSelector)selector, this.errorMessageBuilder.noCompatibleVariantErrorMessage(libraryName, allBinaries)));
                } else if (compatibleBinaries.size() > 1) {
                    result.failed(new ModuleVersionResolveException((ComponentSelector)selector, this.errorMessageBuilder.multipleCompatibleVariantsErrorMessage(libraryName, compatibleBinaries)));
                } else {
                    BinarySpec selectedBinary = compatibleBinaries.iterator().next();
                    LocalComponentMetaData metaData = this.libraryMetaDataAdapter.createLocalComponentMetaData(selectedBinary, selectorProjectPath);
                    result.resolved((ComponentResolveMetaData)metaData);
                }
            }
            if (!result.hasResult()) {
                String message = resolutionResult.toResolutionErrorMessage(this.binaryType, selector);
                ModuleVersionResolveException failure = new ModuleVersionResolveException((ComponentSelector)selector, (Throwable)((Object)new LibraryResolveException(message)));
                result.failed(failure);
            }
        }
    }

    private LibraryResolutionErrorMessageBuilder.LibraryResolutionResult doResolve(String projectPath, String libraryName) {
        try {
            ModelRegistry projectModel = this.projectModelResolver.resolveProjectModel(projectPath);
            ComponentSpecContainer components = (ComponentSpecContainer)projectModel.find("components", ComponentSpecContainer.class);
            if (components != null) {
                ModelMap libraries = components.withType(LibrarySpec.class);
                return LibraryResolutionErrorMessageBuilder.LibraryResolutionResult.of(libraries.values(), libraryName, this.binarySpecPredicate);
            }
            return LibraryResolutionErrorMessageBuilder.LibraryResolutionResult.emptyResolutionResult();
        }
        catch (UnknownProjectException e) {
            return LibraryResolutionErrorMessageBuilder.LibraryResolutionResult.projectNotFound();
        }
    }

    public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result) {
        if (this.isLibrary(identifier)) {
            throw new RuntimeException("Not yet implemented");
        }
    }

    private boolean isLibrary(ComponentIdentifier identifier) {
        return identifier instanceof LibraryBinaryIdentifier;
    }

    public void resolveModuleArtifacts(ComponentResolveMetaData component, ComponentUsage usage, BuildableArtifactSetResolveResult result) {
        ComponentIdentifier componentId = component.getComponentId();
        if (this.isLibrary(componentId)) {
            ConfigurationMetaData configuration = component.getConfiguration(usage.getConfigurationName());
            if (configuration != null) {
                Set artifacts = configuration.getArtifacts();
                result.resolved((Collection)artifacts);
            }
            if (!result.hasResult()) {
                result.failed(new ArtifactResolveException(String.format("Unable to resolve artifact for %s", componentId)));
            }
        }
    }

    public void resolveModuleArtifacts(ComponentResolveMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        if (this.isLibrary(component.getComponentId())) {
            result.resolved(Collections.emptyList());
        }
    }

    public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        if (this.isLibrary(artifact.getComponentId())) {
            if (artifact instanceof PublishArtifactLocalArtifactMetaData) {
                result.resolved(((PublishArtifactLocalArtifactMetaData)artifact).getFile());
            } else {
                result.failed(new ArtifactResolveException("Unsupported artifact metadata type: " + artifact));
            }
        }
    }
}

