/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.logging.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.testkit.jarjar.org.gradle.api.logging.StandardOutputListener;
import org.gradle.testkit.jarjar.org.gradle.internal.SystemProperties;
import org.gradle.testkit.jarjar.org.gradle.logging.StyledTextOutput;

public abstract class AbstractStyledTextOutput
implements StyledTextOutput,
StandardOutputListener {
    private StyledTextOutput.Style style = StyledTextOutput.Style.Normal;

    public StyledTextOutput append(char c) {
        this.text(String.valueOf(c));
        return this;
    }

    public StyledTextOutput append(CharSequence csq) {
        this.text(csq == null ? "null" : csq);
        return this;
    }

    public StyledTextOutput append(CharSequence csq, int start, int end) {
        this.text(csq == null ? "null" : csq.subSequence(start, end));
        return this;
    }

    public StyledTextOutput format(String pattern, Object ... args) {
        this.text(String.format(pattern, args));
        return this;
    }

    public StyledTextOutput println(Object text) {
        this.text(text);
        this.println();
        return this;
    }

    public StyledTextOutput formatln(String pattern, Object ... args) {
        this.format(pattern, args);
        this.println();
        return this;
    }

    public void onOutput(CharSequence output) {
        this.text(output);
    }

    public StyledTextOutput println() {
        this.text(SystemProperties.getInstance().getLineSeparator());
        return this;
    }

    public StyledTextOutput text(Object text) {
        this.doAppend(text == null ? "null" : text.toString());
        return this;
    }

    public StyledTextOutput exception(Throwable throwable) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        throwable.printStackTrace(writer);
        writer.close();
        this.text(out.toString());
        return this;
    }

    public StyledTextOutput withStyle(StyledTextOutput.Style style) {
        return new StyleOverrideTextOutput(style, this);
    }

    public StyledTextOutput style(StyledTextOutput.Style style) {
        if (style != this.style) {
            this.style = style;
            this.doStyleChange(style);
        }
        return this;
    }

    public StyledTextOutput.Style getStyle() {
        return this.style;
    }

    protected abstract void doAppend(String var1);

    protected void doStyleChange(StyledTextOutput.Style style) {
    }

    private static class StyleOverrideTextOutput
    implements StyledTextOutput {
        private final StyledTextOutput.Style style;
        private final AbstractStyledTextOutput textOutput;

        public StyleOverrideTextOutput(StyledTextOutput.Style style, AbstractStyledTextOutput textOutput) {
            this.style = style;
            this.textOutput = textOutput;
        }

        public StyledTextOutput append(char c) {
            StyledTextOutput.Style original = this.textOutput.getStyle();
            this.textOutput.style(this.style).append(c).style(original);
            return this;
        }

        public StyledTextOutput append(CharSequence csq) {
            StyledTextOutput.Style original = this.textOutput.getStyle();
            this.textOutput.style(this.style).append(csq).style(original);
            return this;
        }

        public StyledTextOutput append(CharSequence csq, int start, int end) {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput style(StyledTextOutput.Style style) {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput withStyle(StyledTextOutput.Style style) {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput text(Object text) {
            StyledTextOutput.Style original = this.textOutput.getStyle();
            this.textOutput.style(this.style).text(text).style(original);
            return this;
        }

        public StyledTextOutput println(Object text) {
            StyledTextOutput.Style original = this.textOutput.getStyle();
            this.textOutput.style(this.style).text(text).style(original).println();
            return this;
        }

        public StyledTextOutput format(String pattern, Object ... args) {
            StyledTextOutput.Style original = this.textOutput.getStyle();
            this.textOutput.style(this.style).format(pattern, args).style(original);
            return this;
        }

        public StyledTextOutput formatln(String pattern, Object ... args) {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput println() {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput exception(Throwable throwable) {
            throw new UnsupportedOperationException();
        }
    }
}

