/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.logging.internal;

import java.util.concurrent.atomic.AtomicLong;
import org.gradle.testkit.jarjar.org.gradle.internal.TimeProvider;
import org.gradle.testkit.jarjar.org.gradle.internal.progress.OperationIdentifier;
import org.gradle.testkit.jarjar.org.gradle.logging.ProgressLogger;
import org.gradle.testkit.jarjar.org.gradle.logging.ProgressLoggerFactory;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.ProgressEvent;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.ProgressListener;
import org.gradle.testkit.jarjar.org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.testkit.jarjar.org.gradle.util.GUtil;

public class DefaultProgressLoggerFactory
implements ProgressLoggerFactory {
    private final ProgressListener progressListener;
    private final TimeProvider timeProvider;
    private final AtomicLong nextId = new AtomicLong();
    private final ThreadLocal<ProgressLoggerImpl> current = new ThreadLocal();

    public DefaultProgressLoggerFactory(ProgressListener progressListener, TimeProvider timeProvider) {
        this.progressListener = progressListener;
        this.timeProvider = timeProvider;
    }

    public ProgressLogger newOperation(Class loggerCategory) {
        return this.newOperation(loggerCategory.getName());
    }

    public ProgressLogger newOperation(String loggerCategory) {
        return this.init(loggerCategory, null);
    }

    public ProgressLogger newOperation(Class loggerClass, ProgressLogger parent) {
        return this.init(loggerClass.toString(), parent);
    }

    private ProgressLogger init(String loggerCategory, ProgressLogger parentOperation) {
        if (parentOperation != null && !(parentOperation instanceof ProgressLoggerImpl)) {
            throw new IllegalArgumentException("Unexpected parent logger.");
        }
        return new ProgressLoggerImpl((ProgressLoggerImpl)parentOperation, this.nextId.getAndIncrement(), loggerCategory, this.progressListener, this.timeProvider);
    }

    private class ProgressLoggerImpl
    implements ProgressLogger {
        private final OperationIdentifier id;
        private final String category;
        private final ProgressListener listener;
        private final TimeProvider timeProvider;
        private ProgressLoggerImpl parent;
        private String description;
        private String shortDescription;
        private String loggingHeader;
        private State state = State.idle;

        public ProgressLoggerImpl(ProgressLoggerImpl parent, long id, String category, ProgressListener listener, TimeProvider timeProvider) {
            this.parent = parent;
            this.id = new OperationIdentifier(id);
            this.category = category;
            this.listener = listener;
            this.timeProvider = timeProvider;
        }

        public String toString() {
            return String.format("%s - %s", this.category, this.description);
        }

        public String getDescription() {
            return this.description;
        }

        public ProgressLogger setDescription(String description) {
            this.assertCanConfigure();
            this.description = description;
            return this;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public ProgressLogger setShortDescription(String shortDescription) {
            this.assertCanConfigure();
            this.shortDescription = shortDescription;
            return this;
        }

        public String getLoggingHeader() {
            return this.loggingHeader;
        }

        public ProgressLogger setLoggingHeader(String loggingHeader) {
            this.assertCanConfigure();
            this.loggingHeader = loggingHeader;
            return this;
        }

        public ProgressLogger start(String description, String shortDescription) {
            this.setDescription(description);
            this.setShortDescription(shortDescription);
            this.started();
            return this;
        }

        public void started() {
            this.started(null);
        }

        public void started(String status) {
            if (!GUtil.isTrue(this.description)) {
                throw new IllegalStateException("A description must be specified before this operation is started.");
            }
            this.assertNotStarted();
            this.state = State.started;
            if (this.parent == null) {
                this.parent = (ProgressLoggerImpl)DefaultProgressLoggerFactory.this.current.get();
            } else {
                this.parent.assertRunning();
            }
            DefaultProgressLoggerFactory.this.current.set(this);
            this.listener.started(new ProgressStartEvent(this.id, this.parent == null ? null : this.parent.id, this.timeProvider.getCurrentTime(), this.category, this.description, this.shortDescription, this.loggingHeader, this.toStatus(status)));
        }

        public void progress(String status) {
            this.assertRunning();
            this.listener.progress(new ProgressEvent(this.id, this.timeProvider.getCurrentTime(), this.category, this.toStatus(status)));
        }

        public void completed() {
            this.completed(null);
        }

        public void completed(String status) {
            this.assertRunning();
            this.state = State.completed;
            DefaultProgressLoggerFactory.this.current.set(this.parent);
            this.listener.completed(new ProgressCompleteEvent(this.id, this.timeProvider.getCurrentTime(), this.category, this.description, this.toStatus(status)));
        }

        private String toStatus(String status) {
            return status == null ? "" : status;
        }

        private void assertNotStarted() {
            if (this.state == State.started) {
                throw new IllegalStateException(String.format("This operation (%s) has already been started.", this));
            }
            if (this.state == State.completed) {
                throw new IllegalStateException(String.format("This operation (%s) has already completed.", this));
            }
        }

        private void assertRunning() {
            if (this.state == State.idle) {
                throw new IllegalStateException(String.format("This operation (%s) has not been started.", this));
            }
            if (this.state == State.completed) {
                throw new IllegalStateException(String.format("This operation (%s) has already been completed.", this));
            }
        }

        private void assertCanConfigure() {
            if (this.state != State.idle) {
                throw new IllegalStateException(String.format("Cannot configure this operation (%s) once it has started.", this));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        idle,
        started,
        completed;

    }
}

