/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.gradle.api.Nullable;
import org.gradle.cache.internal.filelock.LockInfo;
import org.gradle.cache.internal.filelock.LockInfoSerializer;
import org.gradle.internal.io.RandomAccessFileInputStream;
import org.gradle.internal.io.RandomAccessFileOutputStream;

public class LockInfoAccess {
    public static final int INFORMATION_REGION_SIZE = 2052;
    private final LockInfoSerializer lockInfoSerializer = new LockInfoSerializer();
    private final long infoRegionPos;

    public LockInfoAccess(long infoRegionPos) {
        this.infoRegionPos = infoRegionPos;
    }

    public LockInfo readLockInfo(RandomAccessFile lockFileAccess) throws IOException {
        if (lockFileAccess.length() <= this.infoRegionPos) {
            return new LockInfo();
        }
        lockFileAccess.seek(this.infoRegionPos);
        DataInputStream inputStream = new DataInputStream(new BufferedInputStream((InputStream)new RandomAccessFileInputStream(lockFileAccess)));
        byte protocolVersion = inputStream.readByte();
        if (protocolVersion != this.lockInfoSerializer.getVersion()) {
            throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file. Expected %s, found %s.", this.lockInfoSerializer.getVersion(), protocolVersion));
        }
        return this.lockInfoSerializer.read(inputStream);
    }

    public void writeLockInfo(RandomAccessFile lockFileAccess, LockInfo lockInfo) throws IOException {
        lockFileAccess.seek(this.infoRegionPos);
        DataOutputStream outstr = new DataOutputStream(new BufferedOutputStream((OutputStream)new RandomAccessFileOutputStream(lockFileAccess)));
        outstr.writeByte(this.lockInfoSerializer.getVersion());
        this.lockInfoSerializer.write(outstr, lockInfo);
        outstr.flush();
        lockFileAccess.setLength(lockFileAccess.getFilePointer());
    }

    public void clearLockInfo(RandomAccessFile lockFileAccess) throws IOException {
        lockFileAccess.setLength(Math.min(lockFileAccess.length(), this.infoRegionPos));
    }

    @Nullable
    public FileLock tryLock(RandomAccessFile lockFileAccess, boolean shared) throws IOException {
        return lockFileAccess.getChannel().tryLock(this.infoRegionPos, 2052L - this.infoRegionPos, shared);
    }
}

