/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.CharSequenceNotationConverter;
import org.gradle.internal.typeconversion.EnumFromCharSequenceNotationParser;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeConverter
implements TypeConverter {
    private static final String CANDIDATE = "String or CharSequence instances.";
    private static final Collection<String> CANDIDATES = Collections.singleton("String or CharSequence instances.");
    private static final Map<Class<?>, Class<?>> UNBOXED_TYPES = ImmutableMap.builder().put(Byte.class, Byte.TYPE).put(Short.class, Short.TYPE).put(Integer.class, Integer.TYPE).put(Boolean.class, Boolean.TYPE).put(Float.class, Float.TYPE).put(Character.class, Character.TYPE).put(Double.class, Double.TYPE).put(Long.class, Long.TYPE).build();
    private final Map<Class<?>, NotationParser<Object, ?>> parsers = Maps.newHashMap();
    private final NotationParser<Object, File> fileParser;

    private static <T> NotationParser<Object, T> build(NotationConverter<Object, T> converter, Class<T> type) {
        return NotationParserBuilder.toType(type).noImplicitConverters().converter(converter).toComposite();
    }

    private <T> void registerConverter(NotationConverter<Object, T> converter, Class<T> type) {
        this.parsers.put(type, DefaultTypeConverter.build(converter, type));
    }

    private <T> void registerStringConverter(NotationConverter<String, T> converter, Class<T> type) {
        this.parsers.put(type, DefaultTypeConverter.build(new CharSequenceNotationConverter(converter), type));
    }

    private void convertToCharacter(String notation, NotationConvertResult<? super Character> result, Class<?> type) throws TypeConversionException {
        if (notation.length() != 1) {
            throw new TypeConversionException(String.format("Cannot coerce string value '%s' with length %d to type %s", notation, notation.length(), type.getSimpleName()));
        }
        result.converted(Character.valueOf(notation.charAt(0)));
    }

    private void registerConverters() {
        this.registerConverter(new NumberConverter<Double>(Double.class){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Double> result) throws TypeConversionException {
                result.converted(Double.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Double> result) {
                result.converted((Double)n.doubleValue());
            }
        }, Double.class);
        this.registerConverter(new NumberConverter<Double>(Double.TYPE){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Double> result) throws TypeConversionException {
                result.converted(Double.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Double> result) {
                result.converted((Double)n.doubleValue());
            }
        }, Double.TYPE);
        this.registerConverter(new NumberConverter<Float>(Float.class){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Float> result) throws TypeConversionException {
                result.converted(Float.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Float> result) {
                result.converted(Float.valueOf(n.floatValue()));
            }
        }, Float.class);
        this.registerConverter(new NumberConverter<Float>(Float.TYPE){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Float> result) throws TypeConversionException {
                result.converted(Float.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Float> result) {
                result.converted(Float.valueOf(n.floatValue()));
            }
        }, Float.TYPE);
        this.registerConverter(new NumberConverter<Integer>(Integer.class){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Integer> result) throws TypeConversionException {
                result.converted(Integer.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Integer> result) {
                result.converted((Integer)n.intValue());
            }
        }, Integer.class);
        this.registerConverter(new NumberConverter<Integer>(Integer.TYPE){

            @Override
            protected void convertStringToNumber(String s, NotationConvertResult<? super Integer> result) throws TypeConversionException {
                result.converted(Integer.valueOf(s));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Integer> result) {
                result.converted((Integer)n.intValue());
            }
        }, Integer.TYPE);
        this.registerConverter(new NumberConverter<Long>(Long.class){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Long> result) throws TypeConversionException {
                result.converted(Long.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Long> result) {
                result.converted((Long)n.longValue());
            }
        }, Long.class);
        this.registerConverter(new NumberConverter<Long>(Long.TYPE){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Long> result) throws TypeConversionException {
                result.converted(Long.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Long> result) {
                result.converted((Long)n.longValue());
            }
        }, Long.TYPE);
        this.registerConverter(new NumberConverter<Short>(Short.class){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Short> result) throws TypeConversionException {
                result.converted(Short.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Short> result) {
                result.converted((Short)n.shortValue());
            }
        }, Short.class);
        this.registerConverter(new NumberConverter<Short>(Short.TYPE){

            @Override
            protected void convertStringToNumber(String s, NotationConvertResult<? super Short> result) throws TypeConversionException {
                result.converted(Short.valueOf(s));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Short> result) {
                result.converted((Short)n.shortValue());
            }
        }, Short.TYPE);
        this.registerConverter(new NumberConverter<Byte>(Byte.class){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Byte> result) throws TypeConversionException {
                result.converted(Byte.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Byte> result) {
                result.converted((Byte)n.byteValue());
            }
        }, Byte.class);
        this.registerConverter(new NumberConverter<Byte>(Byte.TYPE){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super Byte> result) throws TypeConversionException {
                result.converted(Byte.valueOf(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super Byte> result) {
                result.converted((Byte)n.byteValue());
            }
        }, Byte.TYPE);
        this.registerConverter(new NumberConverter<BigDecimal>(BigDecimal.class){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super BigDecimal> result) throws TypeConversionException {
                result.converted(new BigDecimal(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super BigDecimal> result) {
                if (n instanceof BigDecimal) {
                    result.converted((BigDecimal)n);
                } else if (n instanceof BigInteger) {
                    result.converted(new BigDecimal((BigInteger)n));
                }
            }
        }, BigDecimal.class);
        this.registerConverter(new NumberConverter<BigInteger>(BigInteger.class){

            @Override
            protected void convertStringToNumber(String notation, NotationConvertResult<? super BigInteger> result) throws TypeConversionException {
                result.converted(new BigInteger(notation));
            }

            @Override
            protected void convertNumberToNumber(Number n, NotationConvertResult<? super BigInteger> result) {
                if (n instanceof BigInteger) {
                    result.converted((BigInteger)n);
                }
            }
        }, BigInteger.class);
        CharSequenceConverter<Boolean> booleanConverter = new CharSequenceConverter<Boolean>(){

            @Override
            public void convert(String notation, NotationConvertResult<? super Boolean> result) throws TypeConversionException {
                result.converted((Boolean)"true".equals(notation));
            }
        };
        this.registerStringConverter(booleanConverter, Boolean.class);
        this.registerStringConverter(booleanConverter, Boolean.TYPE);
        this.registerStringConverter(new CharSequenceConverter<Character>(){

            @Override
            public void convert(String notation, NotationConvertResult<? super Character> result) throws TypeConversionException {
                DefaultTypeConverter.this.convertToCharacter(notation, result, Character.class);
            }
        }, Character.class);
        this.registerStringConverter(new CharSequenceConverter<Character>(){

            @Override
            public void convert(String notation, NotationConvertResult<? super Character> result) throws TypeConversionException {
                DefaultTypeConverter.this.convertToCharacter(notation, result, Character.TYPE);
            }
        }, Character.TYPE);
        this.registerConverter(new StringConverter(), String.class);
    }

    public DefaultTypeConverter(final FileResolver fileResolver) {
        this.fileParser = DefaultTypeConverter.build(new CharSequenceNotationConverter(new CharSequenceConverter<File>(){

            @Override
            public void convert(String notation, NotationConvertResult<? super File> result) throws TypeConversionException {
                result.converted(fileResolver.resolve(notation));
            }
        }), File.class);
        this.registerConverters();
    }

    public Object convert(Object notation, Class<?> type, boolean primitive) throws UnsupportedNotationException, TypeConversionException {
        NotationParser<Object, File> parser;
        if (notation == null) {
            if (primitive) {
                throw new UnsupportedNotationException(notation, String.format("Cannot assign null value to primitive type %s.", UNBOXED_TYPES.get(type).getSimpleName()), null, CANDIDATES);
            }
            return null;
        }
        if (type.isInstance(notation)) {
            return notation;
        }
        if (type.isEnum()) {
            return NotationParserBuilder.toType(type).noImplicitConverters().converter(new CharSequenceNotationConverter(new EnumConverter(type))).toComposite().parseNotation(notation);
        }
        if (File.class.equals(type)) {
            parser = this.fileParser;
        } else {
            parser = this.parsers.get(primitive ? UNBOXED_TYPES.get(type) : type);
            if (parser == null) {
                throw new UnsupportedNotationException(notation, "Unsupported type", null, CANDIDATES);
            }
        }
        return parser.parseNotation(notation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumConverter<T extends Enum>
    extends CharSequenceConverter<T> {
        private final Class<? extends T> enumType;

        public EnumConverter(Class<? extends T> enumType) {
            this.enumType = enumType;
        }

        @Override
        public void convert(String notation, NotationConvertResult<? super T> result) throws TypeConversionException {
            result.converted(new EnumFromCharSequenceNotationParser<T>(this.enumType).parseNotation(notation));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class NumberConverter<T extends Number>
    implements NotationConverter<Object, T> {
        private final Class<T> type;

        protected NumberConverter(Class<T> type) {
            this.type = type;
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate(DefaultTypeConverter.CANDIDATE);
            visitor.candidate("Number instances.");
        }

        @Override
        public void convert(Object notation, NotationConvertResult<? super T> result) throws TypeConversionException {
            if (notation instanceof CharSequence) {
                try {
                    this.convertStringToNumber(notation.toString().trim(), result);
                }
                catch (NumberFormatException e) {
                    throw new TypeConversionException(String.format("Cannot coerce string value '%s' to type %s", notation, this.type.getSimpleName()));
                }
            }
            if (notation instanceof Number) {
                try {
                    this.convertNumberToNumber((Number)notation, result);
                }
                catch (NumberFormatException e) {
                    throw new TypeConversionException(String.format("Cannot coerce numeric value '%s' to type %s", notation, this.type.getSimpleName()));
                }
            }
        }

        protected abstract void convertStringToNumber(String var1, NotationConvertResult<? super T> var2);

        protected abstract void convertNumberToNumber(Number var1, NotationConvertResult<? super T> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringConverter
    implements NotationConverter<Object, String> {
        private StringConverter() {
        }

        @Override
        public void convert(Object notation, NotationConvertResult<? super String> result) throws TypeConversionException {
            if (notation instanceof CharSequence || notation instanceof Number || notation instanceof Boolean) {
                result.converted(notation.toString());
            }
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate(DefaultTypeConverter.CANDIDATE);
            visitor.candidate("Any number or boolean.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CharSequenceConverter<T>
    implements NotationConverter<String, T> {
        private CharSequenceConverter() {
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate(DefaultTypeConverter.CANDIDATE);
        }
    }
}

