/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.internal.hash.HashUtil;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyResolverIdentifier {
    public static String forExternalResourceResolver(ExternalResourceResolver resolver) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(resolver.getClass().getName());
        parts.add(DependencyResolverIdentifier.joinPatterns(resolver.getIvyPatterns()));
        parts.add(DependencyResolverIdentifier.joinPatterns(resolver.getArtifactPatterns()));
        if (resolver.isM2compatible()) {
            parts.add("m2compatible");
        }
        return DependencyResolverIdentifier.calculateId(parts);
    }

    private static String joinPatterns(List<String> patterns) {
        return CollectionUtils.join((String)",", patterns);
    }

    private static String calculateId(List<String> parts) {
        String idString = CollectionUtils.join((String)"::", parts);
        return HashUtil.createHash((String)idString, (String)"MD5").asHexString();
    }
}

