/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.internal.component.local.model.DslOriginDependencyMetaData;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.IvyArtifactName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentOverrideMetadata
implements ComponentOverrideMetadata {
    private final boolean changing;
    private final Set<IvyArtifactName> artifacts;
    private final ClientModule clientModule;

    public static ComponentOverrideMetadata forDependency(DependencyMetaData dependencyMetaData) {
        return new DefaultComponentOverrideMetadata(dependencyMetaData.isChanging(), dependencyMetaData.getArtifacts(), DefaultComponentOverrideMetadata.extractClientModule(dependencyMetaData));
    }

    public DefaultComponentOverrideMetadata() {
        this(false, Collections.emptySet(), null);
    }

    private DefaultComponentOverrideMetadata(boolean changing, Set<IvyArtifactName> artifacts, ClientModule clientModule) {
        this.changing = changing;
        this.artifacts = Sets.newHashSet(artifacts);
        this.clientModule = clientModule;
    }

    private static ClientModule extractClientModule(DependencyMetaData dependencyMetaData) {
        ModuleDependency source;
        if (dependencyMetaData instanceof DslOriginDependencyMetaData && (source = ((DslOriginDependencyMetaData)dependencyMetaData).getSource()) instanceof ClientModule) {
            return (ClientModule)source;
        }
        return null;
    }

    @Override
    public ComponentOverrideMetadata withChanging() {
        return new DefaultComponentOverrideMetadata(true, this.artifacts, this.clientModule);
    }

    @Override
    public Set<IvyArtifactName> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public ClientModule getClientModule() {
        return this.clientModule;
    }
}

