/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionValidationException;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.Mutate;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSourceBackedRuleAction<R, T>
implements RuleAction<T> {
    private final R instance;
    private final JavaMethod<R, T> ruleMethod;
    private final List<Class<?>> inputTypes;

    private RuleSourceBackedRuleAction(R instance, JavaMethod<R, T> ruleMethod) {
        this.instance = instance;
        this.ruleMethod = ruleMethod;
        this.inputTypes = RuleSourceBackedRuleAction.determineInputTypes(ruleMethod.getParameterTypes());
    }

    public static <R, T> RuleSourceBackedRuleAction<R, T> create(ModelType<T> subjectType, R ruleSourceInstance) {
        ModelType ruleSourceType = ModelType.typeOf(ruleSourceInstance);
        List mutateMethods = JavaReflectionUtil.findAllMethods((Class)ruleSourceType.getConcreteClass(), (Spec)new Spec<Method>(){

            public boolean isSatisfiedBy(Method element) {
                return element.isAnnotationPresent(Mutate.class);
            }
        });
        ArrayList reasons = Lists.newArrayList();
        if (mutateMethods.size() == 0) {
            reasons.add("must have at exactly one method annotated with @org.gradle.model.Mutate");
        } else {
            if (mutateMethods.size() > 1) {
                reasons.add("more than one method is annotated with @org.gradle.model.Mutate");
            }
            for (Method ruleMethod : mutateMethods) {
                Type[] parameterTypes;
                if (ruleMethod.getReturnType() != Void.TYPE) {
                    reasons.add(String.format("rule method '%s' must return void", ruleMethod.getName()));
                }
                if ((parameterTypes = ruleMethod.getGenericParameterTypes()).length != 0 && subjectType.isAssignableFrom(ModelType.of((Type)parameterTypes[0]))) continue;
                reasons.add(String.format("first parameter of rule method '%s' must be of type %s", ruleMethod.getName(), subjectType));
            }
        }
        if (reasons.size() > 0) {
            throw RuleSourceBackedRuleAction.invalid(ruleSourceType, reasons);
        }
        return new RuleSourceBackedRuleAction<R, T>(ruleSourceInstance, new JavaMethod(ruleSourceType.getConcreteClass(), subjectType.getConcreteClass(), (Method)mutateMethods.get(0)));
    }

    private static RuntimeException invalid(ModelType<?> source, List<String> reasons) {
        StringBuilder errorString = new StringBuilder(String.format("Type %s is not a valid model rule source: ", source));
        for (String reason : reasons) {
            errorString.append(String.format("\n- %s", reason));
        }
        return new RuleActionValidationException(null, (Throwable)new InvalidModelRuleDeclarationException(errorString.toString()));
    }

    public static List<Class<?>> determineInputTypes(Class<?>[] parameterTypes) {
        return Arrays.asList(parameterTypes).subList(1, parameterTypes.length);
    }

    @Override
    public List<Class<?>> getInputTypes() {
        return this.inputTypes;
    }

    @Override
    public void execute(T subject, List<?> inputs) {
        Object[] args = new Object[inputs.size() + 1];
        args[0] = subject;
        for (int i = 0; i < inputs.size(); ++i) {
            Object input = inputs.get(i);
            args[i + 1] = input;
        }
        this.ruleMethod.invoke(this.instance, args);
    }
}

