/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.ChannelUnavailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.LookupRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelRegistrationProtocol
implements Protocol<DiscoveryMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelRegistrationProtocol.class);
    private final Map<String, ChannelAvailable> channels = new HashMap<String, ChannelAvailable>();
    private final MessageOriginator messageOriginator;
    private ProtocolContext<DiscoveryMessage> context;

    public ChannelRegistrationProtocol(MessageOriginator messageOriginator) {
        this.messageOriginator = messageOriginator;
    }

    @Override
    public void start(ProtocolContext<DiscoveryMessage> context) {
        this.context = context;
    }

    @Override
    public void handleIncoming(DiscoveryMessage message) {
        if (message instanceof LookupRequest) {
            this.handleLookup((LookupRequest)message);
        } else if (!(message instanceof ChannelAvailable) && !(message instanceof ChannelUnavailable)) {
            LOGGER.info("Received unexpected discovery message - discarding: {}", (Object)message);
        } else {
            LOGGER.info("Ignoring discovery message: {}", (Object)message);
        }
    }

    @Override
    public void handleOutgoing(DiscoveryMessage message) {
        if (message instanceof ChannelAvailable) {
            ChannelAvailable channelAvailable = (ChannelAvailable)message;
            this.channels.put(channelAvailable.getChannel(), channelAvailable);
            LOGGER.info("Channel registered. Broadcasting {}.", (Object)message);
            this.context.dispatchOutgoing(message);
        } else if (message instanceof ChannelUnavailable) {
            ChannelUnavailable channelUnavailable = (ChannelUnavailable)message;
            this.channels.remove(channelUnavailable.getChannel());
            LOGGER.info("Channel unregistered. Broadcasting {}.", (Object)message);
            this.context.dispatchOutgoing(message);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void handleLookup(LookupRequest request) {
        ChannelAvailable response = this.channels.get(request.getChannel());
        if (response != null) {
            LOGGER.info("Replying to lookup request for known channel. Request: {}. Response: {}.", (Object)request, (Object)response);
            this.context.dispatchOutgoing(response);
        } else {
            LOGGER.info("Received lookup request for unknown channel - discarding: {}", (Object)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRequested() {
        try {
            for (ChannelAvailable channelAvailable : this.channels.values()) {
                this.context.dispatchOutgoing(new ChannelUnavailable(this.messageOriginator, channelAvailable.getGroup(), channelAvailable.getChannel(), channelAvailable.getAddress()));
            }
        }
        finally {
            this.channels.clear();
            this.context.stopped();
        }
    }
}

