/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.protocol.MethodMetaInfo;
import org.gradle.messaging.remote.internal.protocol.PayloadMessage;
import org.gradle.messaging.remote.internal.protocol.RemoteMethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocationUnmarshallingDispatch
implements Dispatch<Message> {
    private final Dispatch<? super Message> dispatch;
    private final ClassLoader classLoader;
    private final Map<Object, Method> methods = new HashMap<Object, Method>();

    public MethodInvocationUnmarshallingDispatch(Dispatch<? super Message> dispatch, ClassLoader classLoader) {
        this.dispatch = dispatch;
        this.classLoader = classLoader;
    }

    @Override
    public void dispatch(Message message) {
        PayloadMessage payloadMessage;
        if (message instanceof MethodMetaInfo) {
            MethodMetaInfo methodMetaInfo = (MethodMetaInfo)message;
            Method method = methodMetaInfo.findMethod(this.classLoader);
            this.methods.put(methodMetaInfo.getKey(), method);
            return;
        }
        if (message instanceof PayloadMessage && (payloadMessage = (PayloadMessage)((Object)message)).getNestedPayload() instanceof RemoteMethodInvocation) {
            RemoteMethodInvocation remoteMethodInvocation = (RemoteMethodInvocation)payloadMessage.getNestedPayload();
            Method method = this.methods.get(remoteMethodInvocation.getKey());
            if (method == null) {
                throw new IllegalStateException("Received a method invocation message for an unknown method.");
            }
            MethodInvocation methodInvocation = new MethodInvocation(method, remoteMethodInvocation.getArguments());
            this.dispatch.dispatch(payloadMessage.withNestedPayload(methodInvocation));
            return;
        }
        this.dispatch.dispatch(message);
    }
}

