/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.artefact.Enhanced;
import grails.util.Environment;
import grails.util.GrailsArrayUtils;
import grails.util.GrailsNameUtils;
import groovy.lang.AdaptingMetaClass;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.ExpandoMetaClassCreationHandle;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaProperty;
import groovy.util.ConfigObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.cglib.reflect.FastClass;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class GrailsClassUtils {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_COMPATIBLE_CLASSES = new HashMap();

    private static final void registerPrimitiveClassPair(Class<?> left, Class<?> right) {
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(left, right);
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(right, left);
    }

    public static Class[] getAllInterfaces(Object instance) {
        Assert.notNull((Object)instance, (String)"Instance must not be null");
        return GrailsClassUtils.getAllInterfacesForClass(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return GrailsClassUtils.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, ClassLoader classLoader) {
        Set<Class> ifcs = GrailsClassUtils.getAllInterfacesForClassAsSet(clazz, classLoader);
        return ifcs.toArray(new Class[ifcs.size()]);
    }

    public static Set<Class> getAllInterfacesAsSet(Object instance) {
        Assert.notNull((Object)instance, (String)"Instance must not be null");
        return GrailsClassUtils.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz) {
        return GrailsClassUtils.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz, ClassLoader classLoader) {
        Assert.notNull((Object)clazz, (String)"Class must not be null");
        LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
        while (clazz != null) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                interfaces.add(ifc);
                interfaces.addAll(GrailsClassUtils.getAllInterfacesForClassAsSet(ifc, classLoader));
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static boolean isVisible(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            Class<?> actualClass = classLoader.loadClass(clazz.getName());
            return clazz == actualClass;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isPropertyOfType(Class<?> clazz, String propertyName, Class<?> type) {
        try {
            Class<?> propType = GrailsClassUtils.getPropertyType(clazz, propertyName);
            return propType != null && propType.equals(type);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object getPropertyValueOfNewInstance(Class clazz, String propertyName, Class<?> propertyType) {
        if (clazz == null || !StringUtils.hasText((String)propertyName)) {
            return null;
        }
        try {
            return GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(BeanUtils.instantiateClass((Class)clazz), propertyName);
        }
        catch (BeanInstantiationException e) {
            return null;
        }
    }

    public static Object getPropertyValueOfNewInstance(Class<?> clazz, String propertyName) {
        if (clazz == null || !StringUtils.hasText((String)propertyName)) {
            return null;
        }
        try {
            return GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue(BeanUtils.instantiateClass(clazz), propertyName);
        }
        catch (BeanInstantiationException e) {
            return null;
        }
    }

    public static PropertyDescriptor getPropertyDescriptorForValue(Object instance, Object propertyValue) {
        PropertyDescriptor[] descriptors;
        if (instance == null || propertyValue == null) {
            return null;
        }
        for (PropertyDescriptor pd : descriptors = BeanUtils.getPropertyDescriptors(instance.getClass())) {
            Object value;
            if (!GrailsClassUtils.isAssignableOrConvertibleFrom(pd.getPropertyType(), propertyValue.getClass())) continue;
            try {
                ReflectionUtils.makeAccessible((Method)pd.getReadMethod());
                value = pd.getReadMethod().invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new FatalBeanException("Problem calling readMethod of " + pd, (Throwable)e);
            }
            if (!propertyValue.equals(value)) continue;
            return pd;
        }
        return null;
    }

    public static Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        if (clazz == null || !StringUtils.hasText((String)propertyName)) {
            return null;
        }
        try {
            PropertyDescriptor desc = BeanUtils.getPropertyDescriptor(clazz, (String)propertyName);
            if (desc != null) {
                return desc.getPropertyType();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PropertyDescriptor[] getPropertiesOfType(Class<?> clazz, Class<?> propertyType) {
        if (clazz == null || propertyType == null) {
            return new PropertyDescriptor[0];
        }
        HashSet<PropertyDescriptor> properties = new HashSet<PropertyDescriptor>();
        try {
            for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(clazz)) {
                Class<?> currentPropertyType = descriptor.getPropertyType();
                if (!GrailsClassUtils.isTypeInstanceOfPropertyType(propertyType, currentPropertyType)) continue;
                properties.add(descriptor);
            }
        }
        catch (Exception e) {
            return new PropertyDescriptor[0];
        }
        return properties.toArray(new PropertyDescriptor[properties.size()]);
    }

    private static boolean isTypeInstanceOfPropertyType(Class<?> type, Class<?> propertyType) {
        return propertyType.isAssignableFrom(type) && !propertyType.equals(Object.class);
    }

    public static PropertyDescriptor[] getPropertiesAssignableToType(Class<?> clazz, Class<?> propertySuperType) {
        if (clazz == null || propertySuperType == null) {
            return new PropertyDescriptor[0];
        }
        HashSet<PropertyDescriptor> properties = new HashSet<PropertyDescriptor>();
        try {
            for (PropertyDescriptor descriptor : BeanUtils.getPropertyDescriptors(clazz)) {
                if (!propertySuperType.isAssignableFrom(descriptor.getPropertyType())) continue;
                properties.add(descriptor);
            }
        }
        catch (Exception e) {
            return new PropertyDescriptor[0];
        }
        return properties.toArray(new PropertyDescriptor[properties.size()]);
    }

    public static PropertyDescriptor getProperty(Class<?> clazz, String propertyName, Class<?> propertyType) {
        if (clazz == null || propertyName == null || propertyType == null) {
            return null;
        }
        try {
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(clazz, (String)propertyName);
            if (pd != null && pd.getPropertyType().equals(propertyType)) {
                return pd;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PropertyDescriptor getProperty(Class<?> clazz, String propertyName) {
        if (clazz == null || propertyName == null) {
            return null;
        }
        try {
            return BeanUtils.getPropertyDescriptor(clazz, (String)propertyName);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public static String getShortName(Class targetClass) {
        return GrailsClassUtils.getShortName(targetClass.getName());
    }

    @Deprecated
    public static String getShortName(String className) {
        int i = className.lastIndexOf(".");
        if (i > -1) {
            className = className.substring(i + 1, className.length());
        }
        return className;
    }

    @Deprecated
    public static String getPropertyNameRepresentation(Class targetClass) {
        return GrailsClassUtils.getPropertyNameRepresentation(GrailsClassUtils.getShortName(targetClass));
    }

    @Deprecated
    public static String getPropertyNameRepresentation(String name) {
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        String propertyName = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        if (propertyName.indexOf(32) > -1) {
            propertyName = propertyName.replaceAll("\\s", "");
        }
        return propertyName;
    }

    @Deprecated
    public static String getClassNameRepresentation(String name) {
        StringBuilder buf = new StringBuilder();
        if (name != null && name.length() > 0) {
            String[] tokens = name.split("[^\\w\\d]");
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                buf.append(token.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(token.substring(1));
            }
        }
        return buf.toString();
    }

    @Deprecated
    public static String getPropertyName(String name) {
        return GrailsClassUtils.getPropertyNameRepresentation(name);
    }

    @Deprecated
    public static String getPropertyName(Class clazz) {
        return GrailsClassUtils.getPropertyNameRepresentation(clazz);
    }

    @Deprecated
    public static String getScriptName(Class clazz) {
        return GrailsClassUtils.getScriptName(clazz.getName());
    }

    @Deprecated
    public static String getScriptName(String name) {
        if (name.endsWith(".groovy")) {
            name = name.substring(0, name.length() - 7);
        }
        String naturalName = GrailsClassUtils.getNaturalName(GrailsClassUtils.getShortName(name));
        return naturalName.replaceAll("\\s", "-").toLowerCase();
    }

    @Deprecated
    public static String getNameFromScript(String scriptName) {
        return GrailsClassUtils.getClassNameForLowerCaseHyphenSeparatedName(scriptName);
    }

    @Deprecated
    public static String getPropertyNameForLowerCaseHyphenSeparatedName(String name) {
        return GrailsClassUtils.getPropertyName(GrailsClassUtils.getClassNameForLowerCaseHyphenSeparatedName(name));
    }

    @Deprecated
    private static String getClassNameForLowerCaseHyphenSeparatedName(String name) {
        if (name.indexOf(45) > -1) {
            StringBuilder buf = new StringBuilder();
            String[] tokens = name.split("-");
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                if (token == null || token.length() == 0) continue;
                buf.append(token.substring(0, 1).toUpperCase()).append(token.substring(1));
            }
            return buf.toString();
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    @Deprecated
    public static String getNaturalName(String name) {
        ArrayList<String> words = new ArrayList<String>();
        int i = 0;
        char[] chars = name.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            String w;
            char c = chars[j];
            if (i >= words.size()) {
                w = "";
                words.add(i, w);
            } else {
                w = (String)words.get(i);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && w.length() == 0) {
                    c = Character.toUpperCase(c);
                } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                    w = "";
                    words.add(++i, w);
                }
                words.set(i, w + c);
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            if (i == 0 && w.length() == 0 || Character.isUpperCase(w.charAt(w.length() - 1))) {
                words.set(i, w + c);
                continue;
            }
            words.add(++i, String.valueOf(c));
        }
        StringBuilder buf = new StringBuilder();
        Iterator j = words.iterator();
        while (j.hasNext()) {
            buf.append((String)j.next());
            if (!j.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static Object[] collectionToObjectArray(Collection c) {
        if (c == null) {
            return new Object[0];
        }
        return c.toArray(new Object[c.size()]);
    }

    public static boolean isMatchBetweenPrimativeAndWrapperTypes(Class leftType, Class rightType) {
        if (leftType == null) {
            throw new NullPointerException("Left type is null!");
        }
        if (rightType == null) {
            throw new NullPointerException("Right type is null!");
        }
        Class<?> r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(leftType);
        return r == rightType;
    }

    public static boolean isGroovyAssignableFrom(Class<?> leftType, Class<?> rightType) {
        boolean result;
        if (leftType == null) {
            throw new NullPointerException("Left type is null!");
        }
        if (rightType == null) {
            throw new NullPointerException("Right type is null!");
        }
        if (leftType == Object.class) {
            return true;
        }
        if (leftType == rightType) {
            return true;
        }
        Class<?> r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(leftType);
        boolean bl = result = r == rightType;
        if (!result) {
            if (rightType.isPrimitive()) {
                r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(rightType);
                if (r != null) {
                    result = leftType.isAssignableFrom(r);
                }
            } else {
                result = leftType.isAssignableFrom(rightType);
            }
        }
        return result;
    }

    public static boolean isStaticProperty(Class clazz, String propertyName) {
        Method getter = BeanUtils.findDeclaredMethod((Class)clazz, (String)GrailsClassUtils.getGetterName(propertyName), (Class[])null);
        if (getter != null) {
            return GrailsClassUtils.isPublicStatic(getter);
        }
        try {
            Field f = clazz.getDeclaredField(propertyName);
            if (f != null) {
                return GrailsClassUtils.isPublicStatic(f);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isPublicStatic(Method m) {
        int modifiers = m.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    public static boolean isPublicStatic(Field f) {
        int modifiers = f.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    public static String getGetterName(String propertyName) {
        return GrailsNameUtils.getGetterName((String)propertyName);
    }

    public static Object getStaticFieldValue(Class<?> clazz, String name) {
        Field field = ReflectionUtils.findField(clazz, (String)name);
        if (field != null) {
            ReflectionUtils.makeAccessible((Field)field);
            try {
                return field.get(clazz);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object getStaticPropertyValue(Class<?> clazz, String name) {
        Method getter = BeanUtils.findDeclaredMethod(clazz, (String)GrailsClassUtils.getGetterName(name), (Class[])null);
        try {
            if (getter != null) {
                ReflectionUtils.makeAccessible((Method)getter);
                return getter.invoke(clazz, new Object[0]);
            }
            return GrailsClassUtils.getStaticFieldValue(clazz, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getPropertyOrStaticPropertyOrFieldValue(Object obj, String name) throws BeansException {
        BeanWrapperImpl ref = new BeanWrapperImpl(obj);
        return GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue((BeanWrapper)ref, obj, name);
    }

    public static Object getPropertyOrStaticPropertyOrFieldValue(BeanWrapper ref, Object obj, String name) {
        if (ref.isReadableProperty(name)) {
            return ref.getPropertyValue(name);
        }
        if (GrailsClassUtils.isPublicField(obj, name)) {
            return GrailsClassUtils.getFieldValue(obj, name);
        }
        Class<?> clazz = obj.getClass();
        if (GrailsClassUtils.isStaticProperty(clazz, name)) {
            return GrailsClassUtils.getStaticPropertyValue(clazz, name);
        }
        return null;
    }

    public static Object getFieldValue(Object obj, String name) {
        Class<?> clazz = obj.getClass();
        try {
            Field f = clazz.getDeclaredField(name);
            return f.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isPublicField(Object obj, String name) {
        Class<?> clazz = obj.getClass();
        try {
            Field f = clazz.getDeclaredField(name);
            return Modifier.isPublic(f.getModifiers());
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static boolean isPropertyInherited(Class clz, String propertyName) {
        if (clz == null) {
            return false;
        }
        Assert.isTrue((boolean)StringUtils.hasText((String)propertyName), (String)"Argument [propertyName] cannot be null or blank");
        Class superClass = clz.getSuperclass();
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(superClass, (String)propertyName);
        return pd != null && pd.getReadMethod() != null;
    }

    public static Collection createConcreteCollection(Class interfaceType) {
        AbstractCollection elements = interfaceType.equals(List.class) || interfaceType.equals(Collection.class) ? new ArrayList() : (interfaceType.equals(SortedSet.class) ? new TreeSet() : new HashSet());
        return elements;
    }

    @Deprecated
    public static String getLogicalName(Class clazz, String trailingName) {
        return GrailsClassUtils.getLogicalName(clazz.getName(), trailingName);
    }

    @Deprecated
    public static String getLogicalName(String name, String trailingName) {
        String shortName;
        if (StringUtils.hasText((String)trailingName) && (shortName = GrailsClassUtils.getShortName(name)).indexOf(trailingName) > -1) {
            return shortName.substring(0, shortName.length() - trailingName.length());
        }
        return name;
    }

    @Deprecated
    public static String getLogicalPropertyName(String className, String trailingName) {
        return GrailsClassUtils.getLogicalName(GrailsClassUtils.getPropertyName(className), trailingName);
    }

    public static String getSetterName(String propertyName) {
        return GrailsNameUtils.getSetterName((String)propertyName);
    }

    public static boolean isGetter(String name, Class<?>[] args) {
        if (!StringUtils.hasText((String)name) || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        return name.startsWith("get") ? (name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0)) : name.startsWith("is") && (name = name.substring(2)).length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    public static String getPropertyForGetter(String getterName) {
        if (!StringUtils.hasText((String)getterName)) {
            return null;
        }
        if (getterName.startsWith("get")) {
            String prop = getterName.substring(3);
            return GrailsClassUtils.convertPropertyName(prop);
        }
        if (getterName.startsWith("is")) {
            String prop = getterName.substring(2);
            return GrailsClassUtils.convertPropertyName(prop);
        }
        return null;
    }

    private static String convertPropertyName(String prop) {
        if (prop.length() == 1) {
            return prop.toLowerCase();
        }
        if (Character.isUpperCase(prop.charAt(0)) && Character.isUpperCase(prop.charAt(1))) {
            return prop;
        }
        if (Character.isDigit(prop.charAt(0))) {
            return prop;
        }
        return Character.toLowerCase(prop.charAt(0)) + prop.substring(1);
    }

    public static String getPropertyForSetter(String setterName) {
        if (!StringUtils.hasText((String)setterName)) {
            return null;
        }
        if (setterName.startsWith("set")) {
            String prop = setterName.substring(3);
            return GrailsClassUtils.convertPropertyName(prop);
        }
        return null;
    }

    public static boolean isSetter(String name, Class[] args) {
        if (!StringUtils.hasText((String)name) || args == null) {
            return false;
        }
        if (name.startsWith("set")) {
            if (args.length != 1) {
                return false;
            }
            if ((name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0))) {
                return true;
            }
        }
        return false;
    }

    public static MetaClass getExpandoMetaClass(Class clazz) {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        Assert.isTrue((boolean)(registry.getMetaClassCreationHandler() instanceof ExpandoMetaClassCreationHandle), (String)("Grails requires an instance of [ExpandoMetaClassCreationHandle] to be set in Groovy's MetaClassRegistry! (current is : " + registry.getMetaClassCreationHandler() + ")"));
        MetaClass mc = registry.getMetaClass(clazz);
        AdaptingMetaClass adapter = null;
        if (mc instanceof AdaptingMetaClass) {
            adapter = (AdaptingMetaClass)mc;
            mc = ((AdaptingMetaClass)mc).getAdaptee();
        }
        if (!(mc instanceof ExpandoMetaClass)) {
            registry.removeMetaClass(clazz);
            mc = registry.getMetaClass(clazz);
            if (adapter != null) {
                adapter.setAdaptee(mc);
            }
        }
        Assert.isTrue((boolean)(mc instanceof ExpandoMetaClass), (String)"BUG! Method must return an instance of [ExpandoMetaClass]!");
        return mc;
    }

    public static boolean isAssignableOrConvertibleFrom(Class<?> clazz, Class<?> type) {
        if (type == null || clazz == null) {
            return false;
        }
        if (type.isPrimitive()) {
            Class<?> primitiveClass = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(type);
            if (primitiveClass == null) {
                return false;
            }
            return clazz.isAssignableFrom(primitiveClass);
        }
        return clazz.isAssignableFrom(type);
    }

    public static boolean getBooleanFromMap(String key, Map<?, ?> map) {
        boolean defaultValue = false;
        return GrailsClassUtils.getBooleanFromMap(key, map, defaultValue);
    }

    public static boolean getBooleanFromMap(String key, Map<?, ?> map, boolean defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        if (map.containsKey(key)) {
            Object o = map.get(key);
            if (o == null) {
                return defaultValue;
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return Boolean.valueOf(o.toString());
        }
        return defaultValue;
    }

    @Deprecated
    public static String getClassName(String logicalName, String trailingName) {
        Assert.isTrue((boolean)StringUtils.hasText((String)logicalName), (String)"Argument [logicalName] cannot be null or blank");
        String className = logicalName.substring(0, 1).toUpperCase() + logicalName.substring(1);
        if (trailingName != null) {
            className = className + trailingName;
        }
        return className;
    }

    public static boolean isJdk5Enum(Class<?> type) {
        return type.isEnum();
    }

    public static String findPropertyNameForValue(Object target, Object obj) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        List metaProperties = mc.getProperties();
        for (MetaProperty metaProperty : metaProperties) {
            Object val;
            if (!GrailsClassUtils.isAssignableOrConvertibleFrom(metaProperty.getType(), obj.getClass()) || (val = metaProperty.getProperty(target)) == null || !val.equals(obj)) continue;
            return metaProperty.getName();
        }
        return null;
    }

    public static boolean isClassBelowPackage(Class<?> theClass, List<?> packageList) {
        String classPackage = theClass.getPackage().getName();
        for (Object packageName : packageList) {
            if (packageName == null || !classPackage.startsWith(packageName.toString())) continue;
            return true;
        }
        return false;
    }

    public static Object instantiateFromConfig(ConfigObject config, String configKey, String defaultClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LinkageError {
        return GrailsClassUtils.instantiateFromFlatConfig(config.flatten(), configKey, defaultClassName);
    }

    public static Object instantiateFromFlatConfig(Map<String, Object> flatConfig, String configKey, String defaultClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LinkageError {
        String className = defaultClassName;
        Object configName = flatConfig.get(configKey);
        if (configName instanceof CharSequence) {
            className = configName.toString();
        }
        return ClassUtils.forName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader()).newInstance();
    }

    public static Boolean hasBeenEnhancedForFeature(Class<?> controllerClass, String featureName) {
        Object[] enhancedFor;
        boolean hasBeenEnhanced = false;
        Enhanced enhancedAnnotation = controllerClass.getAnnotation(Enhanced.class);
        if (enhancedAnnotation != null && (enhancedFor = enhancedAnnotation.enhancedFor()) != null) {
            hasBeenEnhanced = GrailsArrayUtils.contains(enhancedFor, featureName);
        }
        return hasBeenEnhanced;
    }

    public static FastClass fastClass(Class superClass) {
        FastClass.Generator gen = new FastClass.Generator();
        gen.setType(superClass);
        gen.setClassLoader(superClass.getClassLoader());
        gen.setUseCache(!Environment.isReloadingAgentEnabled());
        return gen.create();
    }

    static {
        GrailsClassUtils.registerPrimitiveClassPair(Boolean.class, Boolean.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Integer.class, Integer.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Short.class, Short.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Byte.class, Byte.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Character.class, Character.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Long.class, Long.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Float.class, Float.TYPE);
        GrailsClassUtils.registerPrimitiveClassPair(Double.class, Double.TYPE);
    }
}

