/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.InputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ApplicationNamesInfo {
    @NonNls
    private static final String COMPONENT_NAME = "ApplicationInfo";
    @NonNls
    private static final String ELEMENT_NAMES = "names";
    @NonNls
    private static final String ATTRIBUTE_PRODUCT = "product";
    @NonNls
    private static final String ATTRIBUTE_FULL_NAME = "fullname";
    @NonNls
    private static final String ATTRIBUTE_SCRIPT = "script";
    private String myProductName;
    private String myFullProductName;
    private String myLowercaseProductName;
    private String myScriptName;

    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfoHolder.ourInstance;
        if (applicationNamesInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ApplicationNamesInfo", "getInstance"));
        }
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo() {
        try {
            this.readInfo(JDOMUtil.load((InputStream)ApplicationNamesInfo.class.getResourceAsStream("/idea/" + ApplicationNamesInfo.getComponentName() + ".xml")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readInfo(Element rootElement) {
        Element names = rootElement.getChild(ELEMENT_NAMES);
        this.myProductName = names.getAttributeValue(ATTRIBUTE_PRODUCT);
        this.myFullProductName = names.getAttributeValue(ATTRIBUTE_FULL_NAME);
        this.myLowercaseProductName = StringUtil.capitalize((String)this.myProductName.toLowerCase());
        this.myScriptName = names.getAttributeValue(ATTRIBUTE_SCRIPT);
    }

    public String getProductName() {
        return this.myProductName;
    }

    public String getFullProductName() {
        return this.myFullProductName;
    }

    public String getLowercaseProductName() {
        return this.myLowercaseProductName;
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public static String getComponentName() {
        String prefix = System.getProperty("idea.platform.prefix");
        if (prefix != null) {
            return prefix + COMPONENT_NAME;
        }
        return COMPONENT_NAME;
    }

    private static class ApplicationNamesInfoHolder {
        private static final ApplicationNamesInfo ourInstance = new ApplicationNamesInfo();

        private ApplicationNamesInfoHolder() {
        }
    }
}

