/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.execution;

import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ExternalTaskExecutionInfo {
    @NotNull
    private ExternalSystemTaskExecutionSettings mySettings;
    @NotNull
    private String myExecutorId;

    public ExternalTaskExecutionInfo() {
        this(new ExternalSystemTaskExecutionSettings(), "___DUMMY___");
    }

    public ExternalTaskExecutionInfo(@NotNull ExternalSystemTaskExecutionSettings settings, @NotNull String executorId) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskExecutionInfo", "<init>"));
        }
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskExecutionInfo", "<init>"));
        }
        this.mySettings = settings;
        this.myExecutorId = executorId;
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getSettings() {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.mySettings;
        if (externalSystemTaskExecutionSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskExecutionInfo", "getSettings"));
        }
        return externalSystemTaskExecutionSettings;
    }

    public void setSettings(@NotNull ExternalSystemTaskExecutionSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskExecutionInfo", "setSettings"));
        }
        this.mySettings = settings;
    }

    @NotNull
    public String getExecutorId() {
        String string = this.myExecutorId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskExecutionInfo", "getExecutorId"));
        }
        return string;
    }

    public void setExecutorId(@NotNull String executorId) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/openapi/externalSystem/model/execution/ExternalTaskExecutionInfo", "setExecutorId"));
        }
        this.myExecutorId = executorId;
    }

    public String getDescription() {
        return StringUtil.join(this.mySettings.getTaskDescriptions(), (String)"\n");
    }

    public int hashCode() {
        int result = this.mySettings.hashCode();
        result = 31 * result + this.myExecutorId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTaskExecutionInfo task = (ExternalTaskExecutionInfo)o;
        if (!this.myExecutorId.equals(task.myExecutorId)) {
            return false;
        }
        return this.mySettings.equals(task.mySettings);
    }

    public String toString() {
        return StringUtil.join(this.mySettings.getTaskNames(), (String)" ");
    }
}

