/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQuery<Result>
implements Query<Result> {
    private boolean myIsProcessing = false;

    @Override
    @NotNull
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.forEach((Processor<Result>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AbstractQuery", "findAll"));
        }
        return collection;
    }

    @Override
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        return new UnmodifiableIterator(this.findAll().iterator());
    }

    @Override
    @Nullable
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<Result>)processor);
        return (Result)processor.getFoundValue();
    }

    private void assertNotProcessing() {
        assert (!this.myIsProcessing) : "Operation is not allowed while query is being processed";
    }

    @Override
    @NotNull
    public Result[] toArray(@NotNull Result[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/AbstractQuery", "toArray"));
        }
        this.assertNotProcessing();
        Collection<Result> all = this.findAll();
        Result[] ResultArray = all.toArray(a);
        if (ResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AbstractQuery", "toArray"));
        }
        return ResultArray;
    }

    @Override
    public boolean forEach(@NotNull Processor<Result> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/AbstractQuery", "forEach"));
        }
        this.assertNotProcessing();
        this.myIsProcessing = true;
        try {
            boolean bl = this.processResults(consumer);
            return bl;
        }
        finally {
            this.myIsProcessing = false;
        }
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<Result> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/AbstractQuery", "forEachAsync"));
        }
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(this.forEach(consumer));
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AbstractQuery", "forEachAsync"));
        }
        return asyncFuture;
    }

    protected abstract boolean processResults(@NotNull Processor<Result> var1);

    @NotNull
    protected AsyncFuture<Boolean> processResultsAsync(@NotNull Processor<Result> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/AbstractQuery", "processResultsAsync"));
        }
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(this.processResults(consumer));
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AbstractQuery", "processResultsAsync"));
        }
        return asyncFuture;
    }
}

