/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class FileBasedIndexExtension<K, V> {
    public static final ExtensionPointName<FileBasedIndexExtension> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.fileBasedIndex");
    public static final int DEFAULT_CACHE_SIZE = 1024;

    @NotNull
    public abstract ID<K, V> getName();

    @NotNull
    public abstract DataIndexer<K, V, FileContent> getIndexer();

    @NotNull
    public abstract KeyDescriptor<K> getKeyDescriptor();

    @NotNull
    public abstract DataExternalizer<V> getValueExternalizer();

    @NotNull
    public abstract FileBasedIndex.InputFilter getInputFilter();

    public abstract boolean dependsOnFileContent();

    public boolean indexDirectories() {
        return false;
    }

    public abstract int getVersion();

    public int getCacheSize() {
        return 1024;
    }

    @NotNull
    public Collection<FileType> getFileTypesWithSizeLimitNotApplicable() {
        List<FileType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexExtension", "getFileTypesWithSizeLimitNotApplicable"));
        }
        return list;
    }

    public boolean keyIsUniqueForIndexedFile() {
        return false;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return false;
    }

    public boolean hasSnapshotMapping() {
        return false;
    }
}

