/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ModuleContentRootSearchScope
extends GlobalSearchScope {
    private final ModuleRootManager myRootManager;
    private final Module myModule;

    public ModuleContentRootSearchScope(Module module) {
        super(module.getProject());
        this.myRootManager = ModuleRootManager.getInstance(module);
        this.myModule = module;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/ModuleContentRootSearchScope", "contains"));
        }
        return this.myRootManager.getFileIndex().isInContent(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/util/xml/ModuleContentRootSearchScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/util/xml/ModuleContentRootSearchScope", "compare"));
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/util/xml/ModuleContentRootSearchScope", "isSearchInModuleContent"));
        }
        return aModule == this.myModule;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }
}

