/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LanguageTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.XPathSupportProxy;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.ValueRegExpAnnotator;

public class AdvancedXmlPanel
extends AbstractInjectionPanel<AbstractTagInjection> {
    private JPanel myRoot;
    private EditorTextField myValuePattern;
    private EditorTextField myXPathCondition;
    private JLabel myXPathConditionLabel;
    private JCheckBox mySingleFileCheckBox;

    public AdvancedXmlPanel(Project project, AbstractTagInjection injection) {
        super(injection, project);
        this.$$$setupUI$$$();
    }

    @Override
    protected void apply(AbstractTagInjection other) {
        other.setValuePattern(this.myValuePattern.getText());
        other.setSingleFile(this.mySingleFileCheckBox.isSelected());
        other.setXPathCondition(this.myXPathCondition.getText());
    }

    @Override
    protected void resetImpl() {
        this.myValuePattern.setText(((AbstractTagInjection)this.myOrigInjection).getValuePattern());
        this.mySingleFileCheckBox.setSelected(((AbstractTagInjection)this.myOrigInjection).isSingleFile());
        this.myXPathCondition.setText(((AbstractTagInjection)this.myOrigInjection).getXPathCondition());
    }

    @Override
    public JPanel getComponent() {
        return this.myRoot;
    }

    private void createUIComponents() {
        this.myValuePattern = new LanguageTextField((Language)RegExpLanguage.INSTANCE, this.myProject, ((AbstractTagInjection)this.myOrigInjection).getValuePattern(), (LanguageTextField.DocumentCreator)new LanguageTextField.SimpleDocumentCreator(){

            public void customizePsiFile(PsiFile psiFile) {
                psiFile.putCopyableUserData(ValueRegExpAnnotator.KEY, (Object)Boolean.TRUE);
            }
        });
        final XPathSupportProxy proxy = XPathSupportProxy.getInstance();
        this.myXPathCondition = new LanguageTextField(proxy != null ? InjectedLanguage.findLanguageById("XPath") : null, this.myProject, ((AbstractTagInjection)this.myOrigInjection).getXPathCondition(), (LanguageTextField.DocumentCreator)new LanguageTextField.SimpleDocumentCreator(){

            public void customizePsiFile(PsiFile psiFile) {
                if (proxy != null) {
                    proxy.attachContext(psiFile);
                }
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Advanced", (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setToolTipText("<html>Enter a regular expression that selects the parts of the tag's or attribute's value the language should be injected into.<br>The pattern should contain exactly one capturing group.</html>");
        jLabel2.setText("Value pattern:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myValuePattern;
        jPanel2.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myXPathConditionLabel = jLabel = new JLabel();
        jLabel.setToolTipText("<html>Enter an XPath expression that the tag/attribute must match additionally to the name-condition specified above.<br>This requires the XPathView plugin to be installed</html>");
        jLabel.setText("XPath condition:");
        jLabel.setDisplayedMnemonic('X');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myXPathCondition;
        jPanel2.add((Component)editorTextField2, new GridConstraints(1, 1, 1, 2, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.mySingleFileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Single file");
        jCheckBox.setMnemonic('F');
        jCheckBox.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor((Component)editorTextField);
        jLabel.setLabelFor((Component)editorTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

