/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SetKeywordsDialog
extends DialogWrapper {
    private static final List<String> KNOWN_KEYWORDS = ContainerUtil.newArrayList((Object[])new String[]{"Id", "HeadURL", "LastChangedDate", "LastChangedRevision", "LastChangedBy"});
    private static final Map<String, String> KNOWN_KEYWORD_ALIASES = ContainerUtil.immutableMapBuilder().put((Object)"URL", (Object)"HeadURL").put((Object)"Date", (Object)"LastChangedDate").put((Object)"Revision", (Object)"LastChangedRevision").put((Object)"Rev", (Object)"LastChangedRevision").put((Object)"Author", (Object)"LastChangedBy").build();
    @Nullable
    private final PropertyValue myKeywordsValue;
    @NotNull
    private final List<JCheckBox> myKeywordOptions = ContainerUtil.newArrayList();

    protected SetKeywordsDialog(Project project, @Nullable PropertyValue keywordsValue) {
        super(project, false);
        this.myKeywordsValue = keywordsValue;
        this.setTitle("SVN Keywords");
        this.setResizable(false);
        this.init();
    }

    @Nullable
    public String getKeywords() {
        List selectedKeywords = ContainerUtil.filter(this.myKeywordOptions, (Condition)new Condition<JCheckBox>(){

            public boolean value(@NotNull JCheckBox keywordOption) {
                if (keywordOption == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordOption", "org/jetbrains/idea/svn/dialogs/SetKeywordsDialog$1", "value"));
                }
                return keywordOption.isSelected();
            }
        });
        return StringUtil.nullize((String)StringUtil.join((Collection)selectedKeywords, (Function)new Function<JCheckBox, String>(){

            public String fun(@NotNull JCheckBox keywordOption) {
                if (keywordOption == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordOption", "org/jetbrains/idea/svn/dialogs/SetKeywordsDialog$2", "fun"));
                }
                return keywordOption.getText();
            }
        }, (String)" "));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Select keywords to set: "), "North");
        JPanel buttonsPanel = new JPanel(new GridLayout(5, 1));
        for (String keyword : KNOWN_KEYWORDS) {
            JCheckBox keywordOption = new JCheckBox(keyword);
            this.myKeywordOptions.add(keywordOption);
            buttonsPanel.add(keywordOption);
        }
        panel.add((Component)buttonsPanel, "Center");
        return panel;
    }

    protected void init() {
        super.init();
        this.updateKeywordOptions();
    }

    private void updateKeywordOptions() {
        Set<String> keywords = SetKeywordsDialog.parseKeywords(this.myKeywordsValue);
        for (JCheckBox keywordOption : this.myKeywordOptions) {
            keywordOption.setSelected(keywords.contains(keywordOption.getText()));
        }
    }

    @NotNull
    private static Set<String> parseKeywords(@Nullable PropertyValue keywordsValue) {
        HashSet result = ContainerUtil.newHashSet();
        if (keywordsValue != null) {
            for (String keyword : StringUtil.split((String)PropertyValue.toString(keywordsValue), (String)" ")) {
                result.add(ObjectUtils.notNull((Object)KNOWN_KEYWORD_ALIASES.get(keyword), (Object)keyword));
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/SetKeywordsDialog", "parseKeywords"));
        }
        return hashSet;
    }
}

