/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.statistics;

import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.statistics.VcsUsagesCollector;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;

public class SvnWorkingCopyFormatUsagesCollector
extends VcsUsagesCollector {
    private static final String GROUP_ID = "svn working copy format";

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)GROUP_ID, (double)100.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/statistics/SvnWorkingCopyFormatUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/statistics/SvnWorkingCopyFormatUsagesCollector", "getProjectUsages"));
        }
        SvnVcs vcs = SvnVcs.getInstance(project);
        List roots = ContainerUtil.filter(vcs.getSvnFileUrlMapping().getAllWcInfos(), (Condition)new Condition<RootUrlInfo>(){

            public boolean value(RootUrlInfo info) {
                return info.getType() == null || NestedCopyType.inner.equals((Object)info.getType());
            }
        });
        Set set = ContainerUtil.map2Set((Collection)roots, (Function)new Function<RootUrlInfo, UsageDescriptor>(){

            public UsageDescriptor fun(RootUrlInfo info) {
                return new UsageDescriptor(info.getFormat().toString(), 1);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/statistics/SvnWorkingCopyFormatUsagesCollector", "getProjectUsages"));
        }
        return set;
    }
}

