/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.idea;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageCodeRenderer;
import jetbrains.coverage.report.CoverageData;
import jetbrains.coverage.report.CoverageSourceData;
import jetbrains.coverage.report.CoverageStatus;
import jetbrains.coverage.report.SourceCodeProvider;
import jetbrains.coverage.report.idea.IDEACoverageClassInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEACoverageData
implements CoverageData,
CoverageSourceData {
    private final List<ClassInfo> myClasses;
    private final SourceCodeProvider mySourceCodeProvider;

    public IDEACoverageData(ProjectData projectData, @NotNull SourceCodeProvider sourceCodeProvider) throws IOException {
        if (sourceCodeProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/idea/IDEACoverageData.<init> must not be null");
        }
        this.myClasses = new ArrayList<ClassInfo>();
        this.mySourceCodeProvider = sourceCodeProvider;
        this.init(sourceCodeProvider, projectData);
    }

    public IDEACoverageData(@NotNull String coverageIc, @NotNull SourceCodeProvider sourceCodeProvider) throws IOException {
        if (coverageIc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/idea/IDEACoverageData.<init> must not be null");
        }
        if (sourceCodeProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/idea/IDEACoverageData.<init> must not be null");
        }
        this.myClasses = new ArrayList<ClassInfo>();
        this.mySourceCodeProvider = sourceCodeProvider;
        File coverageIcFile = new File(coverageIc);
        if (!coverageIcFile.isFile()) {
            throw new FileNotFoundException("File " + coverageIc + " does not exist");
        }
        this.init(sourceCodeProvider, ProjectDataLoader.load((File)coverageIcFile));
    }

    private void init(SourceCodeProvider sourceCodeProvider, ProjectData projectData) throws IOException {
        Map<String, Collection<String>> classAndRelatedClassesMap = IDEACoverageData.collectClasses(projectData);
        for (Map.Entry<String, Collection<String>> classEntry : classAndRelatedClassesMap.entrySet()) {
            String className = classEntry.getKey();
            if (StringUtil.isEmpty((String)className) || className.startsWith("com.intellij.rt.coverage") || IDEACoverageData.isInnerClass(className)) continue;
            ClassData classData = projectData.getClassData(className);
            this.myClasses.add((ClassInfo)new IDEACoverageClassInfo(className, classData, IDEACoverageData.findRelatedClassData(projectData, classEntry.getValue())));
        }
    }

    @Nullable
    private CharSequence obtainSourceCode(IDEACoverageClassInfo ci) {
        try {
            return this.mySourceCodeProvider.getSourceCode(ci.getFQName());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void renderSourceCodeFor(@NotNull ClassInfo aClazz, @NotNull CoverageCodeRenderer renderer) {
        if (aClazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/idea/IDEACoverageData.renderSourceCodeFor must not be null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/idea/IDEACoverageData.renderSourceCodeFor must not be null");
        }
        IDEACoverageClassInfo idea = (IDEACoverageClassInfo)aClazz;
        CharSequence source = this.obtainSourceCode(idea);
        if (source == null) {
            return;
        }
        Collection<ClassData> data = idea.getClassDataWithInternal();
        TreeMap<Integer, CoverageStatus> lines = new TreeMap<Integer, CoverageStatus>();
        for (ClassData clazz : data) {
            Object[] linez = clazz.getLines();
            if (linez == null) continue;
            int linezLength = linez.length;
            for (int i = 0; i < linezLength; ++i) {
                LineData o = (LineData)linez[i];
                if (o == null) continue;
                lines.put(o.getLineNumber(), CoverageStatus.merge((CoverageStatus)((CoverageStatus)lines.get(o.getLineNumber())), (CoverageStatus)this.convertToLineCoverage(o)));
            }
        }
        int lineNum = 0;
        for (CharSequence line : jetbrains.coverage.report.impl.StringUtil.getLines((CharSequence)source)) {
            renderer.writeCodeLine(++lineNum, line, (CoverageStatus)lines.get(lineNum));
        }
        renderer.codeWriteFinished();
    }

    private CoverageStatus convertToLineCoverage(LineData status) {
        switch ((byte)status.getStatus()) {
            case 0: {
                return CoverageStatus.NONE;
            }
            case 1: {
                return CoverageStatus.PARTIAL;
            }
            case 2: {
                return CoverageStatus.FULL;
            }
        }
        return CoverageStatus.NONE;
    }

    @NotNull
    public Collection<ClassInfo> getClasses() {
        List<ClassInfo> list = this.myClasses;
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/idea/IDEACoverageData.getClasses must not return null");
        }
        return list;
    }

    public CoverageSourceData getSourceData() {
        return this;
    }

    private static Map<String, Collection<String>> collectClasses(ProjectData projectData) throws IOException {
        HashSet allClasses = new HashSet();
        allClasses.addAll(projectData.getClasses().keySet());
        HashMap<String, Collection<String>> classMap = new HashMap<String, Collection<String>>();
        Iterator i$ = allClasses.iterator();
        while (i$.hasNext()) {
            HashSet<String> relatedClasses;
            String className;
            String outerClassName = className = (String)i$.next();
            if (IDEACoverageData.isInnerClass(className)) {
                int first$ = className.indexOf(36);
                outerClassName = className.substring(0, first$);
            }
            if ((relatedClasses = (HashSet<String>)classMap.get(outerClassName)) == null) {
                relatedClasses = new HashSet<String>();
                classMap.put(outerClassName, relatedClasses);
            }
            if (outerClassName.length() == className.length()) continue;
            relatedClasses.add(className);
        }
        return classMap;
    }

    private static Collection<ClassData> findRelatedClassData(ProjectData projectData, Collection<String> classNames) {
        ArrayList<ClassData> result = new ArrayList<ClassData>();
        for (String clName : classNames) {
            ClassData cd = projectData.getClassData(clName);
            if (cd == null) continue;
            result.add(cd);
        }
        return result;
    }

    private static boolean isInnerClass(String className) {
        return className.indexOf(36) != -1;
    }
}

