/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Set;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultCancellationTokenSource;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongRunningOperation<T extends AbstractLongRunningOperation<T>>
implements LongRunningOperation {
    protected final ConnectionParameters connectionParameters;
    protected final ConsumerOperationParameters.Builder operationParamsBuilder;

    protected AbstractLongRunningOperation(ConnectionParameters parameters) {
        this.connectionParameters = parameters;
        this.operationParamsBuilder = ConsumerOperationParameters.builder();
        this.operationParamsBuilder.setCancellationToken(new DefaultCancellationTokenSource().token());
    }

    protected abstract T getThis();

    protected final ConsumerOperationParameters getConsumerOperationParameters() {
        ConnectionParameters connectionParameters = this.connectionParameters;
        return this.operationParamsBuilder.setParameters(connectionParameters).build();
    }

    public T withArguments(String ... arguments) {
        this.operationParamsBuilder.setArguments(arguments);
        return this.getThis();
    }

    public T setStandardOutput(OutputStream outputStream) {
        this.operationParamsBuilder.setStdout(outputStream);
        return this.getThis();
    }

    public T setStandardError(OutputStream outputStream) {
        this.operationParamsBuilder.setStderr(outputStream);
        return this.getThis();
    }

    public T setStandardInput(InputStream inputStream) {
        this.operationParamsBuilder.setStdin(inputStream);
        return this.getThis();
    }

    public T setColorOutput(boolean colorOutput) {
        this.operationParamsBuilder.setColorOutput(colorOutput);
        return this.getThis();
    }

    public T setJavaHome(File javaHome) {
        this.operationParamsBuilder.setJavaHome(javaHome);
        return this.getThis();
    }

    public T setJvmArguments(String ... jvmArguments) {
        this.operationParamsBuilder.setJvmArguments(jvmArguments);
        return this.getThis();
    }

    public T addProgressListener(ProgressListener listener) {
        this.operationParamsBuilder.addProgressListener(listener);
        return this.getThis();
    }

    public T addProgressListener(org.gradle.tooling.events.ProgressListener listener) {
        return (T)this.addProgressListener(listener, EnumSet.allOf(OperationType.class));
    }

    public T addProgressListener(org.gradle.tooling.events.ProgressListener listener, Set<OperationType> eventTypes) {
        if (eventTypes.contains((Object)OperationType.TEST)) {
            this.operationParamsBuilder.addTestProgressListener(listener);
        }
        if (eventTypes.contains((Object)OperationType.TASK)) {
            this.operationParamsBuilder.addTaskProgressListener(listener);
        }
        if (eventTypes.contains((Object)OperationType.GENERIC)) {
            this.operationParamsBuilder.addBuildOperationProgressListeners(listener);
        }
        return this.getThis();
    }

    public T withCancellationToken(CancellationToken cancellationToken) {
        this.operationParamsBuilder.setCancellationToken((CancellationToken)Preconditions.checkNotNull((Object)cancellationToken));
        return this.getThis();
    }
}

