/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrCreateFromUsageBaseFix
extends Intention {
    protected final SmartPsiElementPointer<GrReferenceExpression> myRefExpression;

    public GrCreateFromUsageBaseFix(@NotNull GrReferenceExpression refExpression) {
        if (refExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpression", "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix", "<init>"));
        }
        this.myRefExpression = SmartPointerManager.getInstance((Project)refExpression.getProject()).createSmartPsiElementPointer((PsiElement)refExpression);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.from.usage.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix", "getFamilyName"));
        }
        return string;
    }

    protected GrReferenceExpression getRefExpr() {
        return (GrReferenceExpression)this.myRefExpression.getElement();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix", "isAvailable"));
        }
        GrReferenceExpression element = (GrReferenceExpression)this.myRefExpression.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        List<PsiClass> targetClasses = this.getTargetClasses();
        return !targetClasses.isEmpty();
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix", "processIntention"));
        }
        List<PsiClass> classes = this.getTargetClasses();
        if (classes.size() == 1) {
            this.invokeImpl(project, classes.get(0));
        } else if (!classes.isEmpty()) {
            this.chooseClass(classes, editor);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return element instanceof GrReferenceExpression;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    private void chooseClass(List<PsiClass> classes, Editor editor) {
        Project project = classes.get(0).getProject();
        JBList list = new JBList(classes);
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        list.setSelectionMode(0);
        list.setCellRenderer(renderer);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        renderer.installSpeedSearch(builder);
        Runnable runnable = new Runnable((JList)list, project){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Project val$project;
            {
                this.val$list = jList;
                this.val$project = project;
            }

            @Override
            public void run() {
                int index = this.val$list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                final PsiClass aClass = (PsiClass)this.val$list.getSelectedValue();
                CommandProcessor.getInstance().executeCommand(this.val$project, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                GrCreateFromUsageBaseFix.this.invokeImpl(val$project, aClass);
                            }
                        });
                    }
                }, GrCreateFromUsageBaseFix.this.getText(), null);
            }
        };
        builder.setTitle(QuickFixBundle.message((String)"target.class.chooser.title", (Object[])new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
    }

    protected abstract void invokeImpl(Project var1, @NotNull PsiClass var2);

    private List<PsiClass> getTargetClasses() {
        GrReferenceExpression ref;
        boolean compileStatic = PsiUtil.isCompileStatic(ref = this.getRefExpr()) || GrStaticChecker.isPropertyAccessInStaticMethod(ref);
        PsiClass targetClass = QuickfixUtil.findTargetClass(ref, compileStatic);
        if (targetClass == null || !this.canBeTargetClass(targetClass)) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        this.collectSupers(targetClass, classes);
        return classes;
    }

    private void collectSupers(PsiClass psiClass, ArrayList<PsiClass> classes) {
        PsiClass[] supers;
        classes.add(psiClass);
        for (PsiClass aSuper : supers = psiClass.getSupers()) {
            if (classes.contains(aSuper) || !this.canBeTargetClass(aSuper)) continue;
            this.collectSupers(aSuper, classes);
        }
    }

    protected boolean canBeTargetClass(PsiClass psiClass) {
        return psiClass.getManager().isInProject((PsiElement)psiClass);
    }
}

