/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import groovy.lang.Closure;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.DslErrorReporter;
import org.jetbrains.plugins.groovy.dsl.FactorTree;
import org.jetbrains.plugins.groovy.dsl.GdslUtil;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslExecutor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;

public class GroovyDslScript {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.dsl.GroovyDslScript");
    private final Project project;
    @Nullable
    private final VirtualFile file;
    private final GroovyDslExecutor executor;
    private final String myPath;
    private final FactorTree myFactorTree;

    public GroovyDslScript(Project project, @Nullable VirtualFile file, @NotNull GroovyDslExecutor executor, String path) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/groovy/dsl/GroovyDslScript", "<init>"));
        }
        this.project = project;
        this.file = file;
        this.executor = executor;
        this.myPath = path;
        this.myFactorTree = new FactorTree(project, executor);
    }

    public boolean processExecutor(PsiScopeProcessor processor, PsiType psiType, PsiElement place, PsiFile placeFile, String qname, ResolveState state) {
        CustomMembersHolder holder = this.myFactorTree.retrieve(place, placeFile, qname);
        GroovyClassDescriptor descriptor = new GroovyClassDescriptor(psiType, place, placeFile);
        try {
            if (holder == null) {
                holder = this.addGdslMembers(descriptor, qname, psiType);
                this.myFactorTree.cache(descriptor, holder);
            }
            return holder.processMembers(descriptor, processor, state);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            this.handleDslError(e);
            return true;
        }
    }

    private CustomMembersHolder addGdslMembers(GroovyClassDescriptor descriptor, String qname, PsiType psiType) {
        ProcessingContext ctx = new ProcessingContext();
        ctx.put((Object)ClassUtil.getClassKey(qname), (Object)psiType);
        ctx.put(GdslUtil.INITIAL_CONTEXT, (Object)descriptor);
        try {
            if (!GroovyDslScript.isApplicable(this.executor, descriptor, ctx)) {
                return CustomMembersHolder.EMPTY;
            }
            return this.executor.processVariants(descriptor, ctx, psiType);
        }
        catch (InvokerInvocationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)cause;
            }
            if (cause instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)cause;
            }
            this.handleDslError(e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            this.handleDslError(e);
        }
        return CustomMembersHolder.EMPTY;
    }

    private static boolean isApplicable(@NotNull GroovyDslExecutor executor, GroovyClassDescriptor descriptor, ProcessingContext ctx) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/groovy/dsl/GroovyDslScript", "isApplicable"));
        }
        List<Pair<ContextFilter, Closure>> enhancers = executor.getEnhancers();
        if (enhancers == null) {
            LOG.error("null enhancers");
            return false;
        }
        for (Pair<ContextFilter, Closure> pair : enhancers) {
            if (!((ContextFilter)pair.first).isApplicable(descriptor, ctx)) continue;
            return true;
        }
        return false;
    }

    public boolean handleDslError(Throwable e) {
        if (this.project.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (this.file != null) {
            DslErrorReporter.getInstance().invokeDslErrorPopup(e, this.project, this.file);
        } else {
            LOG.info("Error when executing internal GDSL " + this.myPath, e);
            GdslUtil.stopGdsl();
        }
        return false;
    }

    public String toString() {
        return "GroovyDslScript: " + this.myPath;
    }

    @Nullable
    public MultiMap getStaticInfo() {
        return this.executor.getStaticInfo();
    }
}

