/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.cvsSupport2.actions.update.UpdateSettings;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsUpdatePolicy;
import com.intellij.cvsSupport2.cvshandlers.UpdateHandler;
import com.intellij.cvsSupport2.updateinfo.UpdatedFilesProcessor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdateSessionAdapter;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CvsStatusEnvironment
implements UpdateEnvironment {
    private final Project myProject;

    public CvsStatusEnvironment(Project project) {
        this.myProject = project;
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
        CvsUpdatePolicy.fillGroups(updatedFiles);
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] contentRoots, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> context) {
        if (contentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoots", "com/intellij/cvsSupport2/CvsStatusEnvironment", "updateDirectories"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/cvsSupport2/CvsStatusEnvironment", "updateDirectories"));
        }
        UpdateSettings updateSettings = UpdateSettings.DONT_MAKE_ANY_CHANGES;
        UpdateHandler handler = CommandCvsHandler.createUpdateHandler(contentRoots, updateSettings, this.myProject, updatedFiles);
        handler.addCvsListener(new UpdatedFilesProcessor(updatedFiles));
        CvsOperationExecutor cvsOperationExecutor = new CvsOperationExecutor(true, this.myProject, ModalityState.defaultModalityState());
        cvsOperationExecutor.setShowErrors(false);
        cvsOperationExecutor.performActionSync(handler, CvsOperationExecutorCallback.EMPTY);
        CvsResult result = cvsOperationExecutor.getResult();
        UpdateSessionAdapter updateSessionAdapter = new UpdateSessionAdapter(result.getErrorsAndWarnings(), result.isCanceled());
        if (updateSessionAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/CvsStatusEnvironment", "updateDirectories"));
        }
        return updateSessionAdapter;
    }

    public Configurable createConfigurable(Collection<FilePath> files) {
        return null;
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }
}

