/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import com.google.protobuf.ExtensionRegistryLite;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsProtoBuf;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0004\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rAaY\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K!!1\u0002c\u0004\u000e\u0003a\u0011\u0011d\u0001\u0005\t\u001b\u0005A\n\"\n\u0005\u0005\u0017!IQ\"\u0001\r\u00033\rA\u0019\"D\u0001\u0019\u0015\u0015BAa\u0003E\u000b\u001b\u0005A\"!G\u0002\t\u00145\t\u0001DC\u0013\t\t\u0005A1\"D\u0001\u0019\u0005e\u0019\u00012C\u0007\u00021))\u0003\u0002B\u0001\t\u00185\t\u0001DA\r\u0004\u0011'i\u0011\u0001\u0007\u0006*\u0016\u0011\u0019\u0005*\u0001E\u0002\u001b\u0005A\"!U\u0002\u0005\u000b\u0001i!\u0001\"\u0002\t\u0007%VAa\u0011%\u0002\u0011\u000fi\u0011\u0001\u0007\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\t!\u0019\u0011V\u0003\u0003D\u0011\u0006AI!D\u0001\u0019\u0005E\u001bA!\u0002\u0001\u000e\u0005\u0011)\u0001bA\u0015\u000b\t-C\u00012B\u0007\u00021\u0019\t6\u0001B\u0003\u0001\u001b\t!i\u0001C\u0004"}, strings={"Lorg/jetbrains/kotlin/builtins/BuiltInsSerializedResourcePaths;", "Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;", "()V", "CLASS_METADATA_FILE_EXTENSION", "", "getCLASS_METADATA_FILE_EXTENSION", "()Ljava/lang/String;", "PACKAGE_FILE_EXTENSION", "getPACKAGE_FILE_EXTENSION", "STRING_TABLE_FILE_EXTENSION", "getSTRING_TABLE_FILE_EXTENSION", "extensionRegistry", "Lcom/google/protobuf/ExtensionRegistryLite;", "getExtensionRegistry", "()Lcom/google/protobuf/ExtensionRegistryLite;", "getClassMetadataPath", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackageFilePath", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getStringTableFilePath", "packageFqNameToPath", "shortName"}, moduleName="kotlin-compiler")
public final class BuiltInsSerializedResourcePaths
extends SerializedResourcePaths {
    @NotNull
    public static final ExtensionRegistryLite extensionRegistry;
    @NotNull
    public static final String CLASS_METADATA_FILE_EXTENSION = "kotlin_class";
    @NotNull
    public static final String PACKAGE_FILE_EXTENSION = "kotlin_package";
    @NotNull
    public static final String STRING_TABLE_FILE_EXTENSION = "kotlin_string_table";
    public static final BuiltInsSerializedResourcePaths INSTANCE;
    public static final BuiltInsSerializedResourcePaths INSTANCE$;

    @Override
    @NotNull
    public ExtensionRegistryLite getExtensionRegistry() {
        return extensionRegistry;
    }

    @NotNull
    public final String getCLASS_METADATA_FILE_EXTENSION() {
        return CLASS_METADATA_FILE_EXTENSION;
    }

    @NotNull
    public final String getPACKAGE_FILE_EXTENSION() {
        return PACKAGE_FILE_EXTENSION;
    }

    @NotNull
    public final String getSTRING_TABLE_FILE_EXTENSION() {
        return STRING_TABLE_FILE_EXTENSION;
    }

    @Override
    @NotNull
    public String getClassMetadataPath(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        StringBuilder stringBuilder = new StringBuilder();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.getPackageFqName()");
        return stringBuilder.append(this.packageFqNameToPath(fqName2)).append("/").append(classId.getRelativeClassName().asString()).append(".").append(CLASS_METADATA_FILE_EXTENSION).toString();
    }

    @Override
    @NotNull
    public String getPackageFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + PACKAGE_FILE_EXTENSION;
    }

    @Override
    @NotNull
    public String getStringTableFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + STRING_TABLE_FILE_EXTENSION;
    }

    private final String packageFqNameToPath(FqName fqName2) {
        return StringsKt.replace$default(fqName2.asString(), '.', '/', false, 4);
    }

    private final String shortName(FqName fqName2) {
        String string;
        if (fqName2.isRoot()) {
            string = "default-package";
        } else {
            String string2 = fqName2.shortName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "fqName.shortName().asString()");
        }
        return string;
    }

    private BuiltInsSerializedResourcePaths() {
        INSTANCE = this;
        INSTANCE$ = this;
        ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
        Intrinsics.checkExpressionValueIsNotNull(extensionRegistryLite, "ExtensionRegistryLite.newInstance()");
        extensionRegistry = extensionRegistryLite;
        BuiltInsProtoBuf.registerAllExtensions(this.getExtensionRegistry());
        CLASS_METADATA_FILE_EXTENSION = CLASS_METADATA_FILE_EXTENSION;
        PACKAGE_FILE_EXTENSION = PACKAGE_FILE_EXTENSION;
        STRING_TABLE_FILE_EXTENSION = STRING_TABLE_FILE_EXTENSION;
    }

    static {
        new BuiltInsSerializedResourcePaths();
    }
}

