/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps;

import java.util.Collections;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.LexicalScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"M\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\t\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\b\u0019\u0001I\u0012\u0001'\u0001\"&%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011b\u0001\u0005\u0004\u001b\u0005A:!C\u0002\t\t5\t\u0001\u0014B)\u0004\u0003!)Q\u0005\u0003\u0003\f\u0011+i\u0011\u0001G\u0006\u001a\u0007!]Q\"\u0001\r\rKC!1\u0002#\u0006\u000e\u0003\u0011f\u0011C\u0001\u0003\u0001\u00113Ib\u0001c\u0006\u000e\t%\u0011\u0011\"\u0001S\r15\t6!\u0001E\u000eK1!!\u0002\u0003\b\u000e\u0003a\u0005\u0011d\u0001E\u000f\u001b\u0005A:!G\u0002\t\u00055\t\u0001TA\u0013\u0005\t-Aq\"D\u0001\u0019 %jAa\u0013\u0005\t\f5!\u0011BA\u0005\u00021\u0013Ab\u0001H\u0016R\u0007\ri!\u0001\"\u0004\t\u000f%ZAa\u0011\u0005\t\u00105\u0011A\u0012\u0001\r\t#\u000e!Q\u0001A\u0007\u0003\t#A\u0011\"\u000b\u0006\u0005\u0007\"AA!D\u0001\u0019\nE\u001bA!\u0002\u0001\u000e\u0005\u0011M\u0001B\u0003"}, strings={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/ReturnValueInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/AbstractJumpInstruction;", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "lexicalScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/LexicalScope;", "targetLabel", "Lorg/jetbrains/kotlin/cfg/Label;", "returnedValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/LexicalScope;Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;)V", "inputValues", "", "getInputValues", "()Ljava/util/List;", "returnExpressionIfAny", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getReturnExpressionIfAny", "()Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getReturnedValue", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "accept", "", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "createCopy", "newLabel", "toString", ""}, moduleName="kotlin-compiler")
public final class ReturnValueInstruction
extends AbstractJumpInstruction {
    @Nullable
    private final KtReturnExpression returnExpressionIfAny;
    @NotNull
    private final PseudoValue returnedValue;

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        List<PseudoValue> list = Collections.singletonList(this.returnedValue);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.singletonList(returnedValue)");
        return list;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        visitor2.visitReturnValue(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitReturnValue(this);
    }

    @NotNull
    public String toString() {
        return "ret(*|" + this.returnedValue + ") " + this.getTargetLabel();
    }

    @Override
    @NotNull
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel, @NotNull LexicalScope lexicalScope) {
        Intrinsics.checkParameterIsNotNull(newLabel, "newLabel");
        Intrinsics.checkParameterIsNotNull(lexicalScope, "lexicalScope");
        KtElement ktElement = this.getElement();
        if (ktElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        return new ReturnValueInstruction((KtExpression)ktElement, lexicalScope, newLabel, this.returnedValue);
    }

    @Nullable
    public final KtReturnExpression getReturnExpressionIfAny() {
        return this.returnExpressionIfAny;
    }

    @NotNull
    public final PseudoValue getReturnedValue() {
        return this.returnedValue;
    }

    public ReturnValueInstruction(@NotNull KtExpression returnExpression, @NotNull LexicalScope lexicalScope, @NotNull Label targetLabel, @NotNull PseudoValue returnedValue) {
        Intrinsics.checkParameterIsNotNull(returnExpression, "returnExpression");
        Intrinsics.checkParameterIsNotNull(lexicalScope, "lexicalScope");
        Intrinsics.checkParameterIsNotNull(targetLabel, "targetLabel");
        Intrinsics.checkParameterIsNotNull(returnedValue, "returnedValue");
        super(returnExpression, targetLabel, lexicalScope);
        this.returnedValue = returnedValue;
        KtElement ktElement = this.getElement();
        if (!(ktElement instanceof KtReturnExpression)) {
            ktElement = null;
        }
        this.returnExpressionIfAny = (KtReturnExpression)ktElement;
    }
}

