/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Type;
import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ComponentDescriptor;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0005)\u0001!B\u0001\t\u001f\u0015\tA1\u0001\u0003\u0001\u0019\u0001I\u0012\u0001'\u0001\"\u0006E\u001b\u0011\u0001C\u0001&\u0015!%Q\"\u0001\r\u00063\u0019AY!\u0004\u0003\n\u0005%\t\u0001t\u0001\r\u0007KAAi!D\u0004\n\u0005%\t\u0001TA\u0005\u0003\u0013\u0005A:\u0001\u0007\u0002\u001a\r!-Q\u0002B\u0005\u0003\u0013\u0005A:\u0001\u0007\u0004&\u0015!9Q\u0002B\u0005\u0003\u0013\u0005A:\u0001\u0007\u0004\u001a\u0007!=Q\"\u0001M\u0003S_!\u0011\t\bE\u0002\u001bGIa!C\u0003\u0011\u0007U\u0011A\u0012\u0001M\u00031\u000bIa!C\u0003\u0011\u0007U\u0011A\u0012\u0001M\u00041\u000fA\"!U\u0002\u0002\t\u0011\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/kotlin/container/ComponentRegistry;", "", "()V", "registrationMap", "Lcom/intellij/util/containers/MultiMap;", "Ljava/lang/reflect/Type;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "Lorg/jetbrains/annotations/NotNull;", "addAll", "", "descriptors", "", "buildRegistrationMap", "tryGetEntry", "request"}, moduleName="kotlin-compiler")
public final class ComponentRegistry {
    private MultiMap<Type, ComponentDescriptor> registrationMap = MultiMap.createLinkedSet();

    @NotNull
    public final MultiMap<Type, ComponentDescriptor> buildRegistrationMap(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        MultiMap<Type, ComponentDescriptor> registrationMap = new MultiMap<Type, ComponentDescriptor>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            for (Type registration : componentDescriptor.getRegistrations()) {
                registrationMap.putValue(registration, componentDescriptor);
            }
        }
        return registrationMap;
    }

    public final void addAll(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        this.registrationMap.putAllValues(this.buildRegistrationMap(descriptors));
    }

    @NotNull
    public final Collection<ComponentDescriptor> tryGetEntry(@NotNull Type request) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        Collection<ComponentDescriptor> collection = this.registrationMap.get(request);
        Intrinsics.checkExpressionValueIsNotNull(collection, "registrationMap.get(request)");
        return collection;
    }
}

