/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.ComparisonsKt;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KProperty;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImpl;
import org.jetbrains.kotlin.daemon.CompileServiceImpl$WhenMappings;
import org.jetbrains.kotlin.daemon.CompileServiceImpl$log$1;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.EventManger;
import org.jetbrains.kotlin.daemon.EventMangerImpl;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemonKt;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcher;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.daemon.RemoteOutputStreamClient;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.RemoteOutputStream;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"x\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AA!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001E\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0013)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0005!a!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\u0005\u0007\u0015\t\u0001bB\u0003\u0002\t\u0005)\u0011\u0001c\u0003\u0006\u0003\u0011\u0011Q!\u0001E\t\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0011\u0003)\u0011\u0001\u0002\u0003\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u000fU\u0005Q\u0004\u0004\u0001\u001a\u0003a\u0005QDAb\u0001\b\u0004\t[%C\u0002\t\u00035\t\u00014A\u0005\u0004\u0011\ti\u0011\u0001'\u0002\n\u0007!\u0019Q\"\u0001M\u0004\u0013\rAA!D\u0001\u0019\n%\u0019\u0001\"B\u0007\u00021\u0017I1\u0001\u0003\u0004\u000e\u0003a5\u0011b\u0001\u0005\b\u001b\u0005Az!\u0003\u0004\t\u00115!\u0011BA\u0005\u00021%A\n\"U\u0002\u0002\u0011')C\u0002B\u0001\t?5\t\u0001$C\r\u0004\u0011\u007fi\u0011\u0001\u0007\u0011\u001a\u0007!\u0005S\"\u0001\r!K!!1\u0002C\u0011\u000e\u0003a\r\u0013d\u0001\u0005#\u001b\u0005A:!*\u0011\u0005\u0003!\u0015S\"\u0001\u0013$#\t!\u0001\u0001C\u0012\u001a\u000f!\u001dS\"B\u0005\u0004\t\u0003I\u0011\u0001\u0007\u0011\u0019Ie\u0019\u0001\u0012J\u0007\u00021\u0015J2\u0001c\u0013\u000e\u0003a1\u0013D\u0002E'\u001b\u0011I!!C\u0001%GaE\u0011kA\u0001\tO\u0015\"A!\u0001E(\u001b\u0005A\u0012\"\n\t\u0005\u0003!AS\"\u0001M)3\rA\u0011&D\u0001\u0019Te\u0019\u0001BK\u0007\u00021+J2\u0001c\u0013\u000e\u0003a1SU\r\u0003\u0002\u0011-jA!\u0003\u0002\n\u0003a5\u0001tK\r\u0004\u00111j\u0011\u0001'\u0004\u001a\u000f!\u001dS\"B\u0005\u0004\t\u0003I\u0011\u0001\u0007\u0011\u0019Ie\u0019\u0001\u0012L\u0007\u000215J2\u0001c\u0017\u000e\u0003ai\u0013\u0004\u0002\u0005/\u001b\ta\t\u0001'\u0018\u001a\u001f!5S\"D\u0005\u0003\u0013\u0005AR%\u0003\u0002\n\u0003aU\u0013BA\u0005\u00021\u0019J!!C\u0001\u0019`ay\u0013kA\u0001\ta\u0015RAa\u0003E1\u001b\u001dIQ!\u0003\u0003\n\u0005%\t\u0001\u0004\t\r21/*s\u0001B\u0006\t\u001f5!\u0011BA\u0005\u00021\u0017A:&J\u0004\u0005\u0017!\u0001R\u0002B\u0005\u0003\u0013\u0005AJ\u0001g\u0016&\u000f\u0011Y\u00012M\u0007\u0005\u0013\tI\u0011\u0001'\u0006\u0019X\u0015ZB!\u0001\u00053\u001b\u0011I!!C\u0001%Ga]\u0013C\u0001\u0003\u0001\u0011\rJB\u0001B\u0001\tf5\t\u0001dM\r\u0005\t\u0005A9'D\u0001\u0019De1\u0001RJ\u0007\u0005\u0013\tI\u0011\u0001J\u0012\u0019\u0012\u0015vB!\u0011\t\ti5!\u0011BA\u0005\u0002I\rB:&\u0005\u0002\u0005\u0001!\u0019\u0013\u0004\u0002\u0003\u0002\u0011Kj\u0011\u0001G\u001a\u001a\t\u0011\t\u0001rM\u0007\u00021\u0007J\u0012\u0002#\u0014\u000e\u000f%)\u0011\u0002B\u0005\u0003\u0013\u0005!3\u0005g\u0016\u0019\u0012\u0015ZB!\u0001E5\u001b\u0011I!!C\u0001%Ga]\u0013C\u0001\u0003\u0001\u0011\rJB\u0001B\u0001\tf5\t\u0001dM\r\u0005\t\u0005A9'D\u0001\u0019De1\u0001RJ\u0007\u0005\u0013\tI\u0011\u0001J\u0012\u0019\u0012\u0015ZB!\u0001\u00056\u001b\u0011I!!C\u0001%Ga]\u0013C\u0001\u0003\u0001\u0011\rJB\u0001B\u0001\tf5\t\u0001dM\r\u0005\t\u0005A9'D\u0001\u0019De1\u0001RJ\u0007\u0005\u0013\tI\u0011\u0001G\u0005\u0019\u0012\u0015BB!\u0001E6\u001b\u0011I!!C\u0001\u0019ma]\u0013\u0004\u0002\u0003\u0002\u0011Kj\u0011\u0001G\u001a\u001a\t\u0011\t\u0001rM\u0007\u00021\u0007Jb\u0001#\u0014\u000e\t%\u0011\u0011\"\u0001\r\n1#)C\u0001B\u0001\tn5\t\u0001$C\u0013\r\t-Aq'\u0004\u0003\n\u0005%\t\u0001T\u0002M,3\u0011Ay'\u0004\u0002\r\u0002a\u0001S\u0005\u0002\u0003\u0002\u0011aj\u0011\u0001G\u0005&\u0019\u0011Y\u0001\u0012O\u0007\u0005\u0013\tI\u0011\u0001\u0007\u001c\u0019Xe!\u0001rN\u0007\u0003\u0019\u0003A\u0002%J\u0006\u0005\u0017!IT\u0002B\u0005\u0003\u0013\u0005Ab\u0007g\u0016\u001a\u0007!aS\"\u0001M\u0007K;\"1\u0002c\u001d\u000e\t%\u0011\u0011\"\u0001M\u00071/J2\u0001\u0003\u0017\u000e\u0003a5\u0011d\u0001\u0005;\u001b\u0005A*(G\u0004\tH5)\u0011b\u0001C\u0001\u0013\u0005A\u0002\u0005\u0007\u0013\u001a\u0007!YT\"\u0001M*3\rA9(D\u0001\u0019[e\u0019\u0001\u0002P\u0007\u00021sJ2\u0001C\u001f\u000e\u0003ai\u0013\u0004\u0002\u0005/\u001b\ta\t\u0001'\u0018R\u0007\u0005AY(*\u0018\u0005\u0017!qT\u0002B\u0005\u0003\u0013\u0005Aj\u0001g\u0016\u001a\u0007!aS\"\u0001M\u00073\rA!(D\u0001\u0019ve9\u0001rI\u0007\u0006\u0013\r!\t!C\u0001\u0019Aa!\u0013d\u0001\u0005<\u001b\u0005A\u001a&G\u0002\tx5\t\u0001$L\r\u0004\u0011{j\u0011\u0001'\u001f\u001a\u0007!iT\"\u0001\r.3\u0011Aa&\u0004\u0002\r\u0002au\u0013kA\u0001\t|\u0015ZAa\u0003\u0005@\u001b\u0011I!!C\u0001\u0019Da]\u0013d\u0001E@\u001b\u0005A\u001a%j\u0004\u0005\u0017!\u0001\r!\u0004\u0003\n\u0005%\t\u0001D\u000eM,KE!\u0011\t\u0005EA\u00025\t\u00014IM\u0007\u0011\u0005\u0007Q\u0002B\u0005\u0003\u0013\u0005A\u001a\u0005'\u0005\u001a\b!\r\r!D\u0001\u0019A\u0015&A!\u0001\u0005C\u00025\t\u0001$CS\u0005\t\u0005A)\u0019A\u0007\u00021%I\u0013\u0002b!\u001d\u0011)i\u0011\u0001'\u0006\u001d\u0003\u0001\n\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00175\t\u0001tC)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!aQ\"\u0001M\r#\u000e\tQ\u0001A\u0015\u000b\t\rC\u0001BA\u0007\u00021\u000b\t6\u0001B\u0003\u0001\u001b\t!Q\u0002c\u0007*\u0015\u0011\u0019\u0005\u0002C\u0002\u000e\u0003a\u001d\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0004E\u000fS)!1\t\u0003\u0005\u0006\u001b\u0005AZ!U\u0002\u0005\u000b\u0001i!\u0001B\b\t %RAa\u0011\u0005\t\t5\t\u0001\u0014B)\u0004\t\u0015\u0001QB\u0001\u0003\u0011\u0011CIs\u0001B!\t\u0011Ei\u0011\u0001g\tR\u0007\u0005)\u0001!\u000b\u0006\u0005\u0007\"A!#D\u0001\u0019\u0016q\u0019\u0013kA\u0002\u000e\u0005\u0011\u0015\u0002bE\u0015\u0012\t\u0005C\u0001rE\u0007\u0006!S)\"\u0001$\u0001\u0019)a!B$I)\u0004\r\u0015\u0011AA\u0006E\u0017\u001b\t!Q\u0003c\u000b*\u001b\u0011\u0019\u0005\u0002\u0003\u0005\u000e\t%\u0011\u0011\"\u0001\r\n1#\t6\u0001B\u0003\u0001\u001b\t!q\u0003c\f*\u0015\u0011\u0019\u0005\u0002\u0003\u0004\u000e\u0003a5\u0011k\u0001\u0003\u0006\u00015\u0011A\u0001\u0007E\u0019S)!1\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001B\r\t4%:A!\u0011\u000f\t55\t\u0001TG)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!YR\"\u0001M\u001c#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\u0002H\u0007\u000213\t6!A\u0003\u0001S!!\u0011\t\u0003E\u001d\u001b\u0005AR$U\u0002\u0003\u000b\u0005AY$\u000b\u0006\u0005\u0007\"Aq!D\u0001\u0019\u0010E\u001bA!\u0002\u0001\u000e\u0005\u0011q\u0002R\b"}, strings={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/daemon/CompilerSelector;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "_lastUsedSeconds", "", "classpathWatcher", "Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher;", "compilationsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCompiler", "()Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "getCompilerId", "()Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "getDaemonJVMOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "getDaemonOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "internalRng", "Ljava/util/Random;", "lastUsedSeconds", "getLastUsedSeconds", "()J", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "getOnShutdown", "()Lkotlin/jvm/functions/Function0;", "getPort", "()I", "getRegistry", "()Ljava/rmi/registry/Registry;", "runFile", "Ljava/io/File;", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "sessionsIdCounter", "state", "org/jetbrains/kotlin/daemon/CompileServiceImpl$state$1", "Lorg/jetbrains/kotlin/daemon/CompileServiceImpl$state$1;", "getTimer", "()Ljava/util/Timer;", "callVoidStaticMethod", "classFqName", "", "methodName", "checkCompilerId", "", "expectedCompilerId", "checkedCompile", "R", "args", "", "serviceOut", "Ljava/io/PrintStream;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "body", "([Ljava/lang/String;Ljava/io/PrintStream;Lorg/jetbrains/kotlin/daemon/common/Profiler;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "clearJarCache", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManger", "Lorg/jetbrains/kotlin/daemon/EventManger;", "doCompile", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "sessionId", "compilerMessagesStreamProxy", "Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;", "serviceOutputStreamProxy", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;Lkotlin/jvm/functions/Function3;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "getClients", "", "getUsedMemory", "ifAlive", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImpl$Aliveness;", "ignoreCompilerChanged", "ifAliveChecksImpl", "ifAliveExclusive", "ifAliveExclusive_Nothing", "ifAlive_Nothing", "", "initiateElections", "leaseCompileSession", "aliveFlagPath", "periodicAndAfterSessionCheck", "registerClient", "releaseCompileSession", "remoteCompile", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "servicesFacade", "compilerOutputStream", "outputFormat", "Lorg/jetbrains/kotlin/daemon/common/CompileService$OutputFormat;", "serviceOutputStream", "(ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/CompileService$OutputFormat;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "remoteIncrementalCompile", "compilerOutputFormat", "scheduleShutdown", "graceful", "shutdown", "shutdownCondition", "check", "message", "shutdownImpl", "shutdownWithDelay", "Aliveness", "ClientOrSessionProxy"}, moduleName="kotlin-compiler")
public final class CompileServiceImpl
implements CompileService {
    private final AtomicInteger sessionsIdCounter;
    private final AtomicInteger compilationsCounter;
    private final Random internalRng;
    private final LazyClasspathWatcher classpathWatcher;
    private final state.1 state;
    private volatile long _lastUsedSeconds;
    private final Lazy<Logger> log$delegate;
    private final ReentrantReadWriteLock rwlock;
    private File runFile;
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final CompilerId compilerId;
    @NotNull
    private final DaemonOptions daemonOptions;
    @NotNull
    private final DaemonJVMOptions daemonJVMOptions;
    private final int port;
    @NotNull
    private final Timer timer;
    @NotNull
    private final Function0<Unit> onShutdown;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    public final long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this._lastUsedSeconds;
    }

    private final Logger getLog() {
        return LazyKt.getValue(this.log$delegate, this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public CompileService.CallResult<DaemonOptions> getDaemonOptions() {
        return CompileServiceImpl.ifAlive$default(this, null, false, new Function0<DaemonOptions>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            @NotNull
            public final DaemonOptions invoke() {
                return this.this$0.getDaemonOptions();
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 3);
    }

    @Override
    @NotNull
    public CompileService.CallResult<DaemonJVMOptions> getDaemonJVMOptions() {
        return CompileServiceImpl.ifAlive$default(this, null, false, new Function0<DaemonJVMOptions>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            @NotNull
            public final DaemonJVMOptions invoke() {
                return this.this$0.getDaemonJVMOptions();
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 3);
    }

    @Override
    @NotNull
    public CompileService.CallResult registerClient(@Nullable String aliveFlagPath) {
        return CompileServiceImpl.ifAlive_Nothing$default(this, null, false, new Function0<Unit>(this, aliveFlagPath){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ String $aliveFlagPath;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Set<ClientOrSessionProxy> lock$iv = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                synchronized (lock$iv) {
                    boolean bl = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies().add(new ClientOrSessionProxy(this.$aliveFlagPath));
                }
            }
            {
                this.this$0 = compileServiceImpl;
                this.$aliveFlagPath = string;
                super(0);
            }
        }, 3);
    }

    @Override
    @NotNull
    public CompileService.CallResult<List<String>> getClients() {
        return CompileServiceImpl.ifAlive$default(this, null, false, new Function0<List<? extends String>>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final List<String> invoke() {
                List list;
                Set<ClientOrSessionProxy> lock$iv = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                synchronized (lock$iv) {
                    void destination$iv$iv;
                    void $receiver$iv$iv$iv;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                    Iterable iterable = $receiver$iv;
                    Collection collection = new ArrayList<E>();
                    void var5_5 = $receiver$iv$iv;
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        Boolean bl;
                        T element$iv$iv = element$iv$iv$iv;
                        ClientOrSessionProxy it = (ClientOrSessionProxy)element$iv$iv;
                        if (it.getAliveFlagPath() != null) {
                            void $receiver$iv$iv$iv2;
                            void it$iv$iv = $receiver$iv$iv$iv2;
                            bl = destination$iv$iv.add(it$iv$iv);
                            continue;
                        }
                        bl = null;
                    }
                    list = (List)destination$iv$iv;
                }
                return list;
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 3);
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseCompileSession(@Nullable String aliveFlagPath) {
        return CompileServiceImpl.ifAlive$default(this, Aliveness.Alive, false, new Function0<Integer>(this, aliveFlagPath){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ String $aliveFlagPath;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final int invoke() {
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = CompileServiceImpl.access$getSessionsIdCounter$p(this.this$0).incrementAndGet();
                ClientOrSessionProxy session = new ClientOrSessionProxy(this.$aliveFlagPath);
                int n = 1;
                int n2 = 100;
                if (n <= n2) {
                    while (true) {
                        void attempt;
                        void newId;
                        if (newId.element != 0) {
                            void lock$iv;
                            Map<Integer, ClientOrSessionProxy> map2 = CompileServiceImpl.access$getState$p(this.this$0).getSessions();
                            synchronized (lock$iv) {
                                block7: {
                                    if (CompileServiceImpl.access$getState$p(this.this$0).getSessions().containsKey(newId.element)) break block7;
                                    CompileServiceImpl.access$getState$p(this.this$0).getSessions().put(newId.element, session);
                                    CompileServiceImpl.access$getLog$p(this.this$0).info("leased a new session " + newId.element + ", client alive file: " + this.$aliveFlagPath);
                                    int n3 = newId.element;
                                    return n3;
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                        newId.element = CompileServiceImpl.access$getSessionsIdCounter$p(this.this$0).addAndGet(CompileServiceImpl.access$getInternalRng$p(this.this$0).nextInt());
                        if (attempt == n2) break;
                        ++attempt;
                    }
                }
                throw (Throwable)new IllegalStateException("Invalid state or algorithm error");
            }
            {
                this.this$0 = compileServiceImpl;
                this.$aliveFlagPath = string;
                super(0);
            }
        }, 2);
    }

    @Override
    @NotNull
    public CompileService.CallResult releaseCompileSession(int sessionId) {
        return CompileServiceImpl.ifAlive_Nothing$default(this, Aliveness.LastSession, false, new Function0<Unit>(this, sessionId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $sessionId;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Map<Integer, ClientOrSessionProxy> lock$iv = CompileServiceImpl.access$getState$p(this.this$0).getSessions();
                synchronized (lock$iv) {
                    CompileServiceImpl.access$getState$p(this.this$0).getSessions().remove(this.$sessionId);
                    CompileServiceImpl.access$getLog$p(this.this$0).info("cleaning after session " + this.$sessionId);
                    CompileServiceImpl.access$clearJarCache(this.this$0);
                    CompileServiceImpl.access$getState$p(this.this$0).getSessions().isEmpty();
                    Unit unit = Unit.INSTANCE;
                }
                TimersKt.schedule(this.this$0.getTimer(), 0L, (Function1<? super TimerTask, Unit>)new Function1<TimerTask, Unit>(this){
                    final /* synthetic */ releaseCompileSession.1 this$0;

                    public final void invoke(TimerTask $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        CompileServiceImpl.access$periodicAndAfterSessionCheck(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = compileServiceImpl;
                this.$sessionId = n;
                super(0);
            }
        }, 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCompilerId(@NotNull CompilerId expectedCompilerId) {
        Intrinsics.checkParameterIsNotNull(expectedCompilerId, "expectedCompilerId");
        if (!StringsKt.isEmpty((CharSequence)this.compilerId.getCompilerVersion())) {
            if (!Intrinsics.areEqual(this.compilerId.getCompilerVersion(), expectedCompilerId.getCompilerVersion())) return false;
        }
        Iterable $receiver$iv = this.compilerId.getCompilerClasspath();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            if (expectedCompilerId.getCompilerClasspath().contains(it)) continue;
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (this.classpathWatcher.isChanged()) return false;
        return true;
    }

    @Override
    @NotNull
    public CompileService.CallResult<Long> getUsedMemory() {
        return CompileServiceImpl.ifAlive$default(this, null, false, getUsedMemory.1.INSTANCE, 3);
    }

    @Override
    @NotNull
    public CompileService.CallResult shutdown() {
        return this.ifAliveExclusive_Nothing(Aliveness.LastSession, true, new Function0<Unit>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            public final void invoke() {
                CompileServiceImpl.access$shutdownImpl(this.this$0);
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public CompileService.CallResult<Boolean> scheduleShutdown(boolean graceful) {
        return CompileServiceImpl.ifAlive$default(this, Aliveness.Alive, false, new Function0<Boolean>(this, graceful){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ boolean $graceful;

            public final boolean invoke() {
                boolean bl;
                if (!this.$graceful || CompileServiceImpl.access$getState$p(this.this$0).getAlive().compareAndSet(Aliveness.Alive.ordinal(), Aliveness.LastSession.ordinal())) {
                    TimersKt.schedule(this.this$0.getTimer(), 0L, (Function1<? super TimerTask, Unit>)new Function1<TimerTask, Unit>(this){
                        final /* synthetic */ scheduleShutdown.1 this$0;

                        public final void invoke(TimerTask $receiver) {
                            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                            CompileServiceImpl.access$ifAliveExclusive(this.this$0.this$0, Aliveness.LastSession, true, new Function0<Unit>(this){
                                final /* synthetic */ scheduleShutdown.1 this$0;

                                public final void invoke() {
                                    if (!this.this$0.this$0.$graceful || CompileServiceImpl.access$getState$p(this.this$0.this$0.this$0).getSessions().isEmpty()) {
                                        CompileServiceImpl.access$shutdownImpl(this.this$0.this$0.this$0);
                                    } else {
                                        CompileServiceImpl.access$getLog$p(this.this$0.this$0.this$0).info("Some sessions are active, waiting for them to finish");
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$graceful = bl;
                super(0);
            }
        }, 2);
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> remoteCompile(int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat outputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(outputFormat, "outputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(sessionId, args, compilerOutputStream, serviceOutputStream, operationsTracer, (Function3<? super PrintStream, ? super EventManger, ? super Profiler, ? extends ExitCode>)new Function3<PrintStream, EventManger, Profiler, ExitCode>(this, outputFormat, targetPlatform, args, servicesFacade){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $outputFormat;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull EventManger eventManager, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                Intrinsics.checkParameterIsNotNull(eventManager, "eventManager");
                Intrinsics.checkParameterIsNotNull(profiler, "profiler");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$0[this.$outputFormat.ordinal()]) {
                    case 1: {
                        ExitCode exitCode2 = this.this$0.getCompiler().get(this.$targetPlatform).exec(printStream, Arrays.copyOf(this.$args, this.$args.length));
                        exitCode = exitCode2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode2), "compiler[targetPlatform].exec(printStream, *args)");
                        break;
                    }
                    case 2: {
                        ExitCode exitCode3 = this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, eventManager, profiler), Arrays.copyOf(this.$args, this.$args.length));
                        exitCode = exitCode3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode3), "compiler[targetPlatform]\u2026anager, profiler), *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "when (outputFormat) {\n  \u2026 *args)\n                }");
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$outputFormat = outputFormat;
                this.$targetPlatform = targetPlatform;
                this.$args = stringArray;
                this.$servicesFacade = compilerCallbackServicesFacade;
                super(3);
            }
        });
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> remoteIncrementalCompile(int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat compilerOutputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(compilerOutputFormat, "compilerOutputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(sessionId, args, compilerOutputStream, serviceOutputStream, operationsTracer, (Function3<? super PrintStream, ? super EventManger, ? super Profiler, ? extends ExitCode>)new Function3<PrintStream, EventManger, Profiler, ExitCode>(this, compilerOutputFormat, targetPlatform, servicesFacade, args){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $compilerOutputFormat;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;
            final /* synthetic */ String[] $args;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull EventManger eventManager, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                Intrinsics.checkParameterIsNotNull(eventManager, "eventManager");
                Intrinsics.checkParameterIsNotNull(profiler, "profiler");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$1[this.$compilerOutputFormat.ordinal()]) {
                    case 1: {
                        throw (Throwable)new NotImplementedError("Only XML output is supported in remote incremental compilation");
                    }
                    case 2: {
                        exitCode = this.this$0.getCompiler().get(this.$targetPlatform).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, eventManager, profiler), Arrays.copyOf(this.$args, this.$args.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "compiler[targetPlatform]\u2026anager, profiler), *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "when (compilerOutputForm\u2026 *args)\n                }");
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$compilerOutputFormat = outputFormat;
                this.$targetPlatform = targetPlatform;
                this.$servicesFacade = compilerCallbackServicesFacade;
                this.$args = stringArray;
                super(3);
            }
        });
    }

    private final void periodicAndAfterSessionCheck() {
        CompileServiceImpl.ifAlive_Nothing$default(this, Aliveness.LastSession, false, new Function0<Unit>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                block20: {
                    block21: {
                        boolean res$iv;
                        boolean res$iv22;
                        ArrayList<T> arrayList;
                        Object $receiver$iv;
                        CompileServiceImpl this_$iv;
                        Object message$iv;
                        block19: {
                            boolean res$iv3;
                            CompileServiceImpl compileServiceImpl = this.this$0;
                            message$iv = "Unused timeout exceeded " + this.this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() + "s, shutting down";
                            boolean bl = res$iv3 = this.this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_S() && CompileServiceImpl.access$getCompilationsCounter$p(this.this$0).get() == 0 && CompileServiceImplKt.nowSeconds() - this.this$0.getLastUsedSeconds() > (long)this.this$0.getDaemonOptions().getAutoshutdownUnusedSeconds();
                            if (res$iv3) {
                                CompileServiceImpl.access$getLog$p(this_$iv).info((String)message$iv);
                            }
                            if (!res$iv3) break block19;
                            this.this$0.shutdown();
                            break block20;
                        }
                        Object lock$iv = CompileServiceImpl.access$getState$p(this.this$0).getSessions();
                        synchronized (lock$iv) {
                            $receiver$iv = CompileServiceImpl.access$getState$p(this.this$0).getSessions();
                            LinkedHashMap<Integer, ClientOrSessionProxy> result$iv = new LinkedHashMap<Integer, ClientOrSessionProxy>();
                            Iterator<Map.Entry<Integer, ClientOrSessionProxy>> res$iv3 = MapsKt.iterator($receiver$iv);
                            while (res$iv3.hasNext()) {
                                Map.Entry<Integer, ClientOrSessionProxy> entry$iv = res$iv3.next();
                                ClientOrSessionProxy it = entry$iv.getValue();
                                if (!(!it.isAlive())) continue;
                                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                            }
                            arrayList = CollectionsKt.toArrayList((Collection)((Map)result$iv).keySet());
                        }
                        Object $receiver$iv2 = arrayList;
                        $receiver$iv = $receiver$iv2.iterator();
                        while ($receiver$iv.hasNext()) {
                            E element$iv = $receiver$iv.next();
                            int it = ((Number)element$iv).intValue();
                            this.this$0.releaseCompileSession(it);
                        }
                        $receiver$iv2 = this.this$0;
                        message$iv = "All sessions finished, shutting down";
                        boolean bl = res$iv22 = CompileServiceImpl.access$getState$p(this.this$0).getAlive().get() == Aliveness.LastSession.ordinal() && MapsKt.none(CompileServiceImpl.access$getState$p(this.this$0).getSessions());
                        if (res$iv22) {
                            CompileServiceImpl.access$getLog$p(this_$iv).info((String)message$iv);
                        }
                        if (res$iv22) {
                            this.this$0.shutdown();
                        }
                        lock$iv = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                        synchronized (lock$iv) {
                            void destination$iv$iv;
                            void $receiver$iv$iv;
                            message$iv = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                            Set<ClientOrSessionProxy> $i$a$4 = CompileServiceImpl.access$getState$p(this.this$0).getClientProxies();
                            Object res$iv22 = $receiver$iv;
                            Collection $i$f$shutdownCondition = new ArrayList<E>();
                            for (T element$iv$iv : $receiver$iv$iv) {
                                ClientOrSessionProxy it = (ClientOrSessionProxy)element$iv$iv;
                                if (!(!it.isAlive())) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List list = (List)destination$iv$iv;
                            Boolean bl2 = $i$a$4.removeAll(list);
                        }
                        if (CompileServiceImpl.access$getState$p(this.this$0).getClientProxies().isEmpty() && CompileServiceImpl.access$getCompilationsCounter$p(this.this$0).get() > 0 && !CompileServiceImpl.access$getState$p(this.this$0).getDelayedShutdownQueued().get()) {
                            CompileServiceImpl.access$getLog$p(this.this$0).info("No more clients left, delayed shutdown in " + this.this$0.getDaemonOptions().getShutdownDelayMilliseconds() + "ms");
                            CompileServiceImpl.access$shutdownWithDelay(this.this$0);
                        }
                        lock$iv = this.this$0;
                        message$iv = "Idle timeout exceeded " + this.this$0.getDaemonOptions().getAutoshutdownIdleSeconds() + "s, shutting down";
                        boolean bl3 = res$iv = this.this$0.getDaemonOptions().getAutoshutdownIdleSeconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_S() && CompileServiceImplKt.nowSeconds() - this.this$0.getLastUsedSeconds() > (long)this.this$0.getDaemonOptions().getAutoshutdownIdleSeconds();
                        if (res$iv) {
                            CompileServiceImpl.access$getLog$p(this_$iv).info((String)message$iv);
                        }
                        if (res$iv) break block21;
                        this_$iv = this.this$0;
                        message$iv = "Run file removed, shutting down";
                        boolean bl4 = res$iv = !CompileServiceImpl.access$getRunFile$p(this.this$0).exists();
                        if (res$iv) {
                            CompileServiceImpl.access$getLog$p(this_$iv).info((String)message$iv);
                        }
                        if (res$iv) break block21;
                        this_$iv = this.this$0;
                        message$iv = "Compiler changed";
                        res$iv = CompileServiceImpl.access$getClasspathWatcher$p(this.this$0).isChanged();
                        if (res$iv) {
                            CompileServiceImpl.access$getLog$p(this_$iv).info((String)message$iv);
                        }
                        if (!res$iv) break block20;
                    }
                    this.this$0.shutdown();
                }
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 2);
    }

    private final void initiateElections() {
        CompileServiceImpl.ifAlive_Nothing$default(this, null, false, new Function0<Unit>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void comparator$iv;
                Comparator<T> comparator2 = ComparisonsKt.reversed(new DaemonJVMOptionsMemoryComparator());
                Sequence<R> sequence2 = SequencesKt.filter(SequencesKt.map(ClientUtilsKt.walkDaemons(new File(DaemonParamsKt.getRunFilesPathOrDefault(this.this$0.getDaemonOptions())), this.this$0.getCompilerId(), (Function2<? super File, ? super Integer, Boolean>)new Function2<File, Integer, Boolean>(this){
                    final /* synthetic */ initiateElections.1 this$0;

                    public final boolean invoke(@NotNull File f, int p) {
                        Intrinsics.checkParameterIsNotNull(f, "f");
                        return p != this.this$0.this$0.getPort();
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }, (Function2<? super DaemonReportCategory, ? super String, Unit>)new Function2<DaemonReportCategory, String, Unit>(this){
                    final /* synthetic */ initiateElections.1 this$0;

                    public final void invoke(@NotNull DaemonReportCategory lvl, @NotNull String msg) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)lvl), "lvl");
                        Intrinsics.checkParameterIsNotNull(msg, "msg");
                        CompileServiceImpl.access$getLog$p(this.this$0.this$0).info(msg);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }), initiateElections.aliveWithOpts.3.INSTANCE), initiateElections.aliveWithOpts.4.INSTANCE);
                Comparator comparator3 = new Comparator<T>((Comparator)comparator$iv){
                    final /* synthetic */ Comparator $comparator;

                    public int compare(T a, T b) {
                        Pair it;
                        Comparator comparator$iv = this.$comparator;
                        Pair pair = (Pair)a;
                        Comparator comparator2 = comparator$iv;
                        DaemonJVMOptions daemonJVMOptions = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                        it = (Pair)b;
                        DaemonJVMOptions daemonJVMOptions2 = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                        return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
                    }
                    {
                        this.$comparator = comparator2;
                    }
                };
                Sequence<R> aliveWithOpts2 = SequencesKt.sortedWith(sequence2, comparator3);
                if (SequencesKt.any(aliveWithOpts2)) {
                    DaemonJVMOptions fattestOpts = (DaemonJVMOptions)((CompileService.CallResult)((Pair)SequencesKt.first(aliveWithOpts2)).getSecond()).get();
                    if (DaemonParamsKt.memorywiseFitsInto(fattestOpts, this.this$0.getDaemonJVMOptions()) && !DaemonParamsKt.memorywiseFitsInto(this.this$0.getDaemonJVMOptions(), fattestOpts)) {
                        Sequence<R> $receiver$iv = aliveWithOpts2;
                        Iterator<R> iterator2 = $receiver$iv.iterator();
                        while (iterator2.hasNext()) {
                            Unit unit;
                            R element$iv = iterator2.next();
                            Pair it = (Pair)element$iv;
                            if (AddToStdlibKt.check(((CompileService)it.getFirst()).getClients(), initiateElections.1.1.INSTANCE) != null) {
                                void $receiver$iv2;
                                void $receiver$iv3;
                                CompileService.CallResult it2 = (CompileService.CallResult)$receiver$iv3;
                                Iterable iterable = (Iterable)it2.get();
                                for (T element$iv2 : $receiver$iv2) {
                                    String it3 = (String)element$iv2;
                                    this.this$0.registerClient(it3);
                                }
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            ((CompileService)it.getFirst()).scheduleShutdown(true);
                        }
                    } else if (DaemonParamsKt.memorywiseFitsInto(this.this$0.getDaemonJVMOptions(), fattestOpts)) {
                        Unit unit;
                        this.this$0.scheduleShutdown(true);
                        A $receiver$iv = ((Pair)SequencesKt.first(aliveWithOpts2)).getFirst();
                        CompileService fattest = (CompileService)$receiver$iv;
                        CompileService.CallResult<List<String>> callResult = AddToStdlibKt.check(this.this$0.getClients(), initiateElections.2.1.INSTANCE);
                        if (callResult != null) {
                            void $receiver$iv4;
                            CompileService.CallResult<List<String>> element$iv = callResult;
                            CompileService.CallResult it = (CompileService.CallResult)$receiver$iv4;
                            Iterable $receiver$iv3 = (Iterable)it.get();
                            for (T element$iv3 : $receiver$iv3) {
                                String it4 = (String)element$iv3;
                                fattest.registerClient(it4);
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    }
                }
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        }, 3);
    }

    private final void shutdownImpl() {
        this.getLog().info("Shutdown started");
        this.state.getAlive().set(Aliveness.Dying.ordinal());
        UnicastRemoteObject.unexportObject(this, true);
        this.getLog().info("Shutdown complete");
        this.onShutdown.invoke();
    }

    private final void shutdownWithDelay() {
        this.state.getDelayedShutdownQueued().set(true);
        int currentCompilationsCount = this.compilationsCounter.get();
        TimersKt.schedule(this.timer, this.daemonOptions.getShutdownDelayMilliseconds(), (Function1<? super TimerTask, Unit>)new Function1<TimerTask, Unit>(this, currentCompilationsCount){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $currentCompilationsCount;

            public final void invoke(TimerTask $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                CompileServiceImpl.access$getState$p(this.this$0).getDelayedShutdownQueued().set(false);
                if (this.$currentCompilationsCount == CompileServiceImpl.access$getCompilationsCounter$p(this.this$0).get()) {
                    CompileServiceImpl.access$getLog$p(this.this$0).fine("Execute delayed shutdown");
                    this.this$0.shutdown();
                } else {
                    CompileServiceImpl.access$getLog$p(this.this$0).info("Cancel delayed shutdown due to new client");
                }
            }
            {
                this.this$0 = compileServiceImpl;
                this.$currentCompilationsCount = n;
                super(1);
            }
        });
    }

    private final boolean shutdownCondition(Function0<Boolean> check, String message) {
        boolean res = check.invoke();
        if (res) {
            this.getLog().info(message);
        }
        return res;
    }

    private final CompileService.CallResult<Integer> doCompile(int sessionId, String[] args, RemoteOutputStream compilerMessagesStreamProxy, RemoteOutputStream serviceOutputStreamProxy, RemoteOperationsTracer operationsTracer, Function3<? super PrintStream, ? super EventManger, ? super Profiler, ? extends ExitCode> body) {
        return CompileServiceImpl.ifAlive$default(this, null, false, new Function0<Integer>(this, operationsTracer, compilerMessagesStreamProxy, serviceOutputStreamProxy, args, body){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ RemoteOperationsTracer $operationsTracer;
            final /* synthetic */ RemoteOutputStream $compilerMessagesStreamProxy;
            final /* synthetic */ RemoteOutputStream $serviceOutputStreamProxy;
            final /* synthetic */ String[] $args;
            final /* synthetic */ Function3 $body;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final int invoke() {
                Unit unit;
                RemoteOperationsTracer remoteOperationsTracer;
                int n;
                Unit unit2;
                RemoteOperationsTracer remoteOperationsTracer2 = this.$operationsTracer;
                if (remoteOperationsTracer2 != null) {
                    remoteOperationsTracer2.before("compile");
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                CompileServiceImpl.access$getCompilationsCounter$p(this.this$0).incrementAndGet();
                Profiler rpcProfiler = this.this$0.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                EventMangerImpl eventManger = new EventMangerImpl();
                PrintStream compilerMessagesStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(this.$compilerMessagesStreamProxy, rpcProfiler), 4096));
                PrintStream serviceOutputStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(this.$serviceOutputStreamProxy, rpcProfiler), 4096));
                try {
                    n = ((Number)CompileServiceImpl.access$checkedCompile(this.this$0, this.$args, serviceOutputStream, rpcProfiler, new Function0<Integer>(this, compilerMessagesStream, eventManger, rpcProfiler){
                        final /* synthetic */ doCompile.1 this$0;
                        final /* synthetic */ PrintStream $compilerMessagesStream;
                        final /* synthetic */ EventMangerImpl $eventManger;
                        final /* synthetic */ Profiler $rpcProfiler;

                        /*
                         * WARNING - void declaration
                         */
                        public final int invoke() {
                            void var1_1;
                            int res = ((ExitCode)((Object)this.this$0.$body.invoke(this.$compilerMessagesStream, this.$eventManger, this.$rpcProfiler))).getCode();
                            CompileServiceImpl.access$set_lastUsedSeconds$p(this.this$0.this$0, CompileServiceImplKt.nowSeconds());
                            return (int)var1_1;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$compilerMessagesStream = printStream;
                            this.$eventManger = eventMangerImpl;
                            this.$rpcProfiler = profiler;
                            super(0);
                        }
                    })).intValue();
                    serviceOutputStream.flush();
                    compilerMessagesStream.flush();
                    eventManger.fireCompilationFinished();
                    remoteOperationsTracer = this.$operationsTracer;
                }
                catch (Throwable throwable) {
                    Unit unit3;
                    serviceOutputStream.flush();
                    compilerMessagesStream.flush();
                    eventManger.fireCompilationFinished();
                    RemoteOperationsTracer remoteOperationsTracer3 = this.$operationsTracer;
                    if (remoteOperationsTracer3 != null) {
                        remoteOperationsTracer3.after("compile");
                        unit3 = Unit.INSTANCE;
                    } else {
                        unit3 = null;
                    }
                    throw throwable;
                }
                if (remoteOperationsTracer != null) {
                    remoteOperationsTracer.after("compile");
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return n;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$operationsTracer = remoteOperationsTracer;
                this.$compilerMessagesStreamProxy = remoteOutputStream;
                this.$serviceOutputStreamProxy = remoteOutputStream2;
                this.$args = stringArray;
                this.$body = function3;
                super(0);
            }
        }, 3);
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, EventManger eventManger, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches() || facade.hasLookupTracker()) {
            builder.register(IncrementalCompilationComponents.class, new RemoteIncrementalCompilationComponentsClient(facade, eventManger, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final <R> R checkedCompile(String[] args, PrintStream serviceOut, Profiler rpcProfiler, Function0<? extends R> body) {
        try {
            long l;
            if (ArraysKt.none((Object[])args)) {
                throw (Throwable)new IllegalArgumentException("Error: empty arguments list.");
            }
            this.getLog().info("Starting compilation with args: " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, 0, null, null, 62));
            Profiler profiler = this.daemonOptions.getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
            R res = profiler.withMeasure(null, body);
            if (this.daemonOptions.getReportPerf()) {
                void withGC$iv;
                boolean bl = false;
                if (withGC$iv != false) {
                    System.gc();
                }
                Runtime rt$iv = Runtime.getRuntime();
                l = rt$iv.totalMemory() - rt$iv.freeMemory();
            } else {
                l = 0L;
            }
            long endMem = l;
            this.getLog().info("Done with result " + String.valueOf(res));
            if (this.daemonOptions.getReportPerf()) {
                void $receiver$iv;
                checkedCompile.1 ms$ = checkedCompile.1.INSTANCE;
                checkedCompile.2 kb$ = checkedCompile.2.INSTANCE;
                PerfCounters pc = profiler.getTotalCounters();
                PerfCounters rpc = rpcProfiler.getTotalCounters();
                Object object = "PERF: Compile on daemon: " + ms$.invoke(pc.getTime()) + " ms; thread: user " + ms$.invoke(pc.getThreadUserTime()) + " ms, sys " + ms$.invoke(pc.getThreadTime() - pc.getThreadUserTime()) + " ms; rpc: " + rpc.getCount() + " calls, " + ms$.invoke(rpc.getTime()) + " ms, thread " + ms$.invoke(rpc.getThreadTime()) + " ms; memory: " + kb$.invoke(endMem) + " kb (" + StringsKt.format("%+d", kb$.invoke(pc.getMemory())) + " kb)";
                String it = (String)$receiver$iv;
                serviceOut.println(it);
                this.getLog().info(it);
                Iterator<Map.Entry<Object, PerfCounters>> iterator2 = MapsKt.iterator(rpcProfiler.getCounters());
                while (iterator2.hasNext()) {
                    String $receiver$iv2;
                    void $receiver$iv3;
                    Object $i$f$let = object = iterator2.next();
                    Object obj = $receiver$iv3.getKey();
                    Object $i$f$component1 = object;
                    PerfCounters counters = (PerfCounters)$receiver$iv2.getValue();
                    $receiver$iv2 = "PERF: rpc by " + obj + ": " + counters.getCount() + " calls, " + ms$.invoke(counters.getTime()) + " ms, thread " + ms$.invoke(counters.getThreadTime()) + " ms";
                    String it2 = $receiver$iv2;
                    serviceOut.println(it2);
                    this.getLog().info(it2);
                }
            }
            return res;
        }
        catch (Exception e) {
            this.getLog().info("Error: " + e);
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void clearJarCache() {
        block6: {
            ZipHandler.clearFileAccessorCache();
            ClassLoader classloader = this.getClass().getClassLoader();
            try {
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
                VirtualFileSystem $receiver$iv = javaCoreApplicationEnvironment != null ? javaCoreApplicationEnvironment.getJarFileSystem() : null;
                VirtualFileSystem jarfs = $receiver$iv;
                Class<?> jarfsClass = classloader.loadClass("com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem");
                Field privateHandlersField = jarfsClass.getDeclaredField("myHandlers");
                privateHandlersField.setAccessible(true);
                Object object = privateHandlersField.get(jarfs);
                if (object != null) {
                    void $receiver$iv2;
                    Object object2 = object;
                    void it = $receiver$iv2;
                    Method clearMethod = privateHandlersField.getType().getMethod("clear", new Class[0]);
                    if (clearMethod != null) {
                        clearMethod.invoke((Object)it, new Object[0]);
                        this.getLog().info("successfully cleared com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem.myHandlers");
                    } else {
                        this.getLog().info("unable to access com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem.myHandlers.clear");
                    }
                    if ((object = Unit.INSTANCE) != null) break block6;
                }
                this.getLog().info("unable to access CoreJarFileSystem.myHandlers (" + privateHandlersField.get(jarfs) + ")");
                object = Unit.INSTANCE;
            }
            catch (Exception e) {
                this.getLog().log(Level.SEVERE, "error clearing CoreJarFileSystem", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAlive(Aliveness minAliveness, boolean ignoreCompilerChanged, Function0<? extends R> body) {
        CompileService.CallResult callResult;
        void $receiver$iv;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
        rl$iv.lock();
        try {
            void ignoreCompilerChanged$iv;
            CompileService.CallResult callResult2;
            void minAliveness$iv;
            void this_$iv;
            CompileServiceImpl compileServiceImpl = this;
            Aliveness aliveness = minAliveness;
            boolean bl = ignoreCompilerChanged;
            if (((CompileServiceImpl)this_$iv).state.getAlive().get() < minAliveness$iv.ordinal()) {
                callResult2 = new CompileService.CallResult.Dying();
            } else if (ignoreCompilerChanged$iv == false && ((CompileServiceImpl)this_$iv).classpathWatcher.isChanged()) {
                ((CompileServiceImpl)this_$iv).getLog().info("Compiler changed, scheduling shutdown");
                TimersKt.schedule(this_$iv.getTimer(), 0L, (Function1<? super TimerTask, Unit>)new Function1<TimerTask, Unit>((CompileServiceImpl)this_$iv){
                    final /* synthetic */ CompileServiceImpl this$0;

                    public final void invoke(TimerTask $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        this.this$0.shutdown();
                    }
                    {
                        this.this$0 = compileServiceImpl;
                        super(1);
                    }
                });
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = new CompileService.CallResult.Good<R>(body.invoke());
                }
                catch (Exception e$iv) {
                    ((CompileServiceImpl)this_$iv).getLog().log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    if (string == null) {
                        string = "unknown";
                    }
                    callResult3 = new CompileService.CallResult.Error(string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            rl$iv.unlock();
        }
        return callResult;
    }

    static /* bridge */ /* synthetic */ CompileService.CallResult ifAlive$default(CompileServiceImpl compileServiceImpl, Aliveness aliveness, boolean bl, Function0 function0, int n) {
        if ((n & 1) != 0) {
            aliveness = Aliveness.Alive;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return compileServiceImpl.ifAlive(aliveness, bl, function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompileService.CallResult ifAlive_Nothing(Aliveness minAliveness, boolean ignoreCompilerChanged, Function0<Unit> body) {
        CompileService.CallResult callResult;
        void $receiver$iv;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
        rl$iv.lock();
        try {
            void ignoreCompilerChanged$iv;
            CompileService.CallResult callResult2;
            void minAliveness$iv;
            void this_$iv;
            CompileServiceImpl compileServiceImpl = this;
            Aliveness aliveness = minAliveness;
            boolean bl = ignoreCompilerChanged;
            if (((CompileServiceImpl)this_$iv).state.getAlive().get() < minAliveness$iv.ordinal()) {
                callResult2 = new CompileService.CallResult.Dying();
            } else if (ignoreCompilerChanged$iv == false && ((CompileServiceImpl)this_$iv).classpathWatcher.isChanged()) {
                ((CompileServiceImpl)this_$iv).getLog().info("Compiler changed, scheduling shutdown");
                TimersKt.schedule(this_$iv.getTimer(), 0L, (Function1<? super TimerTask, Unit>)new /* invalid duplicate definition of identical inner class */);
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    body.invoke();
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Exception e$iv) {
                    ((CompileServiceImpl)this_$iv).getLog().log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    if (string == null) {
                        string = "unknown";
                    }
                    callResult3 = new CompileService.CallResult.Error(string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            rl$iv.unlock();
        }
        return callResult;
    }

    static /* bridge */ /* synthetic */ CompileService.CallResult ifAlive_Nothing$default(CompileServiceImpl compileServiceImpl, Aliveness aliveness, boolean bl, Function0 function0, int n) {
        if ((n & 1) != 0) {
            aliveness = Aliveness.Alive;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return compileServiceImpl.ifAlive_Nothing(aliveness, bl, function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive(Aliveness minAliveness, boolean ignoreCompilerChanged, Function0<? extends R> body) {
        int index$iv$iv;
        CompileService.CallResult callResult;
        int it$iv;
        void $receiver$iv;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
        int readCount$iv = $receiver$iv.getWriteHoldCount() == 0 ? $receiver$iv.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount$iv - 1;
        if (n <= n2) {
            void index$iv$iv2;
            do {
                it$iv = ++index$iv$iv2;
                rl$iv.unlock();
            } while (index$iv$iv2 != n2);
        }
        ReentrantReadWriteLock.WriteLock wl$iv = $receiver$iv.writeLock();
        wl$iv.lock();
        try {
            void ignoreCompilerChanged$iv;
            CompileService.CallResult callResult2;
            void minAliveness$iv;
            void this_$iv;
            CompileServiceImpl compileServiceImpl = this;
            Aliveness aliveness = minAliveness;
            boolean bl = ignoreCompilerChanged;
            if (((CompileServiceImpl)this_$iv).state.getAlive().get() < minAliveness$iv.ordinal()) {
                callResult2 = new CompileService.CallResult.Dying();
            } else if (ignoreCompilerChanged$iv == false && ((CompileServiceImpl)this_$iv).classpathWatcher.isChanged()) {
                ((CompileServiceImpl)this_$iv).getLog().info("Compiler changed, scheduling shutdown");
                TimersKt.schedule(this_$iv.getTimer(), 0L, (Function1<? super TimerTask, Unit>)new /* invalid duplicate definition of identical inner class */);
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = new CompileService.CallResult.Good<R>(body.invoke());
                }
                catch (Exception e$iv) {
                    ((CompileServiceImpl)this_$iv).getLog().log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    if (string == null) {
                        string = "unknown";
                    }
                    callResult3 = new CompileService.CallResult.Error(string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        catch (Throwable throwable) {
            index$iv$iv = 0;
            int n3 = readCount$iv - 1;
            if (index$iv$iv <= n3) {
                do {
                    int it$iv2 = ++index$iv$iv;
                    rl$iv.lock();
                } while (index$iv$iv != n3);
            }
            wl$iv.unlock();
            throw throwable;
        }
        it$iv = 0;
        int n4 = readCount$iv - 1;
        if (it$iv <= n4) {
            do {
                int it$iv3 = ++index$iv$iv;
                rl$iv.lock();
            } while (index$iv$iv != n4);
        }
        wl$iv.unlock();
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive_Nothing(Aliveness minAliveness, boolean ignoreCompilerChanged, Function0<Unit> body) {
        int index$iv$iv;
        CompileService.CallResult callResult;
        int it$iv;
        void $receiver$iv;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
        int readCount$iv = $receiver$iv.getWriteHoldCount() == 0 ? $receiver$iv.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount$iv - 1;
        if (n <= n2) {
            void index$iv$iv2;
            do {
                it$iv = ++index$iv$iv2;
                rl$iv.unlock();
            } while (index$iv$iv2 != n2);
        }
        ReentrantReadWriteLock.WriteLock wl$iv = $receiver$iv.writeLock();
        wl$iv.lock();
        try {
            void ignoreCompilerChanged$iv;
            CompileService.CallResult callResult2;
            void minAliveness$iv;
            void this_$iv;
            CompileServiceImpl compileServiceImpl = this;
            Aliveness aliveness = minAliveness;
            boolean bl = ignoreCompilerChanged;
            if (((CompileServiceImpl)this_$iv).state.getAlive().get() < minAliveness$iv.ordinal()) {
                callResult2 = new CompileService.CallResult.Dying();
            } else if (ignoreCompilerChanged$iv == false && ((CompileServiceImpl)this_$iv).classpathWatcher.isChanged()) {
                ((CompileServiceImpl)this_$iv).getLog().info("Compiler changed, scheduling shutdown");
                TimersKt.schedule(this_$iv.getTimer(), 0L, (Function1<? super TimerTask, Unit>)new /* invalid duplicate definition of identical inner class */);
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    body.invoke();
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Exception e$iv) {
                    ((CompileServiceImpl)this_$iv).getLog().log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    if (string == null) {
                        string = "unknown";
                    }
                    callResult3 = new CompileService.CallResult.Error(string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        catch (Throwable throwable) {
            index$iv$iv = 0;
            int n3 = readCount$iv - 1;
            if (index$iv$iv <= n3) {
                do {
                    int it$iv2 = ++index$iv$iv;
                    rl$iv.lock();
                } while (index$iv$iv != n3);
            }
            wl$iv.unlock();
            throw throwable;
        }
        it$iv = 0;
        int n4 = readCount$iv - 1;
        if (it$iv <= n4) {
            do {
                int it$iv3 = ++index$iv$iv;
                rl$iv.lock();
            } while (index$iv$iv != n4);
        }
        wl$iv.unlock();
        return callResult;
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final CompilerId getCompilerId() {
        return this.compilerId;
    }

    @NotNull
    public final DaemonOptions getDaemonOptions() {
        return this.daemonOptions;
    }

    @NotNull
    public final DaemonJVMOptions getDaemonJVMOptions() {
        return this.daemonJVMOptions;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final Timer getTimer() {
        return this.timer;
    }

    @NotNull
    public final Function0<Unit> getOnShutdown() {
        return this.onShutdown;
    }

    /*
     * WARNING - void declaration
     */
    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions, @NotNull DaemonJVMOptions daemonJVMOptions, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        List list;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        File file;
        Intrinsics.checkParameterIsNotNull(registry, "registry");
        Intrinsics.checkParameterIsNotNull(compiler, "compiler");
        Intrinsics.checkParameterIsNotNull(compilerId, "compilerId");
        Intrinsics.checkParameterIsNotNull(daemonOptions, "daemonOptions");
        Intrinsics.checkParameterIsNotNull(daemonJVMOptions, "daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull(timer, "timer");
        Intrinsics.checkParameterIsNotNull(onShutdown, "onShutdown");
        this.registry = registry;
        this.compiler = compiler;
        this.compilerId = compilerId;
        this.daemonOptions = daemonOptions;
        this.daemonJVMOptions = daemonJVMOptions;
        this.port = port;
        this.timer = timer;
        this.onShutdown = onShutdown;
        System.setProperty(PropertiesKt.getKOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY(), "true");
        this.sessionsIdCounter = new AtomicInteger(0);
        this.compilationsCounter = new AtomicInteger(0);
        this.internalRng = new Random();
        this.classpathWatcher = new LazyClasspathWatcher(this.compilerId.getCompilerClasspath(), 0L, 0L, 6, null);
        this.state = new Object(){
            @NotNull
            private final Set<ClientOrSessionProxy> clientProxies;
            @NotNull
            private final Map<Integer, ClientOrSessionProxy> sessions;
            @NotNull
            private final AtomicBoolean delayedShutdownQueued;
            @NotNull
            private AtomicInteger alive;

            @NotNull
            public final Set<ClientOrSessionProxy> getClientProxies() {
                return this.clientProxies;
            }

            @NotNull
            public final Map<Integer, ClientOrSessionProxy> getSessions() {
                return this.sessions;
            }

            @NotNull
            public final AtomicBoolean getDelayedShutdownQueued() {
                return this.delayedShutdownQueued;
            }

            @NotNull
            public final AtomicInteger getAlive() {
                return this.alive;
            }

            public final void setAlive(@NotNull AtomicInteger atomicInteger) {
                Intrinsics.checkParameterIsNotNull(atomicInteger, "<set-?>");
                this.alive = atomicInteger;
            }
            {
                this.clientProxies = SetsKt.hashSetOf(new ClientOrSessionProxy[0]);
                this.sessions = MapsKt.hashMapOf(new Pair[0]);
                this.delayedShutdownQueued = new AtomicBoolean(false);
                this.alive = new AtomicInteger(Aliveness.Alive.ordinal());
            }
        };
        this._lastUsedSeconds = CompileServiceImplKt.nowSeconds();
        this.log$delegate = LazyKt.lazy(log.2.INSTANCE);
        this.rwlock = new ReentrantReadWriteLock();
        File runFileDir = new File(DaemonParamsKt.getRunFilesPathOrDefault(this.daemonOptions));
        runFileDir.mkdirs();
        Iterable iterable = this.compilerId.getCompilerClasspath();
        String string = StringsKt.format("%tFT%<tH-%<tM-%<tS.%<tLZ", Calendar.getInstance(TimeZone.getTimeZone("Z")));
        File file2 = runFileDir;
        File file3 = file;
        File file4 = file;
        CompileServiceImpl compileServiceImpl = this;
        void var11_18 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            list = destination$iv$iv;
            String string3 = new File((String)it).getAbsolutePath();
            list.add(string3);
        }
        list = (List)destination$iv$iv;
        file3(file2, ClientUtilsKt.makeRunFilenameString$default(string, DaemonParamsKt.toHexString(DaemonParamsKt.distinctStringsDigest(list)), String.valueOf(this.port), null, 8));
        compileServiceImpl.runFile = file4;
        try {
            if (!this.runFile.createNewFile()) {
                throw (Throwable)new Exception("createNewFile returned false");
            }
        }
        catch (Exception e) {
            throw (Throwable)new IllegalStateException("Unable to create run file '" + this.runFile.getAbsolutePath() + "'", e);
        }
        this.runFile.deleteOnExit();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException e) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, this.port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        if (remote == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompileService");
        }
        CompileService stub = (CompileService)remote;
        this.registry.rebind(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME(), stub);
        TimersKt.schedule(this.timer, 0L, (Function1<? super TimerTask, Unit>)new Function1<TimerTask, Unit>(){

            @Override
            public final void invoke(TimerTask $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.initiateElections();
            }
        });
        TimersKt.schedule(this.timer, KotlinCompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS(), KotlinCompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS(), (Function1<? super TimerTask, Unit>)new Function1<TimerTask, Unit>(){

            @Override
            public final void invoke(TimerTask $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                try {
                    this.periodicAndAfterSessionCheck();
                }
                catch (Exception e) {
                    System.err.println("Exception in timer thread: " + e.getMessage());
                    Throwable throwable = e;
                    PrintStream printStream = System.err;
                    Intrinsics.checkExpressionValueIsNotNull(printStream, "System.err");
                    ExceptionsKt.printStackTrace(throwable, printStream);
                    this.getLog().log(Level.SEVERE, "Exception in timer thread", e);
                }
            }
        });
    }

    static {
        $$delegatedProperties = new KProperty[]{CompileServiceImpl$log$1.INSTANCE};
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getSessionsIdCounter$p(CompileServiceImpl $this) {
        return $this.sessionsIdCounter;
    }

    @NotNull
    public static final /* synthetic */ Random access$getInternalRng$p(CompileServiceImpl $this) {
        return $this.internalRng;
    }

    public static final /* synthetic */ void access$clearJarCache(CompileServiceImpl $this) {
        $this.clearJarCache();
    }

    public static final /* synthetic */ void access$shutdownImpl(CompileServiceImpl $this) {
        $this.shutdownImpl();
    }

    @NotNull
    public static final /* synthetic */ CompileService.CallResult access$ifAliveExclusive(CompileServiceImpl $this, @NotNull Aliveness minAliveness, boolean ignoreCompilerChanged, @NotNull Function0 body) {
        return $this.ifAliveExclusive(minAliveness, ignoreCompilerChanged, body);
    }

    @NotNull
    public static final /* synthetic */ Services access$createCompileServices(CompileServiceImpl $this, @NotNull CompilerCallbackServicesFacade facade, @NotNull EventManger eventManger, @NotNull Profiler rpcProfiler) {
        return $this.createCompileServices(facade, eventManger, rpcProfiler);
    }

    public static final /* synthetic */ boolean access$shutdownCondition(CompileServiceImpl $this, @NotNull Function0 check, @NotNull String message) {
        return $this.shutdownCondition(check, message);
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getCompilationsCounter$p(CompileServiceImpl $this) {
        return $this.compilationsCounter;
    }

    public static final /* synthetic */ void access$shutdownWithDelay(CompileServiceImpl $this) {
        $this.shutdownWithDelay();
    }

    @NotNull
    public static final /* synthetic */ File access$getRunFile$p(CompileServiceImpl $this) {
        return $this.runFile;
    }

    public static final /* synthetic */ void access$setRunFile$p(CompileServiceImpl $this, @NotNull File file) {
        $this.runFile = file;
    }

    public static final /* synthetic */ Object access$checkedCompile(CompileServiceImpl $this, @NotNull String[] args, @NotNull PrintStream serviceOut, @NotNull Profiler rpcProfiler, @NotNull Function0 body) {
        return $this.checkedCompile(args, serviceOut, rpcProfiler, body);
    }

    public static final /* synthetic */ long access$get_lastUsedSeconds$p(CompileServiceImpl $this) {
        return $this._lastUsedSeconds;
    }

    public static final /* synthetic */ void access$set_lastUsedSeconds$p(CompileServiceImpl $this, long l) {
        $this._lastUsedSeconds = l;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tAAA\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0006\u0003!%Q!\u0001\u0003\u0003\t\u0005a\u0001!G\u0001\u0019\u0002\u0005>\u0011\u0002\u0002\u0005\u0002\u001b\ta\t\u0001g\u0001R\u0007\u0005A!!K\u0006\u0005\u0007\"A\u0011!\u0004\u0002\r\u0002a\r\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0001\u0005\u0004S)!1\t\u0003E\u0004\u001b\u0005AB\u0001H\u0012R\u0007\ri!\u0001b\u0002\t\n%RAa\u0011\u0005\t\u000b5\t\u00014B)\u0004\t\u0015\u0001QB\u0001\u0003\u0007\u0011\u001bI#\u0002B\"\t\u0011\u001di\u0011\u0001g\u0003\u001dGE\u001b1!\u0004\u0002\u0005\u0010!5\u0001"}, strings={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl$ClientOrSessionProxy;", "", "aliveFlagPath", "", "(Ljava/lang/String;)V", "getAliveFlagPath", "()Ljava/lang/String;", "isAlive", "", "()Z", "registered", "", "getRegistered", "()J", "secondsSinceRegistered", "getSecondsSinceRegistered"}, moduleName="kotlin-compiler")
    private static final class ClientOrSessionProxy {
        private final long registered;
        @Nullable
        private final String aliveFlagPath;

        public final long getRegistered() {
            return this.registered;
        }

        public final long getSecondsSinceRegistered() {
            return CompileServiceImplKt.nowSeconds() - this.registered;
        }

        public final boolean isAlive() {
            boolean bl;
            String string = this.aliveFlagPath;
            if (string != null) {
                String $receiver$iv = string;
                String it = $receiver$iv;
                bl = new File(it).exists();
            } else {
                bl = true;
            }
            return bl;
        }

        @Nullable
        public final String getAliveFlagPath() {
            return this.aliveFlagPath;
        }

        public ClientOrSessionProxy(@Nullable String aliveFlagPath) {
            this.aliveFlagPath = aliveFlagPath;
            this.registered = CompileServiceImplKt.nowSeconds();
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001\u0002\u0002\u0005\u0007\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t\u001c1\u0001B\u0003k\u0005!\u0019!N\u0001\u0005\u0005U\nAQ\u0001"}, strings={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl$Aliveness;", "", "(Ljava/lang/String;I)V", "Dying", "LastSession", "Alive"}, moduleName="kotlin-compiler")
    public static final class Aliveness
    extends Enum<Aliveness> {
        public static final /* enum */ Aliveness Dying;
        public static final /* enum */ Aliveness LastSession;
        public static final /* enum */ Aliveness Alive;
        private static final /* synthetic */ Aliveness[] $VALUES;

        static {
            Aliveness[] alivenessArray = new Aliveness[3];
            Aliveness[] alivenessArray2 = alivenessArray;
            alivenessArray[0] = Dying = new Aliveness();
            alivenessArray[1] = LastSession = new Aliveness();
            alivenessArray[2] = Alive = new Aliveness();
            $VALUES = alivenessArray;
        }

        public static Aliveness[] values() {
            return (Aliveness[])$VALUES.clone();
        }

        public static Aliveness valueOf(String string) {
            return Enum.valueOf(Aliveness.class, string);
        }
    }
}

