/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.PerfCounters;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"'\u0015\u0001Q!\u0001E\u0005\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!9!\u0004\u0006\u0005\bBA\u0001!D\u0001\u0019\u0002e\u0019\u0001\"A\u0007\u00021\u0007!6AAG\u0017\t\r\u0003\u0002RA\u0007\u0002I\r\t\"\u0001\u0002\u0001\t\u0007e\u0019\u0001rA\u0007\u00021\u0011Ib\u0001#\u0003\u000e\t%\u0011\u0011\"\u0001\u0013\u00041\u0015\t6!\u0001E\u0006)\u000e\u0011QR\u0007\u0003D!!\u0015Q\"\u0001\u0013\u0004#\t!\u0001\u0001C\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rAa!D\u0001\u0019\u000ee1\u0001\u0012B\u0007\u0005\u0013\tI\u0011\u0001J\u0002\u0019\u000bE\u001b\u0011\u0001C\u0004U\u0007\ti)\u0004B\"\u0011\u0011\u001fi\u0011\u0001J\u0002\u0012\u0005\u0011\u0001\u0001bA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!\tQ\"\u0001M\u00023\u0019AI!\u0004\u0003\n\u0005%\tAe\u0001\r\u0006#\u000e\t\u0001\u0002\u0003+\u0004\u00055}Ba\u0011\t\t\u00105\tAeA\t\u0003\t\u0001A1!G\u0002\t\b5\t\u0001\u0004B\r\u0005\t\u0005A\u0011!D\u0001\u0019\u0004e\u0019\u0001BB\u0007\u00021\u001bIb\u0001#\u0003\u000e\t%\u0011\u0011\"\u0001\u0013\u00041\u0015\t6!\u0001E\t)\u000e\u0011QR\u0006\u0003D!!IQ\"\u0001\u0013\u0004#\t!\u0001\u0001C\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\u0019AI!\u0004\u0003\n\u0005%\tAe\u0001\r\u0006#\u000e\t\u00012\u0002+\u0004\u00055AAq\u0011\t\t\u00145\t\u0001\u0014A\u000b\u00021\u001b!6AA\u0007\t\t\u000f\u0003\u0002BC\u0007\u00021\u0003)\u0012\u0001'\u0004U\u0007\t\u0001"}, strings={"usedMemory", "", "withGC", "", "PerfUtilsKt", "withMeasureWallAndThreadTimes", "R", "perfCounters", "Lorg/jetbrains/kotlin/daemon/common/PerfCounters;", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/daemon/common/PerfCounters;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "threadMXBean", "Ljava/lang/management/ThreadMXBean;", "(Lorg/jetbrains/kotlin/daemon/common/PerfCounters;Ljava/lang/management/ThreadMXBean;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withMeasureWallAndThreadTimesAndMemory", "(Lorg/jetbrains/kotlin/daemon/common/PerfCounters;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlin/daemon/common/PerfCounters;ZLjava/lang/management/ThreadMXBean;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withMeasureWallTime", "threadCpuTime", "threadUserTime"}, moduleName="kotlin-compiler")
public final class PerfUtilsKt {
    public static final long threadCpuTime(ThreadMXBean $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.isCurrentThreadCpuTimeSupported() ? $receiver.getCurrentThreadCpuTime() : 0L;
    }

    public static final long threadUserTime(ThreadMXBean $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.isCurrentThreadCpuTimeSupported() ? $receiver.getCurrentThreadUserTime() : 0L;
    }

    public static final long usedMemory(boolean withGC) {
        if (withGC) {
            System.gc();
        }
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public static final <R> R withMeasureWallTime(@NotNull PerfCounters perfCounters, @NotNull Function0<? extends R> body) {
        Intrinsics.checkParameterIsNotNull(perfCounters, "perfCounters");
        Intrinsics.checkParameterIsNotNull(body, "body");
        long startTime = System.nanoTime();
        R res = body.invoke();
        PerfCounters.DefaultImpls.addMeasurement$default(perfCounters, System.nanoTime() - startTime, 0L, 0L, 0L, 14);
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public static final <R> R withMeasureWallAndThreadTimes(@NotNull PerfCounters perfCounters, @NotNull ThreadMXBean threadMXBean, @NotNull Function0<? extends R> body) {
        ThreadMXBean $receiver$iv;
        void $receiver$iv2;
        void $receiver$iv3;
        Intrinsics.checkParameterIsNotNull(perfCounters, "perfCounters");
        Intrinsics.checkParameterIsNotNull(threadMXBean, "threadMXBean");
        Intrinsics.checkParameterIsNotNull(body, "body");
        long startTime = System.nanoTime();
        ThreadMXBean threadMXBean2 = threadMXBean;
        long startThreadTime = $receiver$iv3.isCurrentThreadCpuTimeSupported() ? $receiver$iv3.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean threadMXBean3 = threadMXBean;
        long startThreadUserTime = $receiver$iv2.isCurrentThreadCpuTimeSupported() ? $receiver$iv2.getCurrentThreadUserTime() : 0L;
        R res = body.invoke();
        ThreadMXBean $i$f$threadUserTime = threadMXBean;
        long l = System.nanoTime() - startTime;
        PerfCounters perfCounters2 = perfCounters;
        long l2 = $receiver$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv.getCurrentThreadCpuTime() : 0L;
        $receiver$iv = threadMXBean;
        long l3 = $receiver$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv.getCurrentThreadUserTime() : 0L;
        PerfCounters.DefaultImpls.addMeasurement$default(perfCounters2, l, l2 -= startThreadTime, l3 - startThreadUserTime, 0L, 8);
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public static final <R> R withMeasureWallAndThreadTimes(@NotNull PerfCounters perfCounters, @NotNull Function0<? extends R> body) {
        ThreadMXBean $receiver$iv$iv;
        void $receiver$iv$iv2;
        void $receiver$iv$iv3;
        Intrinsics.checkParameterIsNotNull(perfCounters, "perfCounters");
        Intrinsics.checkParameterIsNotNull(body, "body");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkExpressionValueIsNotNull(threadMXBean, "ManagementFactory.getThreadMXBean()");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        long startTime$iv = System.nanoTime();
        ThreadMXBean threadMXBean2 = threadMXBean$iv;
        long startThreadTime$iv = $receiver$iv$iv3.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv3.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean threadMXBean3 = threadMXBean$iv;
        long startThreadUserTime$iv = $receiver$iv$iv2.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv2.getCurrentThreadUserTime() : 0L;
        R res$iv = body.invoke();
        ThreadMXBean $i$f$threadUserTime = threadMXBean$iv;
        long l = System.nanoTime() - startTime$iv;
        PerfCounters perfCounters2 = perfCounters;
        long l2 = $receiver$iv$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv.getCurrentThreadCpuTime() : 0L;
        $receiver$iv$iv = threadMXBean$iv;
        long l3 = $receiver$iv$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv.getCurrentThreadUserTime() : 0L;
        PerfCounters.DefaultImpls.addMeasurement$default(perfCounters2, l, l2 -= startThreadTime$iv, l3 - startThreadUserTime$iv, 0L, 8);
        return res$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final <R> R withMeasureWallAndThreadTimesAndMemory(@NotNull PerfCounters perfCounters, boolean withGC, @NotNull ThreadMXBean threadMXBean, @NotNull Function0<? extends R> body) {
        ThreadMXBean $receiver$iv;
        void $receiver$iv2;
        void $receiver$iv3;
        Intrinsics.checkParameterIsNotNull(perfCounters, "perfCounters");
        Intrinsics.checkParameterIsNotNull(threadMXBean, "threadMXBean");
        Intrinsics.checkParameterIsNotNull(body, "body");
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        long startMem = rt$iv.totalMemory() - rt$iv.freeMemory();
        long startTime = System.nanoTime();
        ThreadMXBean threadMXBean2 = threadMXBean;
        long startThreadTime = $receiver$iv3.isCurrentThreadCpuTimeSupported() ? $receiver$iv3.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean threadMXBean3 = threadMXBean;
        long startThreadUserTime = $receiver$iv2.isCurrentThreadCpuTimeSupported() ? $receiver$iv2.getCurrentThreadUserTime() : 0L;
        R res = body.invoke();
        ThreadMXBean $i$f$threadUserTime = threadMXBean;
        long l = System.nanoTime() - startTime;
        PerfCounters perfCounters2 = perfCounters;
        long l2 = $receiver$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv.getCurrentThreadCpuTime() : 0L;
        $receiver$iv = threadMXBean;
        l2 -= startThreadTime;
        long l3 = $receiver$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv.getCurrentThreadUserTime() : 0L;
        l3 -= startThreadUserTime;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv2 = Runtime.getRuntime();
        long l4 = rt$iv2.totalMemory() - rt$iv2.freeMemory();
        perfCounters2.addMeasurement(l, l2, l3, l4 - startMem);
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public static /* bridge */ /* synthetic */ Object withMeasureWallAndThreadTimesAndMemory$default(PerfCounters perfCounters, boolean bl, ThreadMXBean threadMXBean, Function0 function0, int n) {
        ThreadMXBean $receiver$iv$iv;
        void $receiver$iv$iv2;
        void $receiver$iv$iv3;
        if ((n & 2) != 0) {
            bl = false;
        }
        if (bl) {
            System.gc();
        }
        Runtime rt$iv$iv = Runtime.getRuntime();
        long startMem$iv = rt$iv$iv.totalMemory() - rt$iv$iv.freeMemory();
        long startTime$iv = System.nanoTime();
        ThreadMXBean threadMXBean2 = threadMXBean;
        long startThreadTime$iv = $receiver$iv$iv3.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv3.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean threadMXBean3 = threadMXBean;
        long startThreadUserTime$iv = $receiver$iv$iv2.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv2.getCurrentThreadUserTime() : 0L;
        Object res$iv = function0.invoke();
        ThreadMXBean $i$f$threadUserTime = threadMXBean;
        long l = System.nanoTime() - startTime$iv;
        PerfCounters perfCounters2 = perfCounters;
        long l2 = $receiver$iv$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv.getCurrentThreadCpuTime() : 0L;
        $receiver$iv$iv = threadMXBean;
        l2 -= startThreadTime$iv;
        long l3 = $receiver$iv$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv.getCurrentThreadUserTime() : 0L;
        l3 -= startThreadUserTime$iv;
        if (bl) {
            System.gc();
        }
        Runtime rt$iv$iv2 = Runtime.getRuntime();
        long l4 = rt$iv$iv2.totalMemory() - rt$iv$iv2.freeMemory();
        perfCounters2.addMeasurement(l, l2, l3, l4 - startMem$iv);
        return res$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final <R> R withMeasureWallAndThreadTimesAndMemory(@NotNull PerfCounters perfCounters, boolean withGC, @NotNull Function0<? extends R> body) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        void $receiver$iv$iv3;
        void threadMXBean$iv;
        Intrinsics.checkParameterIsNotNull(perfCounters, "perfCounters");
        Intrinsics.checkParameterIsNotNull(body, "body");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkExpressionValueIsNotNull(threadMXBean, "ManagementFactory.getThreadMXBean()");
        ThreadMXBean threadMXBean2 = threadMXBean;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv$iv = Runtime.getRuntime();
        long startMem$iv = rt$iv$iv.totalMemory() - rt$iv$iv.freeMemory();
        long startTime$iv = System.nanoTime();
        void var10_7 = threadMXBean$iv;
        long startThreadTime$iv = $receiver$iv$iv3.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv3.getCurrentThreadCpuTime() : 0L;
        void var13_9 = threadMXBean$iv;
        long startThreadUserTime$iv = $receiver$iv$iv2.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv2.getCurrentThreadUserTime() : 0L;
        R res$iv = body.invoke();
        void $i$f$threadUserTime = threadMXBean$iv;
        long l = System.nanoTime() - startTime$iv;
        PerfCounters perfCounters2 = perfCounters;
        long l2 = $receiver$iv$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv.getCurrentThreadCpuTime() : 0L;
        $receiver$iv$iv = threadMXBean$iv;
        l2 -= startThreadTime$iv;
        long l3 = $receiver$iv$iv.isCurrentThreadCpuTimeSupported() ? $receiver$iv$iv.getCurrentThreadUserTime() : 0L;
        l3 -= startThreadUserTime$iv;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv$iv2 = Runtime.getRuntime();
        long l4 = rt$iv$iv2.totalMemory() - rt$iv$iv2.freeMemory();
        perfCounters2.addMeasurement(l, l2, l3, l4 - startMem$iv);
        return res$iv;
    }
}

