/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"'\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0001!$\f\t\u00015\t\u0001\u0014A\r\u0004\u0011\u0005i\u0011\u0001g\u0001\u001a\r!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002\u001a\r!\u001dQ\u0002B\u0005\u0003\u0013\u0005AB\u0001'\u0002U\u0007\u0013iI\u0002C\u0003\u000e\u0003a\u0005\u0011d\u0001\u0005\u0002\u001b\u0005A\u001a!G\u0002\t\f5\t\u0001D\u0002+\u0004\n5e\u0001RB\u0007\u00021\u0003I2\u0001C\u0001\u000e\u0003a\r\u0011d\u0001E\u0006\u001b\u0005Ab\u0001VB\u0005"}, strings={"aliasArgumentsIfNeeded", "", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "arguments", "", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "parameters", "Lcom/google/dart/compiler/backend/js/ast/JsParameter;", "NamingUtilsKt", "refreshLabelNames", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "renameLocalNames"}, moduleName="kotlin-compiler")
public final class NamingUtilsKt {
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context, @NotNull List<? extends JsExpression> arguments2, @NotNull List<JsParameter> parameters2) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        boolean value$iv2 = arguments2.size() <= parameters2.size();
        if (!value$iv2) {
            String message$iv = "arguments.size (" + arguments2.size() + ") should be less or equal to parameters.size (" + parameters2.size() + ")";
            throw (Throwable)new IllegalArgumentException(message$iv.toString());
        }
        for (Pair value$iv2 : CollectionsKt.zip((Iterable)arguments2, (Iterable)parameters2)) {
            JsExpression jsExpression;
            JsExpression arg = (JsExpression)value$iv2.component1();
            JsParameter param = (JsParameter)value$iv2.component2();
            JsName paramName = param.getName();
            if (SideEffectUtilsKt.needToAlias(arg)) {
                JsName jsName = paramName;
                Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
                JsName freshName = context.getFreshName(jsName);
                context.newVar(freshName, arg);
                JsExpression jsExpression2 = freshName.makeRef();
                jsExpression = jsExpression2;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "freshName.makeRef()");
            } else {
                jsExpression = arg;
            }
            JsExpression replacement = jsExpression;
            JsName jsName = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
            context.replaceName(jsName, replacement);
        }
        Collection $i$a$1 = arguments2;
        List<JsParameter> list = parameters2;
        int n = $receiver$iv.size();
        $receiver$iv = parameters2;
        int n2 = $receiver$iv.size();
        List<JsParameter> defaultParams = list.subList(n, n2);
        for (JsParameter defaultParam : defaultParams) {
            JsName paramName;
            JsName jsName = paramName = defaultParam.getName();
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
            JsName freshName = context.getFreshName(jsName);
            NamingContext.newVar$default(context, freshName, null, 2);
            JsName jsName2 = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "paramName");
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            context.replaceName(jsName2, jsExpression);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(function, "function");
        for (JsName name : CollectUtilsKt.collectLocalNames(function)) {
            JsName freshName = context.getFreshName(name);
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            context.replaceName(name, jsExpression);
        }
    }

    public static final void refreshLabelNames(@NotNull NamingContext context, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(function, "function");
        JsFunctionScope scope2 = function.getScope();
        if (!(scope2 instanceof JsFunctionScope)) {
            throw (Throwable)((Object)new AssertionError((Object)"JsFunction is expected to have JsFunctionScope"));
        }
        JsFunctionScope jsFunctionScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull(jsFunctionScope, "scope");
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor(context, jsFunctionScope);
        visitor2.accept((JsNode)function.getBody());
        context.applyRenameTo(function);
    }
}

