/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0011\u0001B\u0002A\r\u00021\u0003\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Q\u0005\u0005\u0003\f\u0011\u000bi\u0011\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\u000be\u0019\u00012B\u0007\u00021\u0019)C\u0003B\u0006\t\u000e5\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001G\u0004\u001a\u0007!%Q\"\u0001M\b3\rAY!D\u0001\u0019\re\u0019\u0001\u0002C\u0007\u00021#Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/js/resolve/AbstractNativeAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "requiredAnnotation", "Lorg/jetbrains/kotlin/js/PredefinedAnnotation;", "(Lorg/jetbrains/kotlin/js/PredefinedAnnotation;)V", "additionalCheck", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "check", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;"}, moduleName="kotlin-compiler")
public abstract class AbstractNativeAnnotationsChecker
implements DeclarationChecker {
    private final PredefinedAnnotation requiredAnnotation;

    public void additionalCheck(@NotNull KtNamedFunction declaration, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(this.requiredAnnotation.getFqName());
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        if (!(declaration instanceof KtNamedFunction) || !(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        boolean isMember = !DescriptorUtils.isTopLevelDeclaration(descriptor2) && Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getVisibility(), Visibilities.LOCAL) ^ true;
        boolean isExtension = DescriptorUtils.isExtension((CallableDescriptor)descriptor2);
        if (isMember && (isExtension || !AnnotationsUtils.isNativeObject(descriptor2)) || !isMember && !isExtension) {
            diagnosticHolder.report(ErrorsJs.NATIVE_ANNOTATIONS_ALLOWED_ONLY_ON_MEMBER_OR_EXTENSION_FUN.on((KtElement)((PsiElement)declaration), annotationDescriptor2.getType()));
        }
        this.additionalCheck((KtNamedFunction)declaration, (FunctionDescriptor)descriptor2, diagnosticHolder);
    }

    public AbstractNativeAnnotationsChecker(@NotNull PredefinedAnnotation requiredAnnotation) {
        Intrinsics.checkParameterIsNotNull((Object)requiredAnnotation, "requiredAnnotation");
        this.requiredAnnotation = requiredAnnotation;
    }
}

