/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.BuiltinSpecialProperties;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\t\u00012B\u0003\u0002\t\u0005)\u0011\u0001C\u0004\u0006\u0003\u0011\rQr\u0003\u0005\u0001\u001b\u0011I!!C\u0001\u0019\u0003a\u0005\u0011d\u0001E\u0002\u001b\u0005A\u0012\u0001V\u0002\u0003\u001b'A)!\u0004\u0002\r\u0002a\t\u0011d\u0001\u0005\u0004\u001b\u0005A\u0012\u0001V\u0002\u0003\u001b7A9!\u0004\u0002\r\u0002a\t\u0011d\u0001\u0005\u0004\u001b\u0005A\u0012!G\u0002\t\t5\t\u0001\u0014\u0002+\u0004\u00055MB!\u0001\u0005\u0006\u001b\ta\t\u0001G\u0001\u001a\u0007!\u0019Q\"\u0001\r\u00023\rAY!D\u0001\u0019\re!A!\u0001E\u0007\u001b\u0005AJ!G\u0003\u0005\u0003!9QB\u0001G\u00011\u0019!6AAG\f\u0011\u001fiA!\u0003\u0002\n\u0003a\t\u0001\u0014A\r\u0004\u0011\ri\u0011\u0001G\u0001U\u0007\t\u0001"}, strings={"getPropertyNamesCandidatesByAccessorName", "", "Lorg/jetbrains/kotlin/name/Name;", "name", "PropertiesConventionUtilKt", "propertyNameByGetMethodName", "methodName", "propertyNameBySetMethodName", "withIsPrefix", "", "propertyNameFromAccessorMethodName", "prefix", "", "removePrefix", "addPrefix", "propertyNamesBySetMethodName"}, moduleName="kotlin-compiler")
public final class PropertiesConventionUtilKt {
    @Nullable
    public static final Name propertyNameByGetMethodName(@NotNull Name methodName) {
        Intrinsics.checkParameterIsNotNull(methodName, "methodName");
        Name name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "get", false, null, 12);
        if (name == null) {
            name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "is", false, null, 8);
        }
        return name;
    }

    @Nullable
    public static final Name propertyNameBySetMethodName(@NotNull Name methodName, boolean withIsPrefix) {
        Intrinsics.checkParameterIsNotNull(methodName, "methodName");
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "set", false, withIsPrefix ? "is" : (String)null, 4);
    }

    @NotNull
    public static final List<Name> propertyNamesBySetMethodName(@NotNull Name methodName) {
        Intrinsics.checkParameterIsNotNull(methodName, "methodName");
        return kotlin.collections.CollectionsKt.filterNotNull((Iterable)kotlin.collections.CollectionsKt.listOf(PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, false), PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, true)));
    }

    private static final Name propertyNameFromAccessorMethodName(Name methodName, String prefix, boolean removePrefix, String addPrefix) {
        if (methodName.isSpecial()) {
            return null;
        }
        String identifier = methodName.getIdentifier();
        if (!StringsKt.startsWith$default(identifier, prefix, false, 2)) {
            return null;
        }
        if (kotlin.collections.CollectionsKt.length(identifier) == kotlin.collections.CollectionsKt.length(prefix)) {
            return null;
        }
        char c = identifier.charAt(kotlin.collections.CollectionsKt.length(prefix));
        boolean bl = true;
        if (c < 'a') {
            bl = false;
        }
        boolean bl2 = true;
        if (c > 'z') {
            bl2 = false;
        }
        if (bl & bl2) {
            return null;
        }
        if (addPrefix != null) {
            PreconditionsKt.assert(removePrefix);
            return Name.identifier(addPrefix + StringsKt.removePrefix(identifier, (CharSequence)prefix));
        }
        if (!removePrefix) {
            return methodName;
        }
        String name = CapitalizeDecapitalizeKt.decapitalizeSmart(StringsKt.removePrefix(identifier, (CharSequence)prefix), true);
        if (!Name.isValidIdentifier(name)) {
            return null;
        }
        return Name.identifier(name);
    }

    static /* bridge */ /* synthetic */ Name propertyNameFromAccessorMethodName$default(Name name, String string, boolean bl, String string2, int n) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName(name, string, bl, string2);
    }

    @NotNull
    public static final List<Name> getPropertyNamesCandidatesByAccessorName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String nameAsString = name.asString();
        if (JvmAbi.isGetterName(nameAsString)) {
            return CollectionsKt.singletonOrEmptyList(PropertiesConventionUtilKt.propertyNameByGetMethodName(name));
        }
        if (JvmAbi.isSetterName(nameAsString)) {
            return PropertiesConventionUtilKt.propertyNamesBySetMethodName(name);
        }
        return BuiltinSpecialProperties.INSTANCE.getPropertyNameCandidatesBySpecialGetterName(name);
    }
}

