/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementType;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinParser;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KotlinParserDefinition
implements ParserDefinition {
    public static final String STD_SCRIPT_SUFFIX = "kts";
    public static final String STD_SCRIPT_EXT = ".kts";

    @NotNull
    public static KotlinParserDefinition getInstance() {
        KotlinParserDefinition kotlinParserDefinition = (KotlinParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(KotlinLanguage.INSTANCE);
        if (kotlinParserDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "getInstance"));
        }
        return kotlinParserDefinition;
    }

    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        KotlinLexer kotlinLexer = new KotlinLexer();
        if (kotlinLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "createLexer"));
        }
        return kotlinLexer;
    }

    @Override
    public PsiParser createParser(Project project) {
        return new KotlinParser(project);
    }

    @Override
    public IFileElementType getFileNodeType() {
        return KtStubElementTypes.FILE;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = KtTokens.WHITESPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = KtTokens.COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = KtTokens.STRINGS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode astNode) {
        IElementType elementType = astNode.getElementType();
        if (elementType instanceof KtStubElementType) {
            Object PsiT = ((KtStubElementType)elementType).createPsiFromAst(astNode);
            if (PsiT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "createElement"));
            }
            return PsiT;
        }
        if (elementType == KtNodeTypes.TYPE_CODE_FRAGMENT || elementType == KtNodeTypes.EXPRESSION_CODE_FRAGMENT || elementType == KtNodeTypes.BLOCK_CODE_FRAGMENT) {
            ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(astNode);
            if (aSTWrapperPsiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "createElement"));
            }
            return aSTWrapperPsiElement;
        }
        if (elementType instanceof KDocElementType) {
            PsiElement psiElement2 = ((KDocElementType)elementType).createPsi(astNode);
            if (psiElement2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "createElement"));
            }
            return psiElement2;
        }
        if (elementType == KDocTokens.MARKDOWN_LINK) {
            KDocLink kDocLink = new KDocLink(astNode);
            if (kDocLink == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "createElement"));
            }
            return kDocLink;
        }
        KtElement ktElement = ((KtNodeType)elementType).createPsi(astNode);
        if (ktElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinParserDefinition", "createElement"));
        }
        return ktElement;
    }

    @Override
    public PsiFile createFile(FileViewProvider fileViewProvider) {
        return new KtFile(fileViewProvider, false);
    }

    @Override
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode astNode, ASTNode astNode1) {
        IElementType rightTokenType = astNode1.getElementType();
        if (rightTokenType == KtTokens.GET_KEYWORD || rightTokenType == KtTokens.SET_KEYWORD) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

