/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.platform;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JvmBuiltIns;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public class JavaToKotlinClassMap
implements PlatformToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE = new JavaToKotlinClassMap();
    private final Map<FqName, ClassDescriptor> javaToKotlin = new HashMap<FqName, ClassDescriptor>();
    private final Map<FqNameUnsafe, ClassId> kotlinToJava = new HashMap<FqNameUnsafe, ClassId>();
    private final Map<ClassDescriptor, ClassDescriptor> mutableToReadOnly = new HashMap<ClassDescriptor, ClassDescriptor>();
    private final Map<ClassDescriptor, ClassDescriptor> readOnlyToMutable = new HashMap<ClassDescriptor, ClassDescriptor>();

    private JavaToKotlinClassMap() {
        KotlinBuiltIns builtIns = JvmBuiltIns.getInstance();
        this.add(Object.class, builtIns.getAny());
        this.add(String.class, builtIns.getString());
        this.add(CharSequence.class, builtIns.getCharSequence());
        this.add(Throwable.class, builtIns.getThrowable());
        this.add(Cloneable.class, builtIns.getCloneable());
        this.add(Number.class, builtIns.getNumber());
        this.add(Comparable.class, builtIns.getComparable());
        this.add(Enum.class, builtIns.getEnum());
        this.add(Annotation.class, builtIns.getAnnotation());
        this.add(Iterable.class, builtIns.getIterable(), builtIns.getMutableIterable());
        this.add(Iterator.class, builtIns.getIterator(), builtIns.getMutableIterator());
        this.add(Collection.class, builtIns.getCollection(), builtIns.getMutableCollection());
        this.add(List.class, builtIns.getList(), builtIns.getMutableList());
        this.add(Set.class, builtIns.getSet(), builtIns.getMutableSet());
        this.add(Map.class, builtIns.getMap(), builtIns.getMutableMap());
        this.add(Map.Entry.class, builtIns.getMapEntry(), builtIns.getMutableMapEntry());
        this.add(ListIterator.class, builtIns.getListIterator(), builtIns.getMutableListIterator());
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            this.add(ClassId.topLevel(jvmType.getWrapperFqName()), builtIns.getPrimitiveClassDescriptor(jvmType.getPrimitiveType()));
        }
        CompanionObjectMapping companionObjectMapping = new CompanionObjectMapping(builtIns);
        for (ClassDescriptor descriptor2 : companionObjectMapping.allClassesWithIntrinsicCompanions()) {
            ClassDescriptor companion = descriptor2.getCompanionObjectDescriptor();
            assert (companion != null) : "No companion object found for " + descriptor2;
            this.add(ClassId.topLevel(new FqName("kotlin.jvm.internal." + descriptor2.getName().asString() + "CompanionObject")), companion);
        }
        for (int i = 0; i < 23; ++i) {
            this.add(ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + i)), builtIns.getFunction(i));
            FunctionClassDescriptor.Kind kFunction = FunctionClassDescriptor.Kind.KFunction;
            String kFun = kFunction.getPackageFqName() + "." + kFunction.getClassNamePrefix();
            this.addKotlinToJava(new FqNameUnsafe(kFun + i), ClassId.topLevel(new FqName(kFun)));
        }
        this.addKotlinToJava(builtIns.getNothing(), JavaToKotlinClassMap.classId(Void.class));
    }

    @Nullable
    public ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapJavaToKotlin"));
        }
        return this.javaToKotlin.get(fqName2);
    }

    @Nullable
    public ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinFqName", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapKotlinToJava"));
        }
        return this.kotlinToJava.get(kotlinFqName);
    }

    private void add(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinMutableDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "add"));
        }
        ClassId javaClassId = JavaToKotlinClassMap.classId(javaClass);
        this.add(javaClassId, kotlinDescriptor);
        this.addKotlinToJava(kotlinMutableDescriptor, javaClassId);
        this.mutableToReadOnly.put(kotlinMutableDescriptor, kotlinDescriptor);
        this.readOnlyToMutable.put(kotlinDescriptor, kotlinMutableDescriptor);
    }

    private void add(@NotNull ClassId javaClassId, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "add"));
        }
        this.addJavaToKotlin(javaClassId, kotlinDescriptor);
        this.addKotlinToJava(kotlinDescriptor, javaClassId);
    }

    private void add(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "add"));
        }
        this.add(JavaToKotlinClassMap.classId(javaClass), kotlinDescriptor);
    }

    private void addJavaToKotlin(@NotNull ClassId javaClassId, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "addJavaToKotlin"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "addJavaToKotlin"));
        }
        this.javaToKotlin.put(javaClassId.asSingleFqName(), kotlinDescriptor);
    }

    private void addKotlinToJava(@NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassId javaClassId) {
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        this.addKotlinToJava(DescriptorUtils.getFqName(kotlinDescriptor), javaClassId);
    }

    private void addKotlinToJava(@NotNull FqNameUnsafe kotlinFqName, @NotNull ClassId javaClassId) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinFqName", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        this.kotlinToJava.put(kotlinFqName, javaClassId);
    }

    @NotNull
    private static ClassId classId(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "classId"));
        }
        assert (!clazz.isPrimitive() && !clazz.isArray()) : "Invalid class: " + clazz;
        Class<?> outer = clazz.getDeclaringClass();
        ClassId classId = outer == null ? ClassId.topLevel(new FqName(clazz.getCanonicalName())) : JavaToKotlinClassMap.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "classId"));
        }
        return classId;
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        ClassDescriptor kotlinAnalog = this.mapJavaToKotlin(fqName2);
        if (kotlinAnalog == null) {
            Set<ClassDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
            }
            return set;
        }
        ClassDescriptor kotlinMutableAnalog = this.readOnlyToMutable.get(kotlinAnalog);
        if (kotlinMutableAnalog == null) {
            Set<ClassDescriptor> set = Collections.singleton(kotlinAnalog);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
            }
            return set;
        }
        List<ClassDescriptor> list = Arrays.asList(kotlinAnalog, kotlinMutableAnalog);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        FqNameUnsafe className = DescriptorUtils.getFqName(classDescriptor);
        Collection<ClassDescriptor> collection = className.isSafe() ? this.mapPlatformClass(className.toSafe()) : Collections.emptySet();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return collection;
    }

    public boolean isMutable(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutable", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "isMutable"));
        }
        return this.mutableToReadOnly.containsKey(mutable);
    }

    public boolean isMutable(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "isMutable"));
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isMutable(classDescriptor);
    }

    public boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        if (readOnly == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnly", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "isReadOnly"));
        }
        return this.readOnlyToMutable.containsKey(readOnly);
    }

    public boolean isReadOnly(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "isReadOnly"));
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isReadOnly(classDescriptor);
    }

    @NotNull
    public ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutable", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "convertMutableToReadOnly"));
        }
        ClassDescriptor readOnly = this.mutableToReadOnly.get(mutable);
        if (readOnly == null) {
            throw new IllegalArgumentException("Given class " + mutable + " is not a mutable collection");
        }
        ClassDescriptor classDescriptor = readOnly;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "convertMutableToReadOnly"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        if (readOnly == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnly", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "convertReadOnlyToMutable"));
        }
        ClassDescriptor mutable = this.readOnlyToMutable.get(readOnly);
        if (mutable == null) {
            throw new IllegalArgumentException("Given class " + readOnly + " is not a read-only collection");
        }
        ClassDescriptor classDescriptor = mutable;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/platform/JavaToKotlinClassMap", "convertReadOnlyToMutable"));
        }
        return classDescriptor;
    }
}

